/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity;

import igentuman.nc.block.ISizeToggable;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.content.storage.BarrelBlocks;
import igentuman.nc.setup.registration.NCStorageBlocks;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class BarrelBE
extends NuclearCraftBE
implements ISizeToggable {
    public final FluidTank fluidTank;
    protected final LazyOptional<IFluidHandler> fluidHandler;
    public static final ModelProperty<HashMap<Integer, ISizeToggable.SideMode>> SIDE_CONFIG = new ModelProperty();
    public boolean syncSideConfig = true;

    private FluidTank createTank() {
        return new FluidTank(BarrelBlocks.all().get(this.getName()).config().getCapacity()){

            public void setFluid(FluidStack fluid) {
                super.setFluid(fluid);
                BarrelBE.this.m_6596_();
            }
        };
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    public BarrelBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)NCStorageBlocks.STORAGE_BE.get(BarrelBE.getName(pBlockState)).get(), pPos, pBlockState);
        for (Direction direction : Direction.values()) {
            this.sideConfig.put(direction.ordinal(), ISizeToggable.SideMode.DEFAULT);
        }
        this.fluidTank = this.createTank();
        this.fluidHandler = LazyOptional.of(() -> this.fluidTank);
    }

    @Nonnull
    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(SIDE_CONFIG, (Object)this.sideConfig).build();
    }

    public void tickClient() {
    }

    public void tickServer() {
        this.transferFluid();
    }

    protected void transferFluid() {
        AtomicInteger currentAmount = new AtomicInteger(this.fluidTank.getFluidAmount());
        boolean wasUpdated = false;
        for (Direction direction : Direction.values()) {
            IFluidHandler sideHandler;
            BlockEntity be;
            if (this.sideConfig.get(direction.ordinal()) == ISizeToggable.SideMode.DISABLED || this.sideConfig.get(direction.ordinal()) == ISizeToggable.SideMode.DEFAULT || (be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction))) == null || (sideHandler = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).orElse(null)) == null) continue;
            if (currentAmount.get() > 0 && this.sideConfig.get(direction.ordinal()) == ISizeToggable.SideMode.OUT) {
                int accepted = sideHandler.fill(this.fluidTank.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
                if (accepted > 0) {
                    this.fluidTank.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
                    wasUpdated = true;
                }
                currentAmount.addAndGet(-accepted);
                continue;
            }
            if (currentAmount.get() >= this.getTankCapacity() || this.sideConfig.get(direction.ordinal()) != ISizeToggable.SideMode.IN) continue;
            int extracted = this.fluidTank.fill(sideHandler.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
            if (extracted > 0) {
                sideHandler.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
                wasUpdated = true;
            }
            currentAmount.addAndGet(extracted);
        }
        if (wasUpdated) {
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private int getTankCapacity() {
        return BarrelBlocks.all().get(this.getName()).config().getCapacity();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null && this.sideConfig.get(side.ordinal()) != ISizeToggable.SideMode.DISABLED) {
            return this.getFluidHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag tank = new CompoundTag();
        tag.m_128365_("Fluid", (Tag)this.fluidTank.getFluid().writeToNBT(tank));
        tag.m_128385_("sideConfig", this.sideConfig.values().stream().mapToInt(Enum::ordinal).toArray());
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Fluid")) {
            this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid")));
        }
        if (!tag.m_128441_("sideConfig")) {
            return;
        }
        this.loadSideConfig(tag.m_128465_("sideConfig"));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Fluid")) {
            this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid")));
        }
        if (!tag.m_128441_("sideConfig")) {
            return;
        }
        this.loadSideConfig(tag.m_128465_("sideConfig"));
    }

    private void loadSideConfig(int[] tagData) {
        boolean changed = false;
        for (int i = 0; i < this.sideConfig.size(); ++i) {
            ISizeToggable.SideMode newMode = ISizeToggable.SideMode.values()[tagData[i]];
            if (this.sideConfig.get(i) == newMode) continue;
            changed = true;
            this.sideConfig.remove(i);
            this.sideConfig.put(i, newMode);
        }
        if (changed) {
            this.requestModelDataUpdate();
            if (this.f_58857_ == null) {
                return;
            }
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag tank = new CompoundTag();
        tag.m_128365_("Fluid", (Tag)this.fluidTank.getFluid().writeToNBT(tank));
        tag.m_128385_("sideConfig", this.sideConfig.values().stream().mapToInt(Enum::ordinal).toArray());
    }

    @Override
    public ISizeToggable.SideMode toggleSideConfig(int direction) {
        this.sideConfig.put(direction, ISizeToggable.SideMode.values()[(((ISizeToggable.SideMode)((Object)this.sideConfig.get(direction))).ordinal() + 1) % 4]);
        this.m_6596_();
        this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return (ISizeToggable.SideMode)((Object)this.sideConfig.get(direction));
    }
}

