/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.BarrelBE;
import igentuman.nc.content.storage.BarrelBlocks;
import igentuman.nc.network.toServer.PacketStorageSideConfig;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCStorageBlocks;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class BarrelBlock
extends Block
implements EntityBlock {
    public BarrelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            BarrelBE be = (BarrelBE)level.m_7702_(pos);
            ItemStack handStack = player.m_21120_(hand);
            IFluidHandler barrel = (IFluidHandler)be.getFluidHandler().orElse(null);
            if (handStack.m_41720_().equals(NCItems.MULTITOOL.get())) {
                Direction dirToChange = result.m_82434_();
                if (player.m_6144_()) {
                    dirToChange = dirToChange.m_122424_();
                }
                NuclearCraft.packetHandler().sendToServer(new PacketStorageSideConfig(pos, dirToChange.ordinal()));
            } else if (!handStack.equals(ItemStack.f_41583_)) {
                int amount;
                if (handStack.m_41720_() instanceof BucketItem) {
                    Fluid to = ((BucketItem)handStack.m_41720_()).getFluid();
                    if (to == null || to == FluidStack.EMPTY.getFluid()) {
                        if (!barrel.getFluidInTank(0).isEmpty() && barrel.getFluidInTank(0).getAmount() >= 1000) {
                            ItemStack bucket = new ItemStack((ItemLike)barrel.getFluidInTank(0).getFluid().m_6859_());
                            barrel.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            if (handStack.m_41613_() == 1) {
                                player.m_21008_(hand, bucket);
                            } else {
                                handStack.m_41774_(1);
                                if (!player.m_150109_().m_36054_(bucket)) {
                                    player.m_36176_(bucket, false);
                                }
                            }
                        }
                    } else {
                        int filled = barrel.fill(new FluidStack(to, 1000), IFluidHandler.FluidAction.SIMULATE);
                        if (filled == 1000) {
                            barrel.fill(new FluidStack(to, 1000), IFluidHandler.FluidAction.EXECUTE);
                            if (player.m_7500_()) {
                                return InteractionResult.SUCCESS;
                            }
                            if (handStack.m_41613_() == 1) {
                                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                            } else {
                                handStack.m_41774_(1);
                                if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)to.m_6859_()))) {
                                    player.m_36176_(new ItemStack((ItemLike)to.m_6859_()), false);
                                }
                            }
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                IFluidHandlerItem fluidCap = (IFluidHandlerItem)handStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                if (fluidCap == null) {
                    return InteractionResult.SUCCESS;
                }
                FluidStack inhandFluid = fluidCap.getFluidInTank(0);
                if ((inhandFluid == null || inhandFluid.isEmpty()) && (amount = barrel.fill(inhandFluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    fluidCap.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                FluidStack fluid = FluidStack.EMPTY;
                fluid = ((IFluidHandler)be.getFluidHandler().orElseGet(null)).getFluidInTank(0);
                int storage = BarrelBlocks.all().get(this.code()).getCapacity();
                if (fluid == null || fluid.isEmpty()) {
                    player.m_213846_((Component)Component.m_237110_((String)"tooltip.nc.liquid_empty", (Object[])new Object[]{this.formatLiquid(storage)}).m_130940_(ChatFormatting.BLUE));
                } else {
                    player.m_213846_((Component)Component.m_237110_((String)"tooltip.nc.liquid_stored", (Object[])new Object[]{fluid.getDisplayName(), this.formatLiquid(fluid.getAmount()), this.formatLiquid(storage)}).m_130940_(ChatFormatting.BLUE));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)NCStorageBlocks.STORAGE_BE.get(this.code()).get()).m_155264_(pPos, pState);
    }

    public String code() {
        return this.m_5456_().toString();
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof BarrelBE) {
                    BarrelBE tile = (BarrelBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof BarrelBE) {
                BarrelBE tile = (BarrelBE)t;
                tile.tickServer();
            }
        };
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41782_()) {
            BarrelBE tileEntity = (BarrelBE)world.m_7702_(pos);
            CompoundTag nbtData = stack.m_41783_();
            tileEntity.m_142466_(nbtData);
        }
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @javax.annotation.Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        pPlayer.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        pPlayer.m_36399_(0.005f);
        BarrelBE BarrelBE2 = (BarrelBE)pBlockEntity;
        CompoundTag data = BarrelBE2.m_5995_();
        ItemStack drop = new ItemStack((ItemLike)this);
        drop.m_41751_(data);
        if (!pLevel.m_5776_()) {
            ItemEntity itemEntity = new ItemEntity(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), drop);
            itemEntity.m_32060_();
            pLevel.m_7967_((Entity)itemEntity);
        }
    }

    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter world, List<Component> list, TooltipFlag flag) {
        int storage = BarrelBlocks.all().get(this.code()).config().getCapacity();
        list.add((Component)Component.m_237110_((String)"tooltip.nc.liquid_capacity", (Object[])new Object[]{this.formatLiquid(storage)}).m_130940_(ChatFormatting.BLUE));
        list.add((Component)Component.m_237115_((String)"tooltip.nc.use_multitool").m_130940_(ChatFormatting.YELLOW));
    }

    public String formatLiquid(int val) {
        return TextUtils.numberFormat(val / 1000) + " B";
    }
}

