/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.theme;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.util.Color;

public class ThemeSerializer
implements JsonDeserializer<Theme> {
    private static int readColor(JsonElement el, int fallback) {
        if (el == null || el.isJsonNull()) {
            return fallback;
        }
        JsonPrimitive e = el.getAsJsonPrimitive();
        if (e.isString()) {
            try {
                return Color.valueOf(e.getAsString()).toInt();
            }
            catch (Throwable e2) {
                return 0;
            }
        }
        return e.getAsInt();
    }

    private static void readImage(JsonObject o, String imageKey, Consumer<ResourceLocation> imageConsumer, Consumer<int[]> uvConsumer) {
        if (o.has(imageKey)) {
            JsonArray array = o.getAsJsonArray(imageKey);
            Preconditions.checkArgument((array.size() == 9 ? 1 : 0) != 0, (Object)(imageKey + " must have 9 elements"));
            imageConsumer.accept(new ResourceLocation(array.get(0).getAsString()));
            int[] uv = new int[8];
            for (int i = 0; i < 8; ++i) {
                uv[i] = array.get(i + 1).getAsInt();
            }
            uvConsumer.accept(uv);
        }
    }

    public Theme deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        int i;
        JsonArray array;
        JsonObject o = json.getAsJsonObject();
        if (GsonHelper.m_13824_((JsonObject)o, (String)"version", (int)0) > 1) {
            throw new JsonParseException("Unsupported theme version");
        }
        Theme theme = new Theme();
        if (o.has("backgroundImage")) {
            ThemeSerializer.readImage(o, "backgroundImage", $ -> {
                theme.backgroundTexture = $;
            }, $ -> {
                theme.backgroundTextureUV = $;
            });
            ThemeSerializer.readImage(o, "backgroundImage_withIcon", $ -> {
                theme.backgroundTexture_withIcon = $;
            }, $ -> {
                theme.backgroundTextureUV_withIcon = $;
            });
        } else {
            theme.backgroundColor = ThemeSerializer.readColor(o.get("backgroundColor"), theme.backgroundColor);
            array = o.get("borderColor").getAsJsonArray();
            Preconditions.checkArgument((array.size() == 4 ? 1 : 0) != 0, (Object)"borderColor must have 4 elements");
            for (i = 0; i < 4; ++i) {
                theme.borderColor[i] = ThemeSerializer.readColor(array.get(i), theme.borderColor[i]);
            }
        }
        theme.titleColor = ThemeSerializer.readColor(o.get("titleColor"), theme.titleColor);
        theme.normalColor = ThemeSerializer.readColor(o.get("normalColor"), theme.normalColor);
        theme.infoColor = ThemeSerializer.readColor(o.get("infoColor"), theme.infoColor);
        theme.successColor = ThemeSerializer.readColor(o.get("successColor"), theme.successColor);
        theme.warningColor = ThemeSerializer.readColor(o.get("warningColor"), theme.warningColor);
        theme.dangerColor = ThemeSerializer.readColor(o.get("dangerColor"), theme.dangerColor);
        theme.failureColor = ThemeSerializer.readColor(o.get("failureColor"), theme.failureColor);
        theme.boxBorderColor = ThemeSerializer.readColor(o.get("boxBorderColor"), theme.boxBorderColor);
        theme.itemAmountColor = ThemeSerializer.readColor(o.get("itemAmountColor"), theme.itemAmountColor);
        theme.bottomProgressNormalColor = ThemeSerializer.readColor(o.get("bottomProgressNormalColor"), theme.bottomProgressNormalColor);
        theme.bottomProgressFailureColor = ThemeSerializer.readColor(o.get("bottomProgressFailureColor"), theme.bottomProgressFailureColor);
        theme.textShadow = GsonHelper.m_13855_((JsonObject)o, (String)"textShadow", (boolean)true);
        if (o.has("padding")) {
            array = o.getAsJsonArray("padding");
            Preconditions.checkArgument((array.size() == 4 ? 1 : 0) != 0, (Object)"padding must have 4 elements");
            for (i = 0; i < 4; ++i) {
                theme.padding[i] = array.get(i).getAsInt();
            }
        }
        if (o.has("squareBorder")) {
            theme.squareBorder = o.get("squareBorder").getAsBoolean();
        }
        theme.opacity = GsonHelper.m_13820_((JsonObject)o, (String)"opacity", (float)0.0f);
        if (o.has("bottomProgressOffset")) {
            array = o.getAsJsonArray("bottomProgressOffset");
            Preconditions.checkArgument((array.size() == 4 ? 1 : 0) != 0, (Object)"bottomProgressOffset must have 4 elements");
            theme.bottomProgressOffset = new int[4];
            for (i = 0; i < 4; ++i) {
                theme.bottomProgressOffset[i] = array.get(i).getAsInt();
            }
        }
        theme.lightColorScheme = GsonHelper.m_13855_((JsonObject)o, (String)"lightColorScheme", (boolean)false);
        theme.hidden = GsonHelper.m_13855_((JsonObject)o, (String)"hidden", (boolean)false);
        return theme;
    }
}

