/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.gui.HomeConfigScreen;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;

public final class JadeClient {
    public static KeyMapping openConfig;
    public static KeyMapping showOverlay;
    public static KeyMapping toggleLiquid;
    public static KeyMapping showDetails;
    public static KeyMapping narrate;
    public static KeyMapping showRecipes;
    public static KeyMapping showUses;
    public static boolean hideModName;
    private static boolean translationChecked;
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;

    public static void init() {
        openConfig = ClientProxy.registerKeyBinding("config", 320);
        showOverlay = ClientProxy.registerKeyBinding("show_overlay", 321);
        toggleLiquid = ClientProxy.registerKeyBinding("toggle_liquid", 322);
        if (ClientProxy.shouldRegisterRecipeViewerKeys()) {
            showRecipes = ClientProxy.registerKeyBinding("show_recipes", 323);
            showUses = ClientProxy.registerKeyBinding("show_uses", 324);
        }
        narrate = ClientProxy.registerKeyBinding("narrate", 325);
        showDetails = ClientProxy.registerDetailsKeyBinding();
        ClientProxy.registerReloadListener(ModIdentification.INSTANCE);
    }

    public static void onKeyPressed(int action) {
        while (openConfig.m_90859_()) {
            Jade.CONFIG.invalidate();
            ItemStorageProvider.INSTANCE.targetCache.invalidateAll();
            ItemStorageProvider.INSTANCE.containerCache.invalidateAll();
            Minecraft.m_91087_().m_91152_((Screen)new HomeConfigScreen(null));
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        while (showOverlay.m_90859_()) {
            IWailaConfig.DisplayMode mode = general.getDisplayMode();
            if (mode != IWailaConfig.DisplayMode.TOGGLE) continue;
            general.setDisplayTooltip(!general.shouldDisplayTooltip());
            if (!general.shouldDisplayTooltip() && general.hintOverlayToggle) {
                Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237115_((String)"toast.jade.toggle_hint.1"), false);
                Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237110_((String)"toast.jade.toggle_hint.2", (Object[])new Object[]{showOverlay.m_90863_()}), false);
                general.hintOverlayToggle = false;
            }
            Jade.CONFIG.save();
        }
        while (toggleLiquid.m_90859_()) {
            general.setDisplayFluids(!general.shouldDisplayFluids());
            Jade.CONFIG.save();
        }
        while (narrate.m_90859_()) {
            if (general.getTTSMode() == IWailaConfig.TTSMode.TOGGLE) {
                general.toggleTTS();
                if (general.shouldEnableTextToSpeech() && general.hintNarratorToggle) {
                    Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237115_((String)"toast.jade.tts_hint.1"), false);
                    Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237110_((String)"toast.jade.tts_hint.2", (Object[])new Object[]{narrate.m_90863_()}), false);
                    general.hintNarratorToggle = false;
                }
                Jade.CONFIG.save();
                continue;
            }
            if (WailaTickHandler.instance().tooltipRenderer == null) continue;
            WailaTickHandler.narrate(WailaTickHandler.instance().tooltipRenderer.getTooltip(), false);
        }
    }

    public static void onGui(Screen screen) {
        if (!translationChecked && screen instanceof TitleScreen && CommonProxy.isDevEnv()) {
            translationChecked = true;
            ArrayList keys = Lists.newArrayList();
            for (ResourceLocation id : PluginConfig.INSTANCE.getKeys()) {
                String key = "config.jade.plugin_%s.%s".formatted(id.m_135827_(), id.m_135815_());
                if (I18n.m_118936_((String)key)) continue;
                keys.add(key);
            }
            if (!keys.isEmpty()) {
                throw new AssertionError((Object)"Missing config translation: %s".formatted(Joiner.on((char)',').join((Iterable)keys)));
            }
        }
    }

    public static void onTooltip(List<Component> tooltip, ItemStack stack, TooltipFlag context) {
        JadeClient.appendModName(tooltip, stack, context);
        if (Jade.CONFIG.get().getGeneral().isDebug() && stack.m_41782_()) {
            tooltip.add(NbtUtils.m_178061_((Tag)stack.m_41783_()));
        }
    }

    private static void appendModName(List<Component> tooltip, ItemStack stack, TooltipFlag context) {
        int i;
        if (hideModName || tooltip.isEmpty() || !Jade.CONFIG.get().getGeneral().showItemModNameTooltip()) {
            return;
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
            if (!(screen2.f_97734_ == null || screen2.f_97734_.m_7993_() != stack || CreativeModeInventoryScreen.f_98507_.m_257962_() == CreativeModeTab.Type.CATEGORY && context.m_257552_())) {
                return;
            }
        }
        String name = ModIdentification.getModName(stack);
        for (i = 1; i < tooltip.size() && !Objects.equals(tooltip.get(i).getString(), name); ++i) {
        }
        name = String.format(Jade.CONFIG.get().getFormatting().getModName(), name);
        tooltip.add(i, (Component)Component.m_237113_((String)name));
    }

    @Nullable
    public static Accessor<?> builtInOverrides(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (WailaClientRegistration.INSTANCE.maybeLowVisionUser() || !IWailaConfig.get().getGeneral().getBuiltinCamouflage()) {
            return accessor;
        }
        if (accessor instanceof BlockAccessor) {
            BlockState state;
            BlockAccessor target = (BlockAccessor)accessor;
            Player player = accessor.getPlayer();
            if (player.m_7500_() || player.m_5833_()) {
                return accessor;
            }
            IWailaClientRegistration client = VanillaPlugin.CLIENT_REGISTRATION;
            if (target.getBlock() instanceof ChestBlock && (state = VanillaPlugin.getCorrespondingNormalChest(target.getBlockState())) != target.getBlockState()) {
                return client.blockAccessor().from(target).blockState(state).build();
            }
            BlockAccessor.Builder builder = client.blockAccessor().from(target).blockEntity(() -> null);
            if (target.getBlock() instanceof InfestedBlock) {
                Block block = ((InfestedBlock)target.getBlock()).m_54192_();
                return builder.blockState(block.m_49966_()).build();
            }
            if (target.getBlock() == Blocks.f_152499_) {
                Block block = Blocks.f_50127_;
                return builder.blockState(block.m_49966_()).build();
            }
            Block block = target.getBlock();
            if (block instanceof BrushableBlock) {
                BrushableBlock brushable = (BrushableBlock)block;
                block = brushable.m_277074_();
                return builder.blockState(block.m_49966_()).build();
            }
        }
        return accessor;
    }

    public static void drawBreakingProgress(ITooltip tooltip, Rect2i rect, GuiGraphics guiGraphics, Accessor<?> accessor) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        TooltipRenderer tooltipRenderer = WailaTickHandler.instance().tooltipRenderer;
        if (tooltipRenderer == null) {
            progressAlpha = 0.0f;
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        MultiPlayerGameMode playerController = mc.f_91072_;
        if (playerController == null || mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        BlockState state = mc.f_91073_.m_8055_(playerController.f_105191_);
        if (playerController.m_105296_()) {
            canHarvest = CommonProxy.isCorrectToolForDrops(state, (Player)mc.f_91074_);
        } else if (progressAlpha == 0.0f) {
            return;
        }
        Theme theme = IThemeHelper.get().theme();
        int color = canHarvest ? theme.bottomProgressNormalColor : theme.bottomProgressFailureColor;
        int width = (int)tooltipRenderer.getSize().f_82470_;
        int height = (int)tooltipRenderer.getSize().f_82471_;
        if (!IWailaConfig.get().getOverlay().getSquare() && theme.backgroundTexture == null) {
            ++height;
        }
        progressAlpha += mc.m_91297_() * (playerController.m_105296_() ? 0.1f : -0.1f);
        if (playerController.m_105296_()) {
            progressAlpha = Math.min(progressAlpha, 0.6f);
            float progress = state.m_60625_((Player)mc.f_91074_, (BlockGetter)mc.f_91074_.m_9236_(), playerController.f_105191_);
            if (playerController.f_105193_ + progress >= 1.0f) {
                savedProgress = 1.0f;
                progressAlpha = 1.0f;
            } else {
                progress = playerController.f_105193_ + mc.m_91296_() * progress;
                savedProgress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
            }
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        if (progressAlpha == 0.0f) {
            return;
        }
        color = IWailaConfig.IConfigOverlay.applyAlpha(color, progressAlpha);
        if (theme.bottomProgressOffset == null) {
            DisplayHelper.fill(guiGraphics, 0.0f, (float)(height - 1), (float)width * savedProgress, (float)height, color);
        } else {
            int[] offset = theme.bottomProgressOffset;
            int offset0 = offset[0] + 2;
            int offset1 = offset[1] + 2;
            int offset2 = offset[2] + 2;
            int offset3 = offset[3];
            DisplayHelper.fill(guiGraphics, (float)offset3, (float)(height - 1 + offset0), (float)offset3 + (float)(width += offset1 - offset3) * savedProgress, (float)(height + offset2), color);
        }
    }

    public static MutableComponent format(String s, Object ... objects) {
        try {
            return Component.m_237113_((String)MessageFormat.format(I18n.m_118938_((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return Component.m_237110_((String)s, (Object[])objects);
        }
    }
}

