/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.tile;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.data.CachedModel;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class SimChamberTileEntity
extends BlockEntity
implements TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister {
    protected final SimItemHandler inventory = new SimItemHandler();
    protected final ModifiableEnergyStorage energy = new ModifiableEnergyStorage(HostileConfig.simPowerCap, HostileConfig.simPowerCap);
    protected final SimpleDataSlots data = new SimpleDataSlots();
    protected CachedModel currentModel = CachedModel.EMPTY;
    protected int runtime = 0;
    protected boolean predictionSuccess = false;
    protected FailureState failState = FailureState.NONE;

    public SimChamberTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Hostile.TileEntities.SIM_CHAMBER.get(), pos, state);
        this.data.addData(() -> this.runtime, v -> {
            this.runtime = v;
        });
        this.data.addData(() -> this.predictionSuccess, v -> {
            this.predictionSuccess = v;
        });
        this.data.addData(() -> this.failState.ordinal(), v -> {
            this.failState = FailureState.values()[v];
        });
        this.data.addEnergy(this.energy);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("energy", this.energy.getEnergyStored());
        tag.m_128359_("model", !this.currentModel.isValid() ? "null" : DataModelRegistry.INSTANCE.getKey(this.currentModel.getModel()).toString());
        tag.m_128405_("runtime", this.runtime);
        tag.m_128379_("predSuccess", this.predictionSuccess);
        tag.m_128405_("failState", this.failState.ordinal());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.energy.setEnergy(tag.m_128451_("energy"));
        ItemStack model = this.inventory.getStackInSlot(0);
        CachedModel cModel = this.getOrLoadModel(model);
        ResourceLocation modelId = new ResourceLocation(tag.m_128461_("model"));
        if (cModel.isValid() && DataModelRegistry.INSTANCE.getKey(cModel.getModel()).equals((Object)modelId)) {
            this.currentModel = cModel;
        }
        this.runtime = tag.m_128451_("runtime");
        this.predictionSuccess = tag.m_128471_("predSuccess");
        this.failState = FailureState.values()[tag.m_128451_("failState")];
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        ItemStack model = this.inventory.getStackInSlot(0);
        if (!model.m_41619_()) {
            CachedModel oldModel = this.currentModel;
            this.currentModel = this.getOrLoadModel(model);
            if (oldModel != this.currentModel) {
                this.runtime = 0;
            }
            if (this.currentModel.isValid()) {
                if (this.currentModel.getTier() == ModelTier.FAULTY) {
                    this.failState = FailureState.FAULTY;
                    this.runtime = 0;
                    return;
                }
                if (this.runtime == 0) {
                    if (this.canStartSimulation()) {
                        this.runtime = 300;
                        this.predictionSuccess = this.f_58857_.f_46441_.m_188501_() <= this.currentModel.getAccuracy();
                        this.inventory.getStackInSlot(1).m_41774_(1);
                        this.m_6596_();
                    }
                } else if (this.hasPowerFor(this.currentModel.getModel())) {
                    this.failState = FailureState.NONE;
                    if (--this.runtime == 0) {
                        ModelTier tier;
                        ItemStack stk = this.inventory.getStackInSlot(2);
                        if (stk.m_41619_()) {
                            this.inventory.setStackInSlot(2, this.currentModel.getModel().baseDrop().m_41777_());
                        } else {
                            stk.m_41769_(1);
                        }
                        if (this.predictionSuccess) {
                            stk = this.inventory.getStackInSlot(3);
                            if (stk.m_41619_()) {
                                this.inventory.setStackInSlot(3, this.currentModel.getPredictionDrop());
                            } else {
                                stk.m_41769_(1);
                            }
                        }
                        if ((tier = this.currentModel.getTier()) != tier.next() && HostileConfig.simModelUpgrade > 0) {
                            int newData = this.currentModel.getData() + 1;
                            if (HostileConfig.simModelUpgrade != 2 || newData <= this.currentModel.getNextTierData()) {
                                this.currentModel.setData(newData);
                            }
                        }
                        DataModelItem.setIters(model, DataModelItem.getIters(model) + 1);
                        this.m_6596_();
                    } else if (this.runtime != 0) {
                        this.energy.setEnergy(this.energy.getEnergyStored() - this.currentModel.getModel().simCost());
                        this.m_6596_();
                    }
                } else {
                    this.failState = FailureState.ENERGY_MID_CYCLE;
                }
                return;
            }
        }
        this.failState = FailureState.MODEL;
        this.runtime = 0;
    }

    public boolean canStartSimulation() {
        if (this.inventory.getStackInSlot(1).m_41619_()) {
            this.failState = FailureState.INPUT;
            return false;
        }
        DataModel model = this.currentModel.getModel();
        ItemStack nOut = this.inventory.getStackInSlot(2);
        ItemStack pOut = this.inventory.getStackInSlot(3);
        ItemStack nOutExp = model.baseDrop();
        ItemStack pOutExp = this.currentModel.getPredictionDrop();
        if (this.canStack(nOut, nOutExp) && this.canStack(pOut, pOutExp)) {
            if (this.hasPowerFor(model)) {
                this.failState = FailureState.NONE;
                return true;
            }
            this.failState = FailureState.ENERGY;
            return false;
        }
        this.failState = FailureState.OUTPUT;
        return false;
    }

    public boolean canStack(ItemStack a, ItemStack b) {
        if (a.m_41619_()) {
            return true;
        }
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b) && a.m_41613_() < a.m_41741_();
    }

    public boolean hasPowerFor(DataModel model) {
        return this.energy.getEnergyStored() >= model.simCost();
    }

    protected CachedModel getOrLoadModel(ItemStack stack) {
        if (this.currentModel.getSourceStack() == stack) {
            return this.currentModel;
        }
        return new CachedModel(stack, 0);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.energy).cast();
        }
        return super.getCapability(cap, side);
    }

    public SimItemHandler getInventory() {
        return this.inventory;
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public boolean didPredictionSucceed() {
        return this.predictionSuccess;
    }

    public FailureState getFailState() {
        return this.failState;
    }

    public class SimItemHandler
    extends InternalItemHandler {
        public SimItemHandler() {
            super(4);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.m_41720_() instanceof DataModelItem;
            }
            if (slot == 1) {
                return DataModelItem.matchesInput(this.getStackInSlot(0), stack);
            }
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot > 1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot <= 1) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            SimChamberTileEntity.this.m_6596_();
        }
    }

    public static enum FailureState {
        NONE("none"),
        OUTPUT("output"),
        ENERGY("energy"),
        INPUT("input"),
        MODEL("model"),
        FAULTY("faulty"),
        ENERGY_MID_CYCLE("energy_mid_cycle");

        private final String name;

        private FailureState(String name) {
            this.name = name;
        }

        public String getKey() {
            return "hostilenetworks.fail." + this.name;
        }
    }
}

