/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.data;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import net.minecraft.resources.ResourceLocation;

public class ModelTierRegistry
extends DynamicRegistry<ModelTier.TierData> {
    public static final ModelTierRegistry INSTANCE = new ModelTierRegistry();

    public ModelTierRegistry() {
        super(HostileNetworks.LOGGER, "model_tiers", true, false);
        for (ModelTier tier : ModelTier.values()) {
            this.holder(HostileNetworks.loc(tier.name));
        }
    }

    protected void onReload() {
        super.onReload();
        for (ModelTier tier : ModelTier.values()) {
            String name = tier.name;
            Preconditions.checkNotNull((Object)((ModelTier.TierData)this.getValue(HostileNetworks.loc(name))), (Object)("Missing builtin model tier: " + name));
        }
        Preconditions.checkArgument((this.getValues().size() == ModelTier.values().length ? 1 : 0) != 0, (Object)"Registration of additional model tiers is currently not supported!");
        for (ModelTier tier : ModelTier.values()) {
            tier.updateData((ModelTier.TierData)this.getValue(HostileNetworks.loc(tier.name)));
        }
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(HostileNetworks.loc("tier_data"), ModelTier.TierData.CODEC);
    }

    protected void validateItem(ResourceLocation key, ModelTier.TierData value) {
        super.validateItem(key, (CodecProvider)value);
        if (this.isTier(key, ModelTier.FAULTY)) {
            Preconditions.checkArgument((value.requiredData() == 0 ? 1 : 0) != 0, (Object)"Faulty tier cannot require any data!");
        } else if (this.isTier(key, ModelTier.SELF_AWARE)) {
            Preconditions.checkArgument((value.dataPerKill() == 0 ? 1 : 0) != 0, (Object)"Self-aware tier cannot be upgraded further!");
        }
    }

    private boolean isTier(ResourceLocation key, ModelTier tier) {
        return key.m_135815_().equals(tier.name);
    }
}

