/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip;

import org.zeith.hammerlib.tiles.tooltip.EnumNumberFormat;

public class ProgressBar {
    protected long maxValue = 100L;
    protected long value = 0L;
    public EnumNumberFormat numberFormat = EnumNumberFormat.COMPACT;
    public String prefix;
    public String suffix;
    public int backgroundColor;
    public int borderColor;
    public int filledMainColor;
    public int filledAlternateColor;

    public ProgressBar(long maxValue) {
        if (maxValue < 1L) {
            throw new IndexOutOfBoundsException("maxValue");
        }
        this.maxValue = maxValue;
    }

    public ProgressBar withNumberFormat(EnumNumberFormat format) {
        this.numberFormat = format;
        return this;
    }

    public ProgressBar withStyle(ProgressBarStyle style) {
        return style.apply(this);
    }

    public float getProgress() {
        return (float)((double)this.value / (double)this.maxValue);
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public ProgressBar setMaxValue(long maxValue) {
        if (maxValue < 1L) {
            throw new IndexOutOfBoundsException("maxValue");
        }
        this.maxValue = maxValue;
        return this;
    }

    public int getProgressPercent() {
        return (int)Math.round((double)this.value / (double)this.maxValue * 100.0);
    }

    public ProgressBar setProgress(long value) {
        if (value < 0L) {
            value = 0L;
        }
        if (value > this.maxValue) {
            value = this.maxValue;
        }
        this.value = value;
        return this;
    }

    public record ProgressBarStyle(int backgroundColor, int borderColor, int filledMainColor, int filledAlternateColor) {
        public static final ProgressBarStyle FORGE_ENERGY_STYLE = new ProgressBarStyle(-13158601, -7631989, -2738891, -57055);

        public <T extends ProgressBar> T apply(T bar) {
            bar.backgroundColor = this.backgroundColor;
            bar.borderColor = this.borderColor;
            bar.filledMainColor = this.filledMainColor;
            bar.filledAlternateColor = this.filledAlternateColor;
            return bar;
        }
    }
}

