/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.client.render;

public class ColorData {
    float a;
    float r;
    float g;
    float b;

    public ColorData(float a, float r, float g, float b) {
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public ColorData(float r, float g, float b) {
        this(1.0f, r, g, b);
    }

    public ColorData(int a, int r, int g, int b) {
        this((float)a / 255.0f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ColorData(int r, int g, int b) {
        this(255, r, g, b);
    }

    public ColorData(int argb) {
        this(argb >>> 24 & 0xFF, argb >>> 16 & 0xFF, argb >>> 8 & 0xFF, argb & 0xFF);
    }

    public float getAf() {
        return this.a;
    }

    public float getRf() {
        return this.r;
    }

    public float getGf() {
        return this.g;
    }

    public float getBf() {
        return this.b;
    }

    public int getAi() {
        return (int)(this.a * 255.0f);
    }

    public int getRi() {
        return (int)(this.r * 255.0f);
    }

    public int getGi() {
        return (int)(this.g * 255.0f);
    }

    public int getBi() {
        return (int)(this.b * 255.0f);
    }

    public int toARGB() {
        return this.getAi() << 24 | this.getRi() << 16 | this.getGi() << 8 | this.getBi();
    }

    public int toRGBA() {
        return this.getRi() << 24 | this.getGi() << 16 | this.getBi() << 8 | this.getAi();
    }

    public int toRGB() {
        return this.getRi() << 16 | this.getGi() << 8 | this.getBi();
    }

    public String toString() {
        return "[a=%s, r=%s, g=%s, b=%s]".formatted(Float.valueOf(this.a), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }

    public int hashCode() {
        return this.toARGB();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColorData) {
            ColorData cd = (ColorData)obj;
            return cd.toARGB() == this.toARGB();
        }
        return false;
    }
}

