/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.cache;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.api.predicate.fullface.FullFacePredicate;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;

public class StateCache {
    private static final Direction[] DIRECTIONS = Direction.values();
    protected static final int DIR_COUNT = DIRECTIONS.length;
    protected static final int DIR_COUNT_N = DIR_COUNT + 1;
    public static final StateCache EMPTY = new StateCache();
    private final boolean anyFullFace;
    private final boolean[] fullFace;
    private final boolean[] conFullEdge;
    private final boolean[] conDetailed;

    public StateCache(BlockState state, IBlockType type) {
        boolean anyFullFace = false;
        boolean anyConDetailed = false;
        boolean[] fullFace = new boolean[DIR_COUNT];
        boolean[] conFullEdge = new boolean[DIR_COUNT * DIR_COUNT_N];
        boolean[] conDetailed = new boolean[DIR_COUNT * DIR_COUNT];
        FullFacePredicate facePred = type.getFullFacePredicate();
        ConnectionPredicate conPred = type.getConnectionPredicate();
        boolean supportsCt = type.supportsConnectedTextures();
        for (Direction side : DIRECTIONS) {
            int sideOrd = side.ordinal();
            boolean full = facePred.test(state, side);
            anyFullFace |= full;
            fullFace[sideOrd] = full;
            if (!supportsCt) continue;
            int feNullIdx = sideOrd * DIR_COUNT_N + Utils.maskNullDirection(null);
            conFullEdge[feNullIdx] = conPred.canConnectFullEdge(state, side, null);
            for (Direction edge : DIRECTIONS) {
                int feIdx = sideOrd * DIR_COUNT_N + Utils.maskNullDirection(edge);
                if (edge.m_122434_() == side.m_122434_()) {
                    conFullEdge[feIdx] = conFullEdge[feNullIdx];
                    continue;
                }
                conFullEdge[feIdx] = conPred.canConnectFullEdge(state, side, edge);
                boolean detailed = conPred.canConnectDetailed(state, side, edge);
                anyConDetailed |= detailed;
                int dIdx = sideOrd * DIR_COUNT + edge.ordinal();
                conDetailed[dIdx] = detailed;
            }
        }
        this.anyFullFace = anyFullFace;
        this.fullFace = (boolean[])(anyFullFace ? fullFace : null);
        this.conFullEdge = (boolean[])(supportsCt ? conFullEdge : null);
        this.conDetailed = (boolean[])(anyConDetailed ? conDetailed : null);
    }

    private StateCache() {
        this.anyFullFace = false;
        this.fullFace = null;
        this.conFullEdge = null;
        this.conDetailed = null;
    }

    public final boolean hasAnyFullFace() {
        return this.anyFullFace;
    }

    public final boolean isFullFace(@Nullable Direction side) {
        return side != null && this.anyFullFace && this.fullFace[side.ordinal()];
    }

    public final boolean canConnectFullEdge(Direction side, @Nullable Direction edge) {
        return this.conFullEdge != null && this.conFullEdge[side.ordinal() * DIR_COUNT_N + Utils.maskNullDirection(edge)];
    }

    public final boolean canConnectDetailed(Direction side, Direction edge) {
        return this.conDetailed != null && this.conDetailed[side.ordinal() * DIR_COUNT + edge.ordinal()];
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public final boolean hasAnyDetailedConnections() {
        return this.conDetailed != null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        StateCache that = (StateCache)other;
        return this.anyFullFace == that.anyFullFace && Arrays.equals(this.fullFace, that.fullFace) && Arrays.equals(this.conFullEdge, that.conFullEdge) && Arrays.equals(this.conDetailed, that.conDetailed);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.anyFullFace);
        result = 31 * result + Arrays.hashCode(this.fullFace);
        result = 31 * result + Arrays.hashCode(this.conFullEdge);
        result = 31 * result + Arrays.hashCode(this.conDetailed);
        return result;
    }
}

