/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.RecipeInventory;
import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AutoFluxCrafterContainer;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.tileentity.FluxCrafterTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class AutoFluxCrafterTileEntity
extends FluxCrafterTileEntity
implements MenuProvider {
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private final BaseEnergyStorage energy = new BaseEnergyStorage(((Integer)ModConfigs.AUTO_FLUX_CRAFTER_POWER_CAPACITY.get()).intValue(), () -> ((AutoFluxCrafterTileEntity)this).setChangedFast());
    private final TableRecipeStorage recipeStorage = new TableRecipeStorage(10);

    public AutoFluxCrafterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.AUTO_FLUX_CRAFTER.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Energy", this.energy.serializeNBT());
        tag.m_128391_(this.recipeStorage.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
        this.recipeStorage.deserializeNBT(tag);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.getRecipeStorage().onLoad(this.f_58857_, (RecipeType<? extends Recipe<Container>>)((RecipeType)ModRecipeTypes.FLUX_CRAFTER.get()));
        }
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return AutoFluxCrafterContainer.create(windowId, playerInventory, this.getInventory(), this.m_58899_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == ForgeCapabilities.ENERGY) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, this.energyCapability);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public TableRecipeStorage getRecipeStorage() {
        return this.recipeStorage;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutoFluxCrafterTileEntity tile) {
        int selected;
        FluxCrafterTileEntity.tick(level, pos, state, tile);
        int insertPowerRate = (Integer)ModConfigs.AUTO_FLUX_CRAFTER_INSERT_POWER_RATE.get();
        if (tile.getEnergy().getEnergyStored() >= insertPowerRate && (selected = tile.getRecipeStorage().getSelected()) != -1) {
            tile.getAboveInventory().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    boolean inserted;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_() || handler.extractItem(i, 1, true).m_41619_() || !(inserted = tile.tryInsertItemIntoGrid(stack))) continue;
                    handler.extractItem(i, 1, false);
                    break;
                }
            });
        }
    }

    public void selectRecipe(int index) {
        this.getRecipeStorage().setSelected(index);
        this.setChangedAndDispatch();
    }

    public void saveRecipe(int index) {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        RecipeInventory inventory = this.getInventory().toRecipeInventory(0, 9);
        IFluxCrafterRecipe recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.FLUX_CRAFTER.get(), (Container)inventory, level).orElse(null);
        ItemStack result = ItemStack.f_41583_;
        if (recipe != null) {
            result = recipe.m_5874_((Container)inventory, level.m_9598_());
        }
        this.getRecipeStorage().setRecipe(index, (Container)inventory, result);
        this.setChangedAndDispatch();
    }

    public void deleteRecipe(int index) {
        this.getRecipeStorage().unsetRecipe(index);
        this.setChangedAndDispatch();
    }

    public BaseEnergyStorage getEnergy() {
        return this.energy;
    }

    private void addStackToSlot(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackInSlot = inventory.getStackInSlot(slot);
        if (stackInSlot.m_41619_()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)stackInSlot, (int)stack.m_41613_()));
        }
    }

    private LazyOptional<IItemHandler> getAboveInventory() {
        BlockEntity tile;
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_().m_7494_();
        if (level != null && (tile = level.m_7702_(pos)) != null) {
            return tile.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        }
        return LazyOptional.empty();
    }

    private boolean tryInsertItemIntoGrid(ItemStack input) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackToPut = ItemStack.f_41583_;
        BaseItemStackHandler recipe = this.getRecipeStorage().getSelectedRecipe();
        int slotToPut = -1;
        boolean isGridChanged = false;
        int slots = inventory.getSlots() - 1;
        for (int i = 0; i < slots; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            ItemStack recipeStack = recipe.getStackInSlot(i);
            if (!slot.m_41619_() && !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)slot) || !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)recipeStack) || !slot.m_41619_() && slot.m_41613_() >= slot.m_41741_()) continue;
            if (slot.m_41619_()) {
                slotToPut = i;
                isGridChanged = true;
                break;
            }
            if (!stackToPut.m_41619_() && slot.m_41613_() >= stackToPut.m_41613_()) continue;
            slotToPut = i;
            stackToPut = slot;
        }
        this.isGridChanged = isGridChanged;
        if (slotToPut > -1) {
            int insertPowerRate = (Integer)ModConfigs.AUTO_FLUX_CRAFTER_INSERT_POWER_RATE.get();
            ItemStack toInsert = StackHelper.withSize((ItemStack)input, (int)1, (boolean)false);
            this.addStackToSlot(toInsert, slotToPut);
            this.getEnergy().extractEnergy(insertPowerRate, false);
            return true;
        }
        return false;
    }
}

