/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ShapelessEnderCrafterRecipe
implements ISpecialRecipe,
IEnderCrafterRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int craftingTime;

    public ShapelessEnderCrafterRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output) {
        this(recipeId, inputs, output, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    public ShapelessEnderCrafterRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output, int craftingTime) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.craftingTime = craftingTime;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPELESS_ENDER_CRAFTER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.ENDER_CRAFTER.get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputs.size();
    }

    public ItemStack assemble(IItemHandler inventory, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public boolean matches(IItemHandler inventory) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int matched = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
            ++matched;
        }
        return matched == this.inputs.size() && RecipeMatcher.findMatches(inputs, this.inputs) != null;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    public int getCraftingTime() {
        return this.craftingTime;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessEnderCrafterRecipe> {
        public ShapelessEnderCrafterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122779_();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int craftingTime = GsonHelper.m_13824_((JsonObject)json, (String)"craftingTime", (int)0);
            return new ShapelessEnderCrafterRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, craftingTime);
        }

        public ShapelessEnderCrafterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int craftingTime = buffer.m_130242_();
            return new ShapelessEnderCrafterRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, craftingTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessEnderCrafterRecipe recipe) {
            buffer.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.craftingTime);
        }
    }
}

