/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.extendedcrafting.client.screen.AdvancedAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.AdvancedTableScreen;
import com.blakebr0.extendedcrafting.client.screen.AutoEnderCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.AutoFluxCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.BasicAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.BasicTableScreen;
import com.blakebr0.extendedcrafting.client.screen.CompressorScreen;
import com.blakebr0.extendedcrafting.client.screen.CraftingCoreScreen;
import com.blakebr0.extendedcrafting.client.screen.EliteAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EliteTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EnderCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.EpicAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EpicTableScreen;
import com.blakebr0.extendedcrafting.client.screen.FluxCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.UltimateAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.UltimateTableScreen;
import com.blakebr0.extendedcrafting.compat.jei.category.CombinationCraftingCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.CompressorCraftingCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.EnderCrafterCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.FluxCraftingCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.AdvancedTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.BasicTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.EliteTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.EpicTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.UltimateTableCategory;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AdvancedAutoTableContainer;
import com.blakebr0.extendedcrafting.container.AdvancedTableContainer;
import com.blakebr0.extendedcrafting.container.AutoEnderCrafterContainer;
import com.blakebr0.extendedcrafting.container.AutoFluxCrafterContainer;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicTableContainer;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EliteTableContainer;
import com.blakebr0.extendedcrafting.container.EnderCrafterContainer;
import com.blakebr0.extendedcrafting.container.EpicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EpicTableContainer;
import com.blakebr0.extendedcrafting.container.FluxCrafterContainer;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.container.UltimateTableContainer;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.init.ModContainerTypes;
import com.blakebr0.extendedcrafting.init.ModItems;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public final class JeiCompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("extendedcrafting", "jei_plugin");
    public static final ResourceLocation ICONS = new ResourceLocation("extendedcrafting", "textures/jei/icons.png");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new CombinationCraftingCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new BasicTableCategory(helper), new AdvancedTableCategory(helper), new EliteTableCategory(helper), new UltimateTableCategory(helper), new EpicTableCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new CompressorCraftingCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new EnderCrafterCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new FluxCraftingCategory(helper)});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            RecipeManager manager = level.m_7465_();
            if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
                registration.addRecipes(CombinationCraftingCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.COMBINATION.get()));
            }
            if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
                Map<Integer, List> recipes = Stream.of(1, 2, 3, 4, 5).collect(Collectors.toMap(tier -> tier, tier -> manager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.TABLE.get()).values().stream().filter(recipe -> tier.intValue() == recipe.getTier()).toList()));
                registration.addRecipes(BasicTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(1, new ArrayList()));
                registration.addRecipes(AdvancedTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(2, new ArrayList()));
                registration.addRecipes(EliteTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(3, new ArrayList()));
                registration.addRecipes(UltimateTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(4, new ArrayList()));
                registration.addRecipes(EpicTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(5, new ArrayList()));
            }
            if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
                registration.addRecipes(CompressorCraftingCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.COMPRESSOR.get()));
            }
            if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
                registration.addRecipes(EnderCrafterCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.ENDER_CRAFTER.get()));
            }
            if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
                registration.addRecipes(FluxCraftingCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.FLUX_CRAFTER.get()));
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_HANDHELD_WORKBENCH.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.HANDHELD_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        }
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CRAFTING_CORE.get()), new RecipeType[]{CombinationCraftingCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PEDESTAL.get()), new RecipeType[]{CombinationCraftingCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_TABLE.get()), new RecipeType[]{BasicTableCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ADVANCED_TABLE.get()), new RecipeType[]{AdvancedTableCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ELITE_TABLE.get()), new RecipeType[]{EliteTableCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ULTIMATE_TABLE.get()), new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.EPIC_TABLE.get()), new RecipeType[]{EpicTableCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
            }
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_AUTO_TABLE.get()), new RecipeType[]{BasicTableCategory.RECIPE_TYPE});
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ADVANCED_AUTO_TABLE.get()), new RecipeType[]{AdvancedTableCategory.RECIPE_TYPE});
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ELITE_AUTO_TABLE.get()), new RecipeType[]{EliteTableCategory.RECIPE_TYPE});
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ULTIMATE_AUTO_TABLE.get()), new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.EPIC_AUTO_TABLE.get()), new RecipeType[]{EpicTableCategory.RECIPE_TYPE});
                if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                    registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_AUTO_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
                }
            }
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.COMPRESSOR.get()), new RecipeType[]{CompressorCraftingCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ENDER_CRAFTER.get()), new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_ENDER_CRAFTER.get()).booleanValue()) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AUTO_ENDER_CRAFTER.get()), new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
            }
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ENDER_ALTERNATOR.get()), new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FLUX_CRAFTER.get()), new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_FLUX_CRAFTER.get()).booleanValue()) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AUTO_FLUX_CRAFTER.get()), new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
            }
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FLUX_ALTERNATOR.get()), new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeTransferHandler(BasicTableContainer.class, (MenuType)ModContainerTypes.BASIC_TABLE.get(), BasicTableCategory.RECIPE_TYPE, 1, 9, 10, 36);
            registration.addRecipeTransferHandler(AdvancedTableContainer.class, (MenuType)ModContainerTypes.ADVANCED_TABLE.get(), AdvancedTableCategory.RECIPE_TYPE, 1, 25, 26, 36);
            registration.addRecipeTransferHandler(EliteTableContainer.class, (MenuType)ModContainerTypes.ELITE_TABLE.get(), EliteTableCategory.RECIPE_TYPE, 1, 49, 50, 36);
            registration.addRecipeTransferHandler(UltimateTableContainer.class, (MenuType)ModContainerTypes.ULTIMATE_TABLE.get(), UltimateTableCategory.RECIPE_TYPE, 1, 81, 82, 36);
            registration.addRecipeTransferHandler(EpicTableContainer.class, (MenuType)ModContainerTypes.EPIC_TABLE.get(), EpicTableCategory.RECIPE_TYPE, 1, 121, 122, 36);
            if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                registration.addRecipeTransferHandler(BasicTableContainer.class, (MenuType)ModContainerTypes.BASIC_TABLE.get(), RecipeTypes.CRAFTING, 1, 9, 10, 36);
            }
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeTransferHandler(BasicAutoTableContainer.class, (MenuType)ModContainerTypes.BASIC_AUTO_TABLE.get(), BasicTableCategory.RECIPE_TYPE, 1, 9, 11, 36);
                registration.addRecipeTransferHandler(AdvancedAutoTableContainer.class, (MenuType)ModContainerTypes.ADVANCED_AUTO_TABLE.get(), AdvancedTableCategory.RECIPE_TYPE, 1, 25, 27, 36);
                registration.addRecipeTransferHandler(EliteAutoTableContainer.class, (MenuType)ModContainerTypes.ELITE_AUTO_TABLE.get(), EliteTableCategory.RECIPE_TYPE, 1, 49, 51, 36);
                registration.addRecipeTransferHandler(UltimateAutoTableContainer.class, (MenuType)ModContainerTypes.ULTIMATE_AUTO_TABLE.get(), UltimateTableCategory.RECIPE_TYPE, 1, 81, 83, 36);
                registration.addRecipeTransferHandler(EpicAutoTableContainer.class, (MenuType)ModContainerTypes.EPIC_AUTO_TABLE.get(), EpicTableCategory.RECIPE_TYPE, 1, 121, 123, 36);
                if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                    registration.addRecipeTransferHandler(BasicAutoTableContainer.class, (MenuType)ModContainerTypes.BASIC_AUTO_TABLE.get(), RecipeTypes.CRAFTING, 1, 9, 11, 36);
                }
            }
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeTransferHandler(EnderCrafterContainer.class, (MenuType)ModContainerTypes.ENDER_CRAFTER.get(), EnderCrafterCategory.RECIPE_TYPE, 1, 9, 10, 36);
            if (((Boolean)ModConfigs.ENABLE_AUTO_ENDER_CRAFTER.get()).booleanValue()) {
                registration.addRecipeTransferHandler(AutoEnderCrafterContainer.class, (MenuType)ModContainerTypes.AUTO_ENDER_CRAFTER.get(), EnderCrafterCategory.RECIPE_TYPE, 1, 9, 10, 36);
            }
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipeTransferHandler(FluxCrafterContainer.class, (MenuType)ModContainerTypes.FLUX_CRAFTER.get(), FluxCraftingCategory.RECIPE_TYPE, 1, 9, 10, 36);
            if (((Boolean)ModConfigs.ENABLE_AUTO_FLUX_CRAFTER.get()).booleanValue()) {
                registration.addRecipeTransferHandler(AutoFluxCrafterContainer.class, (MenuType)ModContainerTypes.AUTO_FLUX_CRAFTER.get(), FluxCraftingCategory.RECIPE_TYPE, 1, 9, 10, 36);
            }
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeClickArea(CraftingCoreScreen.class, 117, 47, 21, 14, new RecipeType[]{CombinationCraftingCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeClickArea(BasicTableScreen.class, 91, 37, 21, 14, new RecipeType[]{BasicTableCategory.RECIPE_TYPE});
            registration.addRecipeClickArea(AdvancedTableScreen.class, 109, 54, 21, 14, new RecipeType[]{AdvancedTableCategory.RECIPE_TYPE});
            registration.addRecipeClickArea(EliteTableScreen.class, 139, 72, 21, 14, new RecipeType[]{EliteTableCategory.RECIPE_TYPE});
            registration.addRecipeClickArea(UltimateTableScreen.class, 174, 90, 21, 14, new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
            registration.addRecipeClickArea(EpicTableScreen.class, 210, 108, 21, 14, new RecipeType[]{EpicTableCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeClickArea(BasicAutoTableScreen.class, 97, 36, 21, 14, new RecipeType[]{BasicTableCategory.RECIPE_TYPE});
                registration.addRecipeClickArea(AdvancedAutoTableScreen.class, 121, 39, 21, 14, new RecipeType[]{AdvancedTableCategory.RECIPE_TYPE});
                registration.addRecipeClickArea(EliteAutoTableScreen.class, 158, 72, 21, 14, new RecipeType[]{EliteTableCategory.RECIPE_TYPE});
                registration.addRecipeClickArea(UltimateAutoTableScreen.class, 193, 90, 21, 14, new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
                registration.addRecipeClickArea(EpicAutoTableScreen.class, 237, 108, 21, 14, new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
            }
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeClickArea(CompressorScreen.class, 97, 47, 21, 14, new RecipeType[]{CompressorCraftingCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeClickArea(EnderCrafterScreen.class, 90, 36, 21, 14, new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_ENDER_CRAFTER.get()).booleanValue()) {
                registration.addRecipeClickArea(AutoEnderCrafterScreen.class, 95, 48, 21, 14, new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
            }
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipeClickArea(FluxCrafterScreen.class, 90, 36, 21, 14, new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_FLUX_CRAFTER.get()).booleanValue()) {
                registration.addRecipeClickArea(AutoFluxCrafterScreen.class, 95, 48, 21, 14, new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
            }
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ModItems.SINGULARITY.ifPresent(item -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, item, (stack, context) -> {
            Singularity singularity = SingularityUtils.getSingularity(stack);
            return singularity != null ? singularity.getId().toString() : "";
        }));
        ModItems.RECIPE_MAKER.ifPresent(item -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, item, (stack, context) -> NBTHelper.getString((ItemStack)stack, (String)"Type")));
    }
}

