/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.container.pattern.ContainerPattern;
import com.glodblock.github.extendedae.container.pattern.PatternGuiHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ContainerProcessingPattern
extends ContainerPattern {
    public static final ResourceLocation ID = ExtendedAE.id("proc_pattern");
    public static final MenuType<ContainerProcessingPattern> TYPE = PatternGuiHandler.register(ID.toString(), ContainerProcessingPattern::new);

    public ContainerProcessingPattern(@Nullable MenuType<?> menuType, int id, Level world, ItemStack stack) {
        super(TYPE, world, id, stack);
        int col;
        int row;
        for (row = 0; row < 9; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new ContainerPattern.DisplayOnlySlot(this, this.inputs, row * 9 + col, 8 + col * 18, 9 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new ContainerPattern.DisplayOnlySlot(this, this.outputs, row * 9 + col, 8 + col * 18, 189 + row * 18));
            }
        }
    }

    @Override
    protected void analyse() {
        IPatternDetails iPatternDetails = this.details;
        if (iPatternDetails instanceof AEProcessingPattern) {
            GenericStack[] rawOutputs;
            GenericStack[] rawInputs;
            AEProcessingPattern pattern = (AEProcessingPattern)iPatternDetails;
            for (GenericStack in : rawInputs = pattern.getSparseInputs()) {
                if (in == null) {
                    this.inputs.add(new GenericStack[0]);
                    continue;
                }
                GenericStack[] inStacks = new GenericStack[]{new GenericStack(in.what(), in.amount())};
                this.inputs.add(inStacks);
            }
            for (GenericStack out : rawOutputs = pattern.getSparseOutputs()) {
                if (out == null) {
                    this.outputs.add(new GenericStack[0]);
                    continue;
                }
                GenericStack[] outStacks = new GenericStack[]{new GenericStack(out.what(), out.amount())};
                this.outputs.add(outStacks);
            }
        } else {
            this.invalidate();
        }
    }
}

