/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.definitions.AEItems;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.extendedae.common.me.FreqGenerator;
import com.glodblock.github.extendedae.common.me.wireless.WirelessConnect;
import com.glodblock.github.extendedae.util.CacheHolder;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileWirelessConnector
extends AENetworkBlockEntity
implements ServerTickingBlockEntity,
IUpgradeableObject,
IColorableBlockEntity {
    private boolean updateStatus = true;
    private long freq = 0L;
    private final WirelessConnect connect;
    private double powerUse;
    private final IUpgradeInventory upgrades;
    private final CacheHolder<BlockPos> other = CacheHolder.empty();
    private static final FreqGenerator<Long> G = FreqGenerator.createLong();
    @NotNull
    private AEColor color = AEColor.TRANSPARENT;

    public TileWirelessConnector(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileWirelessConnector.class, TileWirelessConnector::new, (Block)EPPItemAndBlock.WIRELESS_CONNECTOR), pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class));
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
        this.powerUse = 1.0;
        this.getMainNode().setIdlePowerUsage(this.powerUse);
        this.connect = new WirelessConnect(this);
        this.upgrades = UpgradeInventories.forMachine((ItemLike)EPPItemAndBlock.WIRELESS_CONNECTOR, (int)4, this::updatePowerUsage);
    }

    public void serverTick() {
        if (this.updateStatus) {
            this.updateStatus = false;
            this.other.expired();
            this.connect.updateStatus();
            this.updatePowerUsage();
            this.markForUpdate();
            this.reactive();
        }
    }

    public void updatePowerUsage() {
        double disc = 1.0 - 0.1 * (double)this.upgrades.getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
        if (this.connect.isConnected()) {
            double dis = Math.max(this.connect.getDistance(), Math.E);
            this.powerUse = Math.max(1.0, dis * Math.log(dis) * disc);
        } else {
            this.powerUse = 1.0;
        }
        this.getMainNode().setIdlePowerUsage(this.powerUse);
    }

    public double getPowerUse() {
        return this.powerUse;
    }

    public BlockPos getOtherSide() {
        if (this.connect.isConnected()) {
            if (!this.other.isValid()) {
                this.other.update(this.connect.getOtherSide());
            }
            return this.other.get();
        }
        return null;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.updateStatus = true;
    }

    public void reactive() {
        this.connect.active();
    }

    public void onChunkUnloaded() {
        this.disconnect();
        super.onChunkUnloaded();
    }

    public void onReady() {
        super.onReady();
        this.updateStatus = true;
    }

    public void m_7651_() {
        this.disconnect();
        super.m_7651_();
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.freq = data.m_128454_("freq");
        this.upgrades.readFromNBT(data, "upgrades");
        this.color = data.m_128441_("color") ? AEColor.valueOf((String)data.m_128461_("color")) : AEColor.TRANSPARENT;
        this.getMainNode().setGridColor(this.color);
        G.markUsed(this.freq);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128356_("freq", this.freq);
        this.upgrades.writeToNBT(data, "upgrades");
        data.m_128359_("color", this.color.name());
        G.markUsed(this.freq);
    }

    public void setFreq(long freq) {
        this.freq = freq;
        this.updateStatus = true;
    }

    public long getNewFreq() {
        return G.genFreq();
    }

    public void disconnect() {
        this.connect.destroy();
    }

    public boolean isConnected() {
        return this.connect.isConnected();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.DENSE_SMART;
    }

    public void breakOnRemove() {
        this.connect.destroy();
    }

    public long getFrequency() {
        return this.freq;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack card : this.upgrades) {
            drops.add(card);
        }
    }

    @NotNull
    public AEColor getColor() {
        return this.color;
    }

    public boolean recolourBlock(Direction side, AEColor colour, Player who) {
        if (colour == this.color) {
            return false;
        }
        this.color = colour;
        this.saveChanges();
        this.markForUpdate();
        this.getMainNode().setGridColor(this.color);
        return true;
    }
}

