/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common;

import appeng.api.client.StorageCellModels;
import appeng.api.features.GridLinkables;
import appeng.api.features.HotkeyAction;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.parts.PartModels;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.block.AEBaseBlockItem;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.hotkeys.HotkeyActions;
import appeng.hotkeys.InventoryHotkeyAction;
import appeng.items.AEBaseItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.extendedae.common.inventory.InfinityCellInventory;
import com.glodblock.github.extendedae.common.items.ItemMEPackingTape;
import com.glodblock.github.extendedae.common.parts.PartActiveFormationPlane;
import com.glodblock.github.extendedae.common.parts.PartExExportBus;
import com.glodblock.github.extendedae.common.parts.PartExImportBus;
import com.glodblock.github.extendedae.common.parts.PartExInterface;
import com.glodblock.github.extendedae.common.parts.PartExPatternAccessTerminal;
import com.glodblock.github.extendedae.common.parts.PartExPatternProvider;
import com.glodblock.github.extendedae.common.parts.PartModExportBus;
import com.glodblock.github.extendedae.common.parts.PartModStorageBus;
import com.glodblock.github.extendedae.common.parts.PartPreciseExportBus;
import com.glodblock.github.extendedae.common.parts.PartPreciseStorageBus;
import com.glodblock.github.extendedae.common.parts.PartTagExportBus;
import com.glodblock.github.extendedae.common.parts.PartTagStorageBus;
import com.glodblock.github.extendedae.common.parts.PartThresholdExportBus;
import com.glodblock.github.extendedae.common.parts.PartThresholdLevelEmitter;
import com.glodblock.github.extendedae.config.EPPConfig;
import com.glodblock.github.extendedae.container.ContainerActiveFormationPlane;
import com.glodblock.github.extendedae.container.ContainerCaner;
import com.glodblock.github.extendedae.container.ContainerExDrive;
import com.glodblock.github.extendedae.container.ContainerExIOBus;
import com.glodblock.github.extendedae.container.ContainerExIOPort;
import com.glodblock.github.extendedae.container.ContainerExInscriber;
import com.glodblock.github.extendedae.container.ContainerExInterface;
import com.glodblock.github.extendedae.container.ContainerExMolecularAssembler;
import com.glodblock.github.extendedae.container.ContainerExPatternProvider;
import com.glodblock.github.extendedae.container.ContainerExPatternTerminal;
import com.glodblock.github.extendedae.container.ContainerIngredientBuffer;
import com.glodblock.github.extendedae.container.ContainerModExportBus;
import com.glodblock.github.extendedae.container.ContainerModStorageBus;
import com.glodblock.github.extendedae.container.ContainerPatternModifier;
import com.glodblock.github.extendedae.container.ContainerPreciseExportBus;
import com.glodblock.github.extendedae.container.ContainerPreciseStorageBus;
import com.glodblock.github.extendedae.container.ContainerRenamer;
import com.glodblock.github.extendedae.container.ContainerTagExportBus;
import com.glodblock.github.extendedae.container.ContainerTagStorageBus;
import com.glodblock.github.extendedae.container.ContainerThresholdExportBus;
import com.glodblock.github.extendedae.container.ContainerThresholdLevelEmitter;
import com.glodblock.github.extendedae.container.ContainerWirelessConnector;
import com.glodblock.github.extendedae.container.ContainerWirelessExPAT;
import com.glodblock.github.extendedae.container.pattern.ContainerCraftingPattern;
import com.glodblock.github.extendedae.container.pattern.ContainerProcessingPattern;
import com.glodblock.github.extendedae.container.pattern.ContainerSmithingTablePattern;
import com.glodblock.github.extendedae.container.pattern.ContainerStonecuttingPattern;
import com.glodblock.github.extendedae.xmod.appflux.AFCommonLoad;
import com.glodblock.github.extendedae.xmod.appliede.APECommonLoad;
import com.glodblock.github.extendedae.xmod.wt.WTCommonLoad;
import com.glodblock.github.glodium.registry.RegistryHandler;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.Collection;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;

public class EAERegistryHandler
extends RegistryHandler {
    public static final EAERegistryHandler INSTANCE = new EAERegistryHandler();

    public EAERegistryHandler() {
        super("expatternprovider");
    }

    public <T extends AEBaseBlockEntity> void block(String name, AEBaseEntityBlock<T> block, Class<T> clazz, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        this.bindTileEntity(clazz, block, supplier);
        this.block(name, (Block)block, b -> new AEBaseBlockItem(b, new Item.Properties()));
        this.tile(name, block.getBlockEntityType());
    }

    public void register(RegisterEvent event) {
        super.register(event);
        this.onRegisterContainer();
        this.onRegisterModels();
    }

    public Collection<Block> getBlocks() {
        return this.blocks.stream().map(Pair::getRight).toList();
    }

    private void onRegisterContainer() {
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_pattern_provider"), ContainerExPatternProvider.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_interface"), ContainerExInterface.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_export_bus"), ContainerExIOBus.EXPORT_TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_import_bus"), ContainerExIOBus.IMPORT_TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_pattern_access_terminal"), ContainerExPatternTerminal.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"wireless_connector"), ContainerWirelessConnector.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ingredient_buffer"), ContainerIngredientBuffer.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_drive"), ContainerExDrive.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"pattern_modifier"), ContainerPatternModifier.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_molecular_assembler"), ContainerExMolecularAssembler.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_inscriber"), ContainerExInscriber.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"tag_storage_bus"), ContainerTagStorageBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"tag_export_bus"), ContainerTagExportBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"threshold_level_emitter"), ContainerThresholdLevelEmitter.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"renamer"), ContainerRenamer.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"mod_storage_bus"), ContainerModStorageBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"mod_export_bus"), ContainerModExportBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"active_formation_plane"), ContainerActiveFormationPlane.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"caner"), ContainerCaner.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"precise_export_bus"), ContainerPreciseExportBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"wireless_ex_pat"), ContainerWirelessExPAT.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"ex_ioport"), ContainerExIOPort.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"precise_storage_bus"), ContainerPreciseStorageBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(AppEng.makeId((String)"threshold_export_bus"), ContainerThresholdExportBus.TYPE);
        ForgeRegistries.MENU_TYPES.register(ContainerProcessingPattern.ID, ContainerProcessingPattern.TYPE);
        ForgeRegistries.MENU_TYPES.register(ContainerCraftingPattern.ID, ContainerCraftingPattern.TYPE);
        ForgeRegistries.MENU_TYPES.register(ContainerStonecuttingPattern.ID, ContainerStonecuttingPattern.TYPE);
        ForgeRegistries.MENU_TYPES.register(ContainerSmithingTablePattern.ID, ContainerSmithingTablePattern.TYPE);
        if (ModList.get().isLoaded("ae2wtlib")) {
            WTCommonLoad.container();
        }
        if (ModList.get().isLoaded("appliede")) {
            APECommonLoad.container();
        }
    }

    private <T extends AEBaseBlockEntity> void bindTileEntity(Class<T> clazz, AEBaseEntityBlock<T> block, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        BlockEntityTicker serverTicker = null;
        if (ServerTickingBlockEntity.class.isAssignableFrom(clazz)) {
            serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)entity).serverTick();
        }
        BlockEntityTicker clientTicker = null;
        if (ClientTickingBlockEntity.class.isAssignableFrom(clazz)) {
            clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)entity).clientTick();
        }
        block.setBlockEntity(clazz, GlodUtil.getTileType(clazz, supplier, block), clientTicker, serverTicker);
    }

    public void onInit() {
        for (Pair entry : this.blocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(ExtendedAE.id((String)entry.getKey()));
            if (!(block instanceof AEBaseEntityBlock)) continue;
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)((AEBaseEntityBlock)block).getBlockEntityType(), (Item)block.m_5456_());
        }
        this.registerAEUpgrade();
        this.registerStorageHandler();
        this.registerRandomAPI();
        this.initPackageList();
        if (ModList.get().isLoaded("ae2wtlib")) {
            WTCommonLoad.init();
        }
        if (ModList.get().isLoaded("appflux")) {
            AFCommonLoad.init();
        }
        if (ModList.get().isLoaded("appliede")) {
            APECommonLoad.init();
        }
    }

    private void registerAEUpgrade() {
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)EPPItemAndBlock.EX_INTERFACE.m_5456_(), (int)1, (String)"gui.expatternprovider.ex_interface");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, (ItemLike)EPPItemAndBlock.EX_INTERFACE.m_5456_(), (int)1, (String)"gui.expatternprovider.ex_interface");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)EPPItemAndBlock.EX_INTERFACE_PART.m_5456_(), (int)1, (String)"gui.expatternprovider.ex_interface");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, (ItemLike)EPPItemAndBlock.EX_INTERFACE_PART.m_5456_(), (int)1, (String)"gui.expatternprovider.ex_interface");
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)5, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)4, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, EPPItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)5, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)4, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EPPItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.ENERGY_CARD, (ItemLike)EPPItemAndBlock.WIRELESS_CONNECTOR, (int)4);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EPPItemAndBlock.EX_ASSEMBLER, (int)5);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EPPItemAndBlock.EX_INSCRIBER, (int)4);
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, EPPItemAndBlock.TAG_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, EPPItemAndBlock.TAG_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.TAG_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EPPItemAndBlock.TAG_EXPORT_BUS, (int)4);
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EPPItemAndBlock.THRESHOLD_LEVEL_EMITTER, (int)1);
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, EPPItemAndBlock.MOD_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, EPPItemAndBlock.MOD_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.MOD_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EPPItemAndBlock.MOD_EXPORT_BUS, (int)4);
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EPPItemAndBlock.ACTIVE_FORMATION_PLANE, (int)1);
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EPPItemAndBlock.ACTIVE_FORMATION_PLANE, (int)5);
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EPPItemAndBlock.PRECISE_EXPORT_BUS, (int)5);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.PRECISE_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, EPPItemAndBlock.PRECISE_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.ENERGY_CARD, (ItemLike)EPPItemAndBlock.WIRELESS_EX_PAT, (int)2, (String)GuiText.WirelessTerminals.getTranslationKey());
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EPPItemAndBlock.EX_IO_PORT, (int)5);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, (ItemLike)EPPItemAndBlock.EX_IO_PORT, (int)1);
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EPPItemAndBlock.PRECISE_STORAGE_BUS, (int)5);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, EPPItemAndBlock.PRECISE_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EPPItemAndBlock.THRESHOLD_EXPORT_BUS, (int)5);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EPPItemAndBlock.THRESHOLD_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EPPItemAndBlock.THRESHOLD_EXPORT_BUS, (int)4);
    }

    private void registerStorageHandler() {
        StorageCells.addCellHandler((ICellHandler)InfinityCellInventory.HANDLER);
        StorageCellModels.registerModel((ItemLike)EPPItemAndBlock.INFINITY_CELL, (ResourceLocation)ExtendedAE.id("block/drive/infinity_cell"));
    }

    private void onRegisterModels() {
        PartModels.registerModels(PartExPatternProvider.MODELS);
        PartModels.registerModels(PartExInterface.MODELS);
        PartModels.registerModels(PartExExportBus.MODELS);
        PartModels.registerModels(PartExImportBus.MODELS);
        PartModels.registerModels(PartExPatternAccessTerminal.MODELS);
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartTagStorageBus.MODEL_BASE});
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartTagExportBus.MODEL_BASE});
        PartModels.registerModels(PartThresholdLevelEmitter.MODELS);
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartModStorageBus.MODEL_BASE});
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartModExportBus.MODEL_BASE});
        PartModels.registerModels(PartActiveFormationPlane.MODELS);
        PartModels.registerModels(PartPreciseExportBus.MODELS);
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartPreciseStorageBus.MODEL_BASE});
        PartModels.registerModels(PartThresholdExportBus.MODELS);
    }

    private void initPackageList() {
        EPPConfig.tapeWhitelist.forEach(ItemMEPackingTape::registerPackableDevice);
    }

    private void registerRandomAPI() {
        GridLinkables.register((ItemLike)EPPItemAndBlock.WIRELESS_EX_PAT, (IGridLinkableHandler)WirelessTerminalItem.LINKABLE_HANDLER);
        if (!ModList.get().isLoaded("ae2wtlib")) {
            HotkeyActions.register((HotkeyAction)new InventoryHotkeyAction((Item)EPPItemAndBlock.WIRELESS_EX_PAT, (player, i) -> EPPItemAndBlock.WIRELESS_EX_PAT.openFromInventory(player, i)), (String)"wireless_terminal");
        } else {
            HotkeyActions.register((HotkeyAction)new InventoryHotkeyAction((Item)EPPItemAndBlock.WIRELESS_EX_PAT, (player, i) -> EPPItemAndBlock.WIRELESS_EX_PAT.openFromInventory(player, i)), (String)"wireless_pattern_access_terminal");
        }
    }

    public void registerTab(Registry<CreativeModeTab> registry) {
        CreativeModeTab tab = CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)EPPItemAndBlock.EX_PATTERN_PROVIDER)).m_257941_((Component)Component.m_237115_((String)"itemGroup.epp")).m_257501_((__, o) -> {
            for (Pair entry : this.items) {
                Object patt17098$temp = entry.getRight();
                if (patt17098$temp instanceof AEBaseItem) {
                    AEBaseItem aeItem = (AEBaseItem)patt17098$temp;
                    aeItem.addToMainCreativeTab(o);
                    continue;
                }
                o.m_246326_((ItemLike)entry.getRight());
            }
            for (Pair entry : this.blocks) {
                o.m_246326_((ItemLike)entry.getRight());
            }
        }).m_257652_();
        Registry.m_122965_(registry, (ResourceLocation)ExtendedAE.id("tab_main"), (Object)tab);
    }
}

