/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.fluid;

import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.SlotType;
import com.enderio.api.conduit.TieredConduit;
import com.enderio.api.conduit.ticker.ConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.FluidStackFilter;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.conduits.common.capability.ExtractionSpeedUpgrade;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitData;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitTicker;
import com.enderio.conduits.common.init.ConduitLang;
import com.enderio.core.common.util.TooltipUtil;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FluidConduitType
extends TieredConduit<FluidConduitData> {
    public static final ConduitMenuData NORMAL_MENU_DATA = new ConduitMenuData.Simple(true, true, true, false, false, true);
    public static final ConduitMenuData ADVANCED_MENU_DATA = new ConduitMenuData.Simple(true, true, true, true, true, true);
    private final boolean isMultiFluid;
    private final int transferRatePerTick;
    private final ConduitTicker<FluidConduitData> ticker;

    public FluidConduitType(ResourceLocation tierName, int transferRatePerTick, boolean isMultiFluid) {
        super(new ResourceLocation("forge:fluid"), tierName, transferRatePerTick);
        this.isMultiFluid = isMultiFluid;
        this.transferRatePerTick = transferRatePerTick;
        this.ticker = new FluidConduitTicker(!isMultiFluid, this.transferRatePerTick);
    }

    @Override
    public ConduitTicker<FluidConduitData> getTicker() {
        return this.ticker;
    }

    @Override
    public ConduitMenuData getMenuData() {
        return this.isMultiFluid ? ADVANCED_MENU_DATA : NORMAL_MENU_DATA;
    }

    @Override
    public FluidConduitData createConduitData(Level level, BlockPos pos) {
        return new FluidConduitData(this.isMultiFluid);
    }

    @Override
    public boolean canApplyUpgrade(SlotType slotType, ConduitUpgrade conduitUpgrade) {
        return conduitUpgrade instanceof ExtractionSpeedUpgrade;
    }

    @Override
    public boolean canApplyFilter(SlotType slotType, ResourceFilter resourceFilter) {
        return resourceFilter instanceof FluidStackFilter;
    }

    @Override
    public void addToTooltip(@Nullable Level level, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        String transferLimitFormatted = String.format("%,d", this.transferRatePerTick);
        tooltipAdder.accept(TooltipUtil.styledWithArgs(ConduitLang.FLUID_RATE_TOOLTIP, transferLimitFormatted));
        if (this.isMultiFluid) {
            tooltipAdder.accept(ConduitLang.MULTI_FLUID_TOOLTIP);
        }
    }
}

