/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.client;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.model.RegisterConduitCoreModelModifiersEvent;
import com.enderio.api.conduit.screen.RegisterConduitScreenExtensionsEvent;
import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.client.gui.ConduitIconTextureManager;
import com.enderio.conduits.client.gui.conduit.ConduitScreenExtensions;
import com.enderio.conduits.client.gui.conduit.FluidConduitScreenExtension;
import com.enderio.conduits.client.gui.conduit.ItemConduitScreenExtension;
import com.enderio.conduits.client.model.ConduitGeometry;
import com.enderio.conduits.client.model.conduit.modifier.ConduitCoreModelModifiers;
import com.enderio.conduits.client.model.conduit.modifier.FluidConduitCoreModelModifier;
import com.enderio.conduits.client.model.conduit.modifier.RedstoneConduitCoreModelModifier;
import com.enderio.conduits.common.init.ConduitBlocks;
import com.enderio.conduits.common.init.EIOConduitTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConduitClientSetup {
    private static final List<ResourceLocation> MODEL_LOCATIONS = new ArrayList<ResourceLocation>();
    private static final Map<ResourceLocation, BakedModel> MODELS = new HashMap<ResourceLocation, BakedModel>();
    public static final ResourceLocation CONDUIT_CONNECTOR = ConduitClientSetup.loc("block/conduit_connector");
    public static final ResourceLocation CONDUIT_FACADE = ConduitClientSetup.loc("block/conduit_facade");
    public static final ResourceLocation CONDUIT_CONNECTION = ConduitClientSetup.loc("block/conduit_connection");
    public static final ResourceLocation CONDUIT_CORE = ConduitClientSetup.loc("block/conduit_core");
    public static final ResourceLocation BOX = ConduitClientSetup.loc("block/box/1x1x1");
    public static final ResourceLocation CONDUIT_CONNECTION_BOX = ConduitClientSetup.loc("block/conduit_connection_box");
    public static final ResourceLocation CONDUIT_IO_IN = ConduitClientSetup.loc("block/io/input");
    public static final ResourceLocation CONDUIT_IO_IN_OUT = ConduitClientSetup.loc("block/io/in_out");
    public static final ResourceLocation CONDUIT_IO_OUT = ConduitClientSetup.loc("block/io/output");
    public static final ResourceLocation CONDUIT_IO_REDSTONE = ConduitClientSetup.loc("block/io/redstone");

    private ConduitClientSetup() {
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        ConduitScreenExtensions.init();
    }

    @SubscribeEvent
    public static void registerConduitCoreModelModifiers(RegisterConduitCoreModelModifiersEvent event) {
        event.register((ConduitType)EIOConduitTypes.FLUID.get(), () -> FluidConduitCoreModelModifier.INSTANCE);
        event.register((ConduitType)EIOConduitTypes.FLUID2.get(), () -> FluidConduitCoreModelModifier.INSTANCE);
        event.register((ConduitType)EIOConduitTypes.FLUID3.get(), () -> FluidConduitCoreModelModifier.INSTANCE);
        event.register((ConduitType)EIOConduitTypes.REDSTONE.get(), RedstoneConduitCoreModelModifier::new);
    }

    @SubscribeEvent
    public static void registerConduitScreenExtensions(RegisterConduitScreenExtensionsEvent event) {
        event.register((ConduitType)EIOConduitTypes.FLUID.get(), () -> FluidConduitScreenExtension.INSTANCE);
        event.register((ConduitType)EIOConduitTypes.FLUID2.get(), () -> FluidConduitScreenExtension.INSTANCE);
        event.register((ConduitType)EIOConduitTypes.FLUID3.get(), () -> FluidConduitScreenExtension.INSTANCE);
        event.register((ConduitType)EIOConduitTypes.ITEM.get(), ItemConduitScreenExtension::new);
    }

    @SubscribeEvent
    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ConduitIconTextureManager(Minecraft.m_91087_().m_91097_()));
    }

    @SubscribeEvent
    public static void modelLoader(ModelEvent.RegisterGeometryLoaders event) {
        event.register("conduit", (IGeometryLoader)new ConduitGeometry.Loader());
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        for (ResourceLocation model : MODEL_LOCATIONS) {
            event.register(model);
        }
        ConduitCoreModelModifiers.init();
        ConduitCoreModelModifiers.getAllModelDependencies().forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    @SubscribeEvent
    public static void bakingModelsFinished(ModelEvent.BakingCompleted event) {
        for (ResourceLocation modelLocation : MODEL_LOCATIONS) {
            MODELS.put(modelLocation, (BakedModel)event.getModels().get(modelLocation));
        }
    }

    @SubscribeEvent
    public static void blockColors(RegisterColorHandlersEvent.Block block) {
        block.register((BlockColor)new ConduitBlockColor(), new Block[]{(Block)ConduitBlocks.CONDUIT.get()});
    }

    private static ResourceLocation loc(String modelName) {
        ResourceLocation loc = EnderIO.loc(modelName);
        MODEL_LOCATIONS.add(loc);
        return loc;
    }

    public static BakedModel modelOf(ResourceLocation location) {
        return MODELS.get(location);
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static class ConduitBlockColor
    implements BlockColor {
        public int m_92566_(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
            return ColorControl.values()[tintIndex].getColor();
        }
    }
}

