/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.util;

import com.enderio.base.common.block.painted.IPaintedBlock;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PaintUtils {
    @Nullable
    public static Block getBlockFromRL(String rl) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(rl));
    }

    @Nullable
    public static Block getPaint(ItemStack stack) {
        CompoundTag blockEntityTag;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("BlockEntityTag") && (blockEntityTag = tag.m_128469_("BlockEntityTag")).m_128441_("Paint")) {
            return PaintUtils.getBlockFromRL(blockEntityTag.m_128461_("Paint"));
        }
        return null;
    }

    public static Optional<SoundEvent> getPlaceSound(BlockState state, Level level, BlockPos pos, Player player, Class<? extends BlockItem> blockItemClass) {
        if (level.m_5776_()) {
            return Optional.of(List.of(InteractionHand.values()).stream().map(arg_0 -> ((Player)player).m_21120_(arg_0)).filter(itemStack -> blockItemClass.isInstance(itemStack.m_41720_())).map(PaintUtils::getPaint).filter(Objects::nonNull).map(block -> block.getSoundType(block.m_49966_(), (LevelReader)level, pos, (Entity)player)).map(SoundType::m_56777_).findFirst().orElse(SoundType.f_56736_.m_56777_()));
        }
        Block block2 = state.m_60734_();
        if (block2 instanceof IPaintedBlock) {
            IPaintedBlock iPaintedBlock = (IPaintedBlock)block2;
            return Optional.of(iPaintedBlock.getSoundType(state, (LevelReader)level, pos, (Entity)player).m_56777_());
        }
        return Optional.empty();
    }
}

