/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.integrations.jei;

import com.enderio.core.client.gui.screen.EIOScreen;
import com.enderio.core.common.menu.FilterSlot;
import com.enderio.core.common.menu.FluidFilterSlot;
import com.enderio.core.common.menu.ItemFilterSlot;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FilterGhostIngredientHandler
implements IGhostIngredientHandler<EIOScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(EIOScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (Slot slot : gui.m_6262_().f_38839_) {
            if (!slot.m_6659_()) continue;
            Rect2i bounds = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 17, 17);
            if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
                FilterSlot otherFilterSlot;
                ItemStack currentIngredient = (ItemStack)ingredient.getIngredient();
                if (slot instanceof ItemFilterSlot) {
                    ItemFilterSlot itemFilterSlot = (ItemFilterSlot)slot;
                    targets.add(new ItemStackTarget(bounds, itemFilterSlot));
                    continue;
                }
                if (!(slot instanceof FilterSlot) || !(otherFilterSlot = (FilterSlot)slot).getResourceFrom(currentIngredient).isPresent()) continue;
                targets.add(new IndirectItemStackTarget(bounds, otherFilterSlot));
                continue;
            }
            if (ingredient.getType() != ForgeTypes.FLUID_STACK || !(slot instanceof FluidFilterSlot)) continue;
            FluidFilterSlot fluidFilterSlot = (FluidFilterSlot)slot;
            targets.add(new FluidStackTarget(bounds, fluidFilterSlot));
        }
        return targets;
    }

    public void onComplete() {
    }

    private record ItemStackTarget<I>(Rect2i bounds, ItemFilterSlot slot) implements IGhostIngredientHandler.Target<I>
    {
        public Rect2i getArea() {
            return this.bounds;
        }

        public void accept(I ingredient) {
            this.slot.setResource((ItemStack)ingredient);
        }
    }

    private record IndirectItemStackTarget<I>(Rect2i bounds, FilterSlot<?> slot) implements IGhostIngredientHandler.Target<I>
    {
        public Rect2i getArea() {
            return this.bounds;
        }

        public void accept(I ingredient) {
            this.slot.m_150659_((ItemStack)ingredient);
        }
    }

    private record FluidStackTarget<I>(Rect2i bounds, FluidFilterSlot slot) implements IGhostIngredientHandler.Target<I>
    {
        public Rect2i getArea() {
            return this.bounds;
        }

        public void accept(I ingredient) {
            this.slot.setResource((FluidStack)ingredient);
        }
    }
}

