/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.capability;

import com.enderio.api.capability.IToggled;
import com.enderio.base.common.init.EIOCapabilities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class Toggled
implements IToggled {
    private final ItemStack stack;

    public Toggled(ItemStack stack) {
        this.stack = stack;
    }

    public static boolean isEnabled(ItemStack itemStack) {
        return itemStack.getCapability(EIOCapabilities.TOGGLED).map(IToggled::isEnabled).orElse(false);
    }

    public static void toggleEnabled(ItemStack itemStack) {
        itemStack.getCapability(EIOCapabilities.TOGGLED).ifPresent(IToggled::toggle);
    }

    public static void setEnabled(ItemStack itemStack, boolean enabled) {
        itemStack.getCapability(EIOCapabilities.TOGGLED).ifPresent(iToggled -> iToggled.setEnabled(enabled));
    }

    @Override
    public boolean isEnabled() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("ToggleState")) {
            return tag.m_128471_("ToggleState");
        }
        return false;
    }

    @Override
    public void toggle() {
        this.setEnabled(!this.isEnabled());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128379_("ToggleState", isEnabled);
    }
}

