/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.data.recipes;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.data.recipe.RecipeDataUtil;
import com.enderio.core.data.recipes.EnderRecipeProvider;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.SagMillingRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class SagMillRecipeProvider
extends EnderRecipeProvider {
    private static final int BASE_ENERGY_PER_OPERATION = 2400;

    public SagMillRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        this.build1toN("iron", (TagKey<Item>)Tags.Items.INGOTS_IRON, (Item)EIOItems.POWDERED_IRON.get(), 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("gold", (TagKey<Item>)Tags.Items.INGOTS_GOLD, (Item)EIOItems.POWDERED_GOLD.get(), 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("obsidian", (TagKey<Item>)Tags.Items.OBSIDIAN, (Item)EIOItems.POWDERED_OBSIDIAN.get(), 4, finishedRecipeConsumer);
        this.build1toN("precient_crystal", EIOTags.Items.GEMS_PRESCIENT_CRYSTAL, (Item)EIOItems.PRESCIENT_POWDER.get(), 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("vibrant_crystal", EIOTags.Items.GEMS_VIBRANT_CRYSTAL, (Item)EIOItems.VIBRANT_POWDER.get(), 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("pulsating_crystal", EIOTags.Items.GEMS_PULSATING_CRYSTAL, (Item)EIOItems.PULSATING_POWDER.get(), 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("ender_crystal", EIOTags.Items.GEMS_ENDER_CRYSTAL, (Item)EIOItems.ENDER_CRYSTAL_POWDER.get(), 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("ender_pearl", (TagKey<Item>)Tags.Items.ENDER_PEARLS, (Item)EIOItems.POWDERED_ENDER_PEARL.get(), 9, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("blaze_powder", (TagKey<Item>)Tags.Items.RODS_BLAZE, Items.f_42593_, 4, finishedRecipeConsumer);
        this.build1toN("glass", (TagKey<Item>)Tags.Items.GLASS, Items.f_41830_, 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("bone_block", Items.f_42262_, Items.f_42499_, 9, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build1toN("soularium", EIOTags.Items.INGOTS_SOULARIUM, (Item)EIOItems.SOUL_POWDER.get(), 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.buildOre("iron_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_IRON), (Item)EIOItems.POWDERED_IRON.get(), finishedRecipeConsumer);
        this.buildOre("gold_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_GOLD), (Item)EIOItems.POWDERED_GOLD.get(), finishedRecipeConsumer);
        this.buildOre("copper_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_COPPER), (Item)EIOItems.POWDERED_COPPER.get(), finishedRecipeConsumer);
        this.build1toN("stone", (TagKey<Item>)Tags.Items.STONE, Items.f_42594_, 1, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build("coal", Ingredient.m_204132_((TagKey)ItemTags.f_13160_), List.of(this.output((Item)EIOItems.POWDERED_COAL.get()), this.output((Item)EIOItems.POWDERED_COAL.get(), 0.1f), this.output(EIOTags.Items.DUSTS_SULFUR, 1, 0.1f, true)), 2400, finishedRecipeConsumer);
        this.build("coal_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_COAL), List.of(this.output(Items.f_42413_, 3), this.output((Item)EIOItems.POWDERED_COAL.get(), 0.6f), this.output(Items.f_42415_, 0.005f), this.output(Items.f_42594_, 0.15f)), 2400, finishedRecipeConsumer);
        this.build("redstone_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_REDSTONE), List.of(this.output(Items.f_42451_, 8), this.output(Items.f_42451_, 0.2f), this.output((Item)EIOItems.SILICON.get(), 0.8f), this.output(Items.f_42594_, 0.15f)), 2400, finishedRecipeConsumer);
        this.build("diamond_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_DIAMOND), List.of(this.output(Items.f_42415_, 2), this.output(Items.f_42415_, 0.25f), this.output((Item)EIOItems.POWDERED_COAL.get(), 0.1f), this.output(Items.f_42594_, 0.15f)), 2400, finishedRecipeConsumer);
        this.build("emerald_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_EMERALD), List.of(this.output(Items.f_42616_, 2), this.output(Items.f_42616_, 0.25f), this.output(Items.f_42594_, 0.15f)), 2400, finishedRecipeConsumer);
        this.build("lapis_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_LAPIS), List.of(this.output(Items.f_42534_, 8), this.output(Items.f_42534_, 0.2f), this.output(Items.f_42594_, 0.15f)), 2400, finishedRecipeConsumer);
        this.build("lapis", Ingredient.m_204132_((TagKey)Tags.Items.GEMS_LAPIS), List.of(this.output((Item)EIOItems.POWDERED_LAPIS_LAZULI.get(), 1)), 2400, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build("quartz_ore", Ingredient.m_204132_((TagKey)Tags.Items.ORES_QUARTZ), List.of(this.output(Items.f_42692_, 2), this.output((Item)EIOItems.POWDERED_QUARTZ.get(), 0.1f), this.output(Items.f_42048_, 0.15f)), 2400, finishedRecipeConsumer);
        this.build("quartz", Ingredient.m_204132_((TagKey)Tags.Items.GEMS_QUARTZ), List.of(this.output((Item)EIOItems.POWDERED_QUARTZ.get(), 1), this.output((Item)EIOItems.POWDERED_QUARTZ.get(), 0.1f)), 2400, SagMillingRecipe.BonusType.CHANCE_ONLY, finishedRecipeConsumer);
        this.build("wheat", Ingredient.m_204132_((TagKey)Tags.Items.CROPS_WHEAT), List.of(this.output((Item)EIOItems.FLOUR.get()), this.output((TagKey<Item>)Tags.Items.SEEDS_WHEAT, 1, 0.2f, true)), 2400, finishedRecipeConsumer);
        this.build("cobblestone", Ingredient.m_204132_((TagKey)Tags.Items.COBBLESTONE), List.of(this.output(Items.f_41832_, 0.7f), this.output(Items.f_41832_, 0.3f), this.output(Items.f_41830_, 0.1f), this.output(Items.f_42484_, 0.05f)), 2400, finishedRecipeConsumer);
        this.build("gravel", Ingredient.m_204132_((TagKey)Tags.Items.GRAVEL), List.of(this.output(Items.f_41830_, 0.7f), this.output(Items.f_41830_, 0.3f), this.output(Items.f_42484_, 0.1f)), 2400, finishedRecipeConsumer);
        this.build("sandstone", Ingredient.m_204132_((TagKey)Tags.Items.SANDSTONE), List.of(this.output(Items.f_41830_, 2), this.output(Items.f_41830_, 2, 0.4f)), 2400, SagMillingRecipe.BonusType.CHANCE_ONLY, finishedRecipeConsumer);
        this.build("sand", Ingredient.m_204132_((TagKey)Tags.Items.SAND), List.of(this.output(EIOTags.Items.SILICON, 0.5f)), 2400, finishedRecipeConsumer);
        this.build("glowstone", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42054_}), List.of(this.output(Items.f_42525_, 3), this.output(Items.f_42525_, 0.8f)), 2400, SagMillingRecipe.BonusType.CHANCE_ONLY, finishedRecipeConsumer);
        this.build("bone", Ingredient.m_204132_((TagKey)Tags.Items.BONES), List.of(this.output(Items.f_42499_, 6), this.output(Items.f_42499_, 2, 0.1f)), 2400, finishedRecipeConsumer);
        this.build("clay", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41983_}), List.of(this.output(Items.f_42461_, 2), this.output(Items.f_42461_, 0.1f), this.output((Item)EIOItems.SILICON.get(), 2, 0.8f)), 2400, finishedRecipeConsumer);
        this.build("wool", Ingredient.m_204132_((TagKey)ItemTags.f_13167_), List.of(this.output(Items.f_42401_, 2), this.output(Items.f_42401_, 0.1f)), 2400, SagMillingRecipe.BonusType.CHANCE_ONLY, finishedRecipeConsumer);
        this.build("quartz_block", Ingredient.m_204132_((TagKey)Tags.Items.STORAGE_BLOCKS_QUARTZ), List.of(this.output(Items.f_42692_, 2), this.output(Items.f_42692_, 2, 0.25f)), 2400, SagMillingRecipe.BonusType.CHANCE_ONLY, finishedRecipeConsumer);
        this.build("quartz_stairs", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42160_}), List.of(this.output(Items.f_42692_, 2), this.output(Items.f_42692_, 2, 0.25f)), 2400, SagMillingRecipe.BonusType.CHANCE_ONLY, finishedRecipeConsumer);
        this.build("quartz_slabs", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41931_}), List.of(this.output(Items.f_42692_, 1), this.output(Items.f_42692_, 0.25f)), 2400, SagMillingRecipe.BonusType.CHANCE_ONLY, finishedRecipeConsumer);
        this.build("cobweb", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41863_}), List.of(this.output(Items.f_42401_, 2), this.output(Items.f_42401_, 0.6f), this.output(Items.f_42401_, 0.3f)), 2400, finishedRecipeConsumer);
        this.buildFlower("dandelion", Items.f_41939_, Items.f_42539_, finishedRecipeConsumer);
        this.buildFlower("poppy", Items.f_41940_, Items.f_42497_, finishedRecipeConsumer);
        this.buildFlower("blue_orchid", Items.f_41941_, Items.f_42538_, finishedRecipeConsumer);
        this.buildFlower("allium", Items.f_41942_, Items.f_42537_, finishedRecipeConsumer);
        this.buildFlower("azure_bluet", Items.f_41943_, Items.f_42491_, finishedRecipeConsumer);
        this.buildFlower("red_tulip", Items.f_41944_, Items.f_42497_, finishedRecipeConsumer);
        this.buildFlower("orange_tulip", Items.f_41945_, Items.f_42536_, finishedRecipeConsumer);
        this.buildFlower("white_tulip", Items.f_41946_, Items.f_42535_, finishedRecipeConsumer);
        this.buildFlower("pink_tulip", Items.f_41947_, Items.f_42489_, finishedRecipeConsumer);
        this.buildFlower("oxeye_daisy", Items.f_41948_, Items.f_42535_, finishedRecipeConsumer);
        this.build("shrub", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41866_}), List.of(this.output((Item)EIOItems.PLANT_MATTER_BROWN.get(), 0.8f), this.output((Item)EIOItems.PLANT_MATTER_BROWN.get(), 0.6f), this.output((Item)EIOItems.PLANT_MATTER_BROWN.get(), 0.3f)), 2400, finishedRecipeConsumer);
        this.build("grass", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41864_}), List.of(this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.6f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.1f), this.output((Item)EIOItems.PLANT_MATTER_BROWN.get(), 0.05f)), 2400, finishedRecipeConsumer);
        this.build("fern", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41865_}), List.of(this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.6f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.1f), this.output((Item)EIOItems.PLANT_MATTER_BROWN.get(), 0.05f)), 2400, finishedRecipeConsumer);
        this.build("leaves", Ingredient.m_204132_((TagKey)ItemTags.f_13143_), List.of(this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.1f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.02f)), 2400, finishedRecipeConsumer);
        this.build("vines", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42029_}), List.of(this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.15f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.1f)), 2400, finishedRecipeConsumer);
        this.build("cactus", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_}), List.of(this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 3), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 3, 0.75f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 3, 0.5f), this.output((Item)EIOItems.PLANT_MATTER_BROWN.get(), 3, 0.25f)), 2400, finishedRecipeConsumer);
        this.build("lily_pad", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42094_}), List.of(this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 3, 0.15f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 3, 0.1f)), 2400, finishedRecipeConsumer);
        this.build("sun_flower", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42029_}), List.of(this.output(Items.f_42539_, 2, 0.8f), this.output(Items.f_42539_, 0.6f), this.output(Items.f_42539_, 2, 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.2f)), 2400, finishedRecipeConsumer);
        this.build("tall_grass", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42210_}), List.of(this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 2, 0.6f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 2, 0.1f), this.output((Item)EIOItems.PLANT_MATTER_BROWN.get(), 0.15f)), 2400, finishedRecipeConsumer);
        this.build("large_fern", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42211_}), List.of(this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 2, 0.6f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 2, 0.1f), this.output((Item)EIOItems.PLANT_MATTER_BROWN.get(), 0.15f)), 2400, finishedRecipeConsumer);
        this.build("rose_bush", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42208_}), List.of(this.output(Items.f_42497_, 2, 0.8f), this.output(Items.f_42497_, 0.6f), this.output(Items.f_42497_, 2, 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.2f)), 2400, finishedRecipeConsumer);
        this.build("poeny", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42209_}), List.of(this.output(Items.f_42489_, 2, 0.8f), this.output(Items.f_42489_, 0.6f), this.output(Items.f_42489_, 2, 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.2f)), 2400, finishedRecipeConsumer);
        this.build("sugar_canes", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_}), List.of(this.output(Items.f_42501_), this.output(Items.f_42501_, 0.5f), this.output(Items.f_42501_, 2, 0.5f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.2f)), 2400, finishedRecipeConsumer);
        this.build("flower_pot", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42618_}), List.of(this.output(Items.f_42460_, 0.9f), this.output(Items.f_42460_, 0.3f), this.output(Items.f_42460_, 0.1f), this.output((Item)EIOItems.POWDERED_COAL.get(), 0.05f)), 2400, finishedRecipeConsumer);
        this.build("prismarine_shard", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42695_}), List.of(this.output(Items.f_42696_), this.output(Items.f_42696_, 0.1f)), 2400, SagMillingRecipe.BonusType.NONE, finishedRecipeConsumer);
        this.build("wither_rose", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41951_}), List.of(this.output((Item)EIOItems.WITHERING_POWDER.get(), 1, 0.4f)), 2400, finishedRecipeConsumer);
        this.build("wither_skull", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42679_}), List.of(this.output((Item)EIOItems.WITHERING_POWDER.get(), 2), this.output((Item)EIOItems.WITHERING_POWDER.get(), 1, 0.2f)), 2400, finishedRecipeConsumer);
    }

    private void buildOre(String name, Ingredient input, Item output, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(name, input, List.of(this.output(output), this.output(output, 0.33f), this.output(Items.f_42594_, 0.15f)), 2400, recipeConsumer);
    }

    private void buildFlower(String name, Item input, Item output, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(name, Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), List.of(this.output(output, 0.8f), this.output(output, 0.6f), this.output(output, 0.3f), this.output((Item)EIOItems.PLANT_MATTER_GREEN.get(), 0.1f)), 2400, recipeConsumer);
    }

    private void build1toN(String name, Item input, Item output, int number, SagMillingRecipe.BonusType bonusType, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(name, Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), List.of(this.output(output, number)), 2400, bonusType, recipeConsumer);
    }

    private void build1toN(String name, TagKey<Item> input, Item output, int number, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(name, Ingredient.m_204132_(input), List.of(this.output(output, number)), 2400, recipeConsumer);
    }

    private void build1toN(String name, TagKey<Item> input, Item output, int number, SagMillingRecipe.BonusType bonusType, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(name, Ingredient.m_204132_(input), List.of(this.output(output, number)), 2400, bonusType, recipeConsumer);
    }

    protected void build(String name, Ingredient input, List<SagMillingRecipe.OutputItem> outputs, int energy, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(EnderIO.loc("sag_milling/" + name), input, outputs, energy, SagMillingRecipe.BonusType.MULTIPLY_OUTPUT, recipeConsumer);
    }

    protected void build(String name, Ingredient input, List<SagMillingRecipe.OutputItem> outputs, int energy, SagMillingRecipe.BonusType bonusType, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(EnderIO.loc("sag_milling/" + name), input, outputs, energy, bonusType, recipeConsumer);
    }

    protected void build(ResourceLocation id, Ingredient input, List<SagMillingRecipe.OutputItem> outputs, int energy, SagMillingRecipe.BonusType bonusType, Consumer<FinishedRecipe> recipeConsumer) {
        recipeConsumer.accept(new FinishedSagMillRecipe(id, input, outputs, energy, bonusType));
    }

    protected SagMillingRecipe.OutputItem output(Item item) {
        return this.output(item, 1, 1.0f, false);
    }

    protected SagMillingRecipe.OutputItem output(Item item, int count) {
        return this.output(item, count, 1.0f, false);
    }

    protected SagMillingRecipe.OutputItem output(Item item, float chance) {
        return this.output(item, 1, chance, false);
    }

    protected SagMillingRecipe.OutputItem output(Item item, int count, float chance) {
        return this.output(item, count, chance, false);
    }

    protected SagMillingRecipe.OutputItem output(Item item, int count, float chance, boolean optional) {
        return SagMillingRecipe.OutputItem.of(item, count, chance, optional);
    }

    protected SagMillingRecipe.OutputItem output(TagKey<Item> tag) {
        return this.output(tag, 1, 1.0f, false);
    }

    protected SagMillingRecipe.OutputItem output(TagKey<Item> tag, int count) {
        return this.output(tag, count, 1.0f, false);
    }

    protected SagMillingRecipe.OutputItem output(TagKey<Item> tag, float chance) {
        return this.output(tag, 1, chance, false);
    }

    protected SagMillingRecipe.OutputItem output(TagKey<Item> tag, int count, float chance) {
        return this.output(tag, count, chance, false);
    }

    protected SagMillingRecipe.OutputItem output(TagKey<Item> tag, int count, float chance, boolean optional) {
        return SagMillingRecipe.OutputItem.of(tag, count, chance, optional);
    }

    protected static class FinishedSagMillRecipe
    extends EnderRecipeProvider.EnderFinishedRecipe {
        private final Ingredient input;
        private final List<SagMillingRecipe.OutputItem> outputs;
        private final int energy;
        private final SagMillingRecipe.BonusType bonusType;

        public FinishedSagMillRecipe(ResourceLocation id, Ingredient input, List<SagMillingRecipe.OutputItem> outputs, int energy, SagMillingRecipe.BonusType bonusType) {
            super(id);
            this.input = input;
            this.outputs = outputs;
            this.energy = energy;
            this.bonusType = bonusType;
            for (SagMillingRecipe.OutputItem output : this.outputs) {
                if (!output.isTag() || output.isOptional()) continue;
                this.addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(output.getTag().f_203868_())));
            }
        }

        @Override
        public void m_7917_(JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.addProperty("energy", (Number)this.energy);
            if (this.bonusType != SagMillingRecipe.BonusType.MULTIPLY_OUTPUT) {
                json.addProperty("bonus", this.bonusType.toString().toLowerCase(Locale.ROOT));
            }
            JsonArray outputJson = new JsonArray();
            for (SagMillingRecipe.OutputItem item : this.outputs) {
                JsonObject obj = new JsonObject();
                if (item.isTag()) {
                    obj.addProperty("tag", item.getTag().f_203868_().toString());
                } else {
                    obj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)item.getItem()).toString());
                }
                if (item.getCount() != 1) {
                    obj.addProperty("count", (Number)item.getCount());
                }
                if (item.getChance() < 1.0f) {
                    obj.addProperty("chance", (Number)Float.valueOf(item.getChance()));
                }
                if (item.isOptional()) {
                    obj.addProperty("optional", Boolean.valueOf(item.isOptional()));
                }
                outputJson.add((JsonElement)obj);
            }
            json.add("outputs", (JsonElement)outputJson);
            super.m_7917_(json);
        }

        @Override
        protected Set<String> getModDependencies() {
            HashSet<String> mods = new HashSet<String>(RecipeDataUtil.getIngredientModIds(this.input));
            this.outputs.stream().forEach(outputItem -> {
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)outputItem.getItem());
                if (itemId != null) {
                    mods.add(itemId.m_135827_());
                }
            });
            return mods;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)MachineRecipes.SAG_MILLING.serializer().get();
        }
    }
}

