/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.data.recipes;

import com.enderio.EnderIO;
import com.enderio.base.common.block.glass.FusedQuartzBlock;
import com.enderio.base.common.block.glass.GlassBlocks;
import com.enderio.base.common.block.glass.GlassCollisionPredicate;
import com.enderio.base.common.block.glass.GlassIdentifier;
import com.enderio.base.common.block.glass.GlassLighting;
import com.enderio.base.common.init.EIOBlocks;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.data.recipe.RecipeDataUtil;
import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.core.data.recipes.EnderRecipeProvider;
import com.enderio.machines.common.init.MachineRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AlloyRecipeProvider
extends EnderRecipeProvider {
    public AlloyRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        this.build(new ItemStack((ItemLike)EIOItems.ENERGETIC_ALLOY_INGOT.get()), List.of(CountedIngredient.of((TagKey<Item>)Tags.Items.DUSTS_REDSTONE), CountedIngredient.of((TagKey<Item>)Tags.Items.INGOTS_GOLD), CountedIngredient.of((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE)), 4800, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.COPPER_ALLOY_INGOT.get()), List.of(CountedIngredient.of((TagKey<Item>)Tags.Items.INGOTS_COPPER), CountedIngredient.of(EIOTags.Items.SILICON)), 3200, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.VIBRANT_ALLOY_INGOT.get()), List.of(CountedIngredient.of(EIOTags.Items.INGOTS_ENERGETIC_ALLOY), CountedIngredient.of((TagKey<Item>)Tags.Items.ENDER_PEARLS)), 4800, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.REDSTONE_ALLOY_INGOT.get()), List.of(CountedIngredient.of((TagKey<Item>)Tags.Items.DUSTS_REDSTONE), CountedIngredient.of(EIOTags.Items.SILICON)), 3200, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.CONDUCTIVE_ALLOY_INGOT.get()), List.of(CountedIngredient.of(EIOTags.Items.INGOTS_COPPER_ALLOY), CountedIngredient.of((TagKey<Item>)Tags.Items.INGOTS_IRON), CountedIngredient.of((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)), 4800, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.PULSATING_ALLOY_INGOT.get()), List.of(CountedIngredient.of((TagKey<Item>)Tags.Items.INGOTS_IRON), CountedIngredient.of((TagKey<Item>)Tags.Items.ENDER_PEARLS)), 4800, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.DARK_STEEL_INGOT.get()), List.of(CountedIngredient.of((TagKey<Item>)Tags.Items.INGOTS_IRON), CountedIngredient.of(EIOTags.Items.DUSTS_COAL), CountedIngredient.of((TagKey<Item>)Tags.Items.OBSIDIAN)), 6400, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.SOULARIUM_INGOT.get()), List.of(CountedIngredient.of(new ItemLike[]{Items.f_42049_, Items.f_42050_}), CountedIngredient.of((TagKey<Item>)Tags.Items.INGOTS_GOLD)), 5600, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.END_STEEL_INGOT.get()), List.of(CountedIngredient.of((TagKey<Item>)Tags.Items.END_STONES), CountedIngredient.of(EIOTags.Items.INGOTS_DARK_STEEL), CountedIngredient.of((TagKey<Item>)Tags.Items.OBSIDIAN)), 6400, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.DYE_GREEN.get()), "clippings", List.of(CountedIngredient.of(6, (ItemLike)EIOItems.PLANT_MATTER_GREEN.get()), CountedIngredient.of(new ItemLike[]{Items.f_42521_})), 1000, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.DYE_GREEN.get(), 2), "double_clippings", List.of(CountedIngredient.of(12, (ItemLike)EIOItems.PLANT_MATTER_GREEN.get()), CountedIngredient.of((TagKey<Item>)Tags.Items.SLIMEBALLS)), 1600, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.DYE_BROWN.get()), "twigs", List.of(CountedIngredient.of(6, (ItemLike)EIOItems.PLANT_MATTER_BROWN.get()), CountedIngredient.of(new ItemLike[]{Items.f_42521_})), 1000, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.DYE_BROWN.get(), 2), "twigs_double", List.of(CountedIngredient.of(12, (ItemLike)EIOItems.PLANT_MATTER_BROWN.get()), CountedIngredient.of((TagKey<Item>)Tags.Items.SLIMEBALLS)), 1600, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.DYE_BLACK.get()), List.of(CountedIngredient.of(1, EIOTags.Items.DUSTS_COAL), CountedIngredient.of(new ItemLike[]{Items.f_42521_})), 1000, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.DYE_BLACK.get(), 2), "double", List.of(CountedIngredient.of(2, EIOTags.Items.DUSTS_COAL), CountedIngredient.of((TagKey<Item>)Tags.Items.SLIMEBALLS)), 1600, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)Items.f_42497_, 12), List.of(CountedIngredient.of(new ItemLike[]{Items.f_42732_}), CountedIngredient.of(3, new ItemLike[]{Items.f_42461_}), CountedIngredient.of(6, new ItemLike[]{Items.f_42521_})), 1600, 0.3f, pFinishedRecipeConsumer);
        for (Map.Entry<GlassIdentifier, GlassBlocks> glassGroup : EIOBlocks.GLASS_BLOCKS.entrySet()) {
            int energy;
            GlassIdentifier identifier = glassGroup.getKey();
            if (identifier.collisionPredicate() != GlassCollisionPredicate.NONE) continue;
            FusedQuartzBlock clear = (FusedQuartzBlock)((Object)glassGroup.getValue().CLEAR.get());
            CountedIngredient mainIngredient = identifier.explosion_resistance() ? CountedIngredient.of(4, (TagKey<Item>)Tags.Items.GEMS_QUARTZ) : CountedIngredient.of((TagKey<Item>)Tags.Items.GLASS_COLORLESS);
            CountedIngredient altIngredient = identifier.explosion_resistance() ? CountedIngredient.of((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ) : null;
            int n = energy = identifier.explosion_resistance() ? 6400 : 3200;
            if (identifier.lighting() == GlassLighting.NONE) {
                this.glass(clear, mainIngredient, altIngredient, energy, 0.3f, pFinishedRecipeConsumer);
                continue;
            }
            CountedIngredient composite = identifier.lighting() == GlassLighting.EMITTING ? CountedIngredient.of(4, (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE) : CountedIngredient.of(4, (TagKey<Item>)Tags.Items.GEMS_AMETHYST);
            CountedIngredient compositeB = identifier.lighting() == GlassLighting.EMITTING ? CountedIngredient.of(new ItemLike[]{Blocks.f_50141_}) : CountedIngredient.of((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_AMETHYST);
            this.compositeGlass(clear, "from_main", mainIngredient, composite, compositeB, energy, 0.3f, pFinishedRecipeConsumer);
            if (altIngredient != null) {
                this.compositeGlass(clear, "from_storage", altIngredient, composite, compositeB, energy, 0.3f, pFinishedRecipeConsumer);
            }
            Block withoutLight = (Block)EIOBlocks.GLASS_BLOCKS.get((Object)identifier.withoutLight()).CLEAR.get();
            this.compositeGlass(clear, "from_base", CountedIngredient.of(new ItemLike[]{withoutLight}), composite, compositeB, energy / 2, 0.3f, pFinishedRecipeConsumer);
        }
        this.build(new ItemStack((ItemLike)EIOItems.NETHERCOTTA.get()), List.of(CountedIngredient.of((TagKey<Item>)Tags.Items.INGOTS_NETHER_BRICK), CountedIngredient.of(4, new ItemLike[]{Items.f_42588_}), CountedIngredient.of(6, new ItemLike[]{Items.f_42461_})), 7600, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.CAKE_BASE.get(), 2), List.of(CountedIngredient.of(3, (ItemLike)EIOItems.FLOUR.get()), CountedIngredient.of(new ItemLike[]{Items.f_42521_})), 2000, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)Items.f_42572_, 8), List.of(CountedIngredient.of((ItemLike)EIOItems.FLOUR.get()), CountedIngredient.of(new ItemLike[]{Items.f_42533_})), 2000, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.PHOTOVOLTAIC_PLATE.get()), List.of(CountedIngredient.of(3, (ItemLike)EIOItems.PHOTOVOLTAIC_COMPOSITE.get())), 5600, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)Items.f_42584_), List.of(CountedIngredient.of(9, EIOTags.Items.DUSTS_ENDER)), 2000, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)Items.f_41866_), List.of(CountedIngredient.of((TagKey<Item>)ItemTags.f_13180_)), 500, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOItems.CLAYED_GLOWSTONE.get(), 2), List.of(CountedIngredient.of((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE), CountedIngredient.of(new ItemLike[]{Items.f_42461_})), 3200, 0.3f, pFinishedRecipeConsumer);
        this.build(new ItemStack((ItemLike)EIOBlocks.INDUSTRIAL_INSULATION.get()), List.of(CountedIngredient.of(EIOTags.Items.DUSTS_LAPIS), CountedIngredient.of((TagKey<Item>)ItemTags.f_13167_), CountedIngredient.of(EIOTags.Items.INSULATION_METAL)), 3200, 0.5f, pFinishedRecipeConsumer);
    }

    protected void glass(FusedQuartzBlock block, CountedIngredient input, int energy, float experience, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(new ItemStack((ItemLike)block), List.of(input), energy, experience, recipeConsumer);
    }

    protected void glass(FusedQuartzBlock block, CountedIngredient input, @Nullable CountedIngredient inputAlt, int energy, float experience, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(new ItemStack((ItemLike)block), List.of(input), energy, experience, recipeConsumer);
        if (inputAlt != null) {
            this.build(new ItemStack((ItemLike)block), "alt", List.of(inputAlt), energy, experience, recipeConsumer);
        }
    }

    protected void compositeGlass(FusedQuartzBlock block, String suffix, CountedIngredient inputA, CountedIngredient inputB, CountedIngredient inputBAlt, int energy, float experience, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(new ItemStack((ItemLike)block), suffix, List.of(inputA, inputB), energy, experience, recipeConsumer);
        this.build(new ItemStack((ItemLike)block), suffix + "_alt", List.of(inputA, inputBAlt), energy, experience, recipeConsumer);
    }

    protected void build(ItemStack output, List<CountedIngredient> inputs, int energy, float experience, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(EnderIO.loc("alloy_smelting/" + ForgeRegistries.ITEMS.getKey((Object)output.m_41720_()).m_135815_()), inputs, output, energy, experience, recipeConsumer);
    }

    protected void build(ItemStack output, String suffix, List<CountedIngredient> inputs, int energy, float experience, Consumer<FinishedRecipe> recipeConsumer) {
        this.build(EnderIO.loc("alloy_smelting/" + ForgeRegistries.ITEMS.getKey((Object)output.m_41720_()).m_135815_() + "_" + suffix), inputs, output, energy, experience, recipeConsumer);
    }

    protected void build(ResourceLocation id, List<CountedIngredient> inputs, ItemStack output, int energy, float experience, Consumer<FinishedRecipe> recipeConsumer) {
        recipeConsumer.accept(new FinishedAlloyingRecipe(id, inputs, output, energy, experience));
    }

    protected static class FinishedAlloyingRecipe
    extends EnderRecipeProvider.EnderFinishedRecipe {
        private final List<CountedIngredient> inputs;
        private final ItemStack output;
        private final int energy;
        private final float experience;

        public FinishedAlloyingRecipe(ResourceLocation id, List<CountedIngredient> inputs, ItemStack output, int energy, float experience) {
            super(id);
            this.inputs = inputs;
            this.output = output;
            this.energy = energy;
            this.experience = experience;
        }

        @Override
        public void m_7917_(JsonObject json) {
            JsonArray jsonInputs = new JsonArray(this.inputs.size());
            this.inputs.forEach(ing -> jsonInputs.add((JsonElement)ing.toJson()));
            json.add("inputs", (JsonElement)jsonInputs);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).toString());
            if (this.output.m_41613_() > 1) {
                jsonobject.addProperty("count", (Number)this.output.m_41613_());
            }
            json.add("result", (JsonElement)jsonobject);
            json.addProperty("energy", (Number)this.energy);
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            super.m_7917_(json);
        }

        @Override
        protected Set<String> getModDependencies() {
            HashSet<String> mods = new HashSet<String>(RecipeDataUtil.getCountedIngredientsModIds(this.inputs));
            mods.add(ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135827_());
            return mods;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)MachineRecipes.ALLOY_SMELTING.serializer().get();
        }
    }
}

