/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.energy;

import com.enderio.api.capability.IEnderCapabilityProvider;
import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class MachineEnergyStorage
implements IMachineEnergyStorage,
IEnderCapabilityProvider<IEnergyStorage>,
INBTSerializable<CompoundTag> {
    private final IIOConfig config;
    private final EnergyIOMode ioMode;
    private int energyStored;
    private final Supplier<Integer> capacity;
    private final Supplier<Integer> usageRate;
    private final EnumMap<Direction, LazyOptional<Sided>> sideCache = new EnumMap(Direction.class);
    private LazyOptional<MachineEnergyStorage> selfCache = LazyOptional.empty();

    public MachineEnergyStorage(IIOConfig config, EnergyIOMode ioMode, Supplier<Integer> capacity, Supplier<Integer> usageRate) {
        this.config = config;
        this.ioMode = ioMode;
        this.capacity = capacity;
        this.usageRate = usageRate;
    }

    @Override
    public final IIOConfig getConfig() {
        return this.config;
    }

    @Override
    public final EnergyIOMode getIOMode() {
        return this.ioMode;
    }

    protected void onContentsChanged() {
    }

    public int getEnergyStored() {
        return Math.min(this.energyStored, this.getMaxEnergyStored());
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energyStored = Math.min(energy, this.getMaxEnergyStored());
        this.onContentsChanged();
    }

    @Override
    public int addEnergy(int energy) {
        return this.addEnergy(energy, false);
    }

    @Override
    public int addEnergy(int energy, boolean simulate) {
        int energyBefore = this.getEnergyStored();
        int newEnergyStored = Math.min(this.getEnergyStored() + energy, this.getMaxEnergyStored());
        if (!simulate) {
            this.setEnergyStored(newEnergyStored);
            this.onContentsChanged();
        }
        return newEnergyStored - energyBefore;
    }

    @Override
    public int takeEnergy(int energy) {
        int energyBefore = this.getEnergyStored();
        this.setEnergyStored(Math.max(this.getEnergyStored() - energy, 0));
        this.onContentsChanged();
        return energyBefore - this.getEnergyStored();
    }

    @Override
    public int consumeEnergy(int energy, boolean simulate) {
        int usableEnergy = Math.min(energy, this.getMaxEnergyUse());
        if (!simulate) {
            return this.takeEnergy(usableEnergy);
        }
        return usableEnergy;
    }

    public int getMaxEnergyStored() {
        return this.capacity.get();
    }

    @Override
    public int getMaxEnergyUse() {
        return this.usageRate.get();
    }

    public boolean canExtract() {
        return this.ioMode.canOutput();
    }

    public boolean canReceive() {
        return this.ioMode.canInput();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive() || this.getMaxEnergyStored() == 0) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxEnergyUse() * 2, maxReceive));
        if (!simulate) {
            this.addEnergy(energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), maxExtract);
        if (!simulate) {
            this.takeEnergy(energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public Capability<IEnergyStorage> getCapabilityType() {
        return ForgeCapabilities.ENERGY;
    }

    @Override
    public LazyOptional<IEnergyStorage> getCapability(@Nullable Direction side) {
        if (side == null) {
            if (!this.selfCache.isPresent()) {
                this.selfCache = LazyOptional.of(() -> this);
            }
            return this.selfCache.cast();
        }
        if (!this.config.getMode(side).canConnect()) {
            return LazyOptional.empty();
        }
        return this.sideCache.computeIfAbsent(side, dir -> LazyOptional.of(() -> new Sided(this, (Direction)dir))).cast();
    }

    @Override
    public void invalidateSide(@Nullable Direction side) {
        if (side != null) {
            if (this.sideCache.containsKey(side)) {
                this.sideCache.get(side).invalidate();
                this.sideCache.remove(side);
            }
        } else {
            this.selfCache.invalidate();
        }
    }

    @Override
    public void invalidateCaps() {
        for (LazyOptional<Sided> side : this.sideCache.values()) {
            side.invalidate();
        }
        this.selfCache.invalidate();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("EnergyStored", this.getEnergyStored());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setEnergyStored(nbt.m_128451_("EnergyStored"));
    }

    private static class Sided
    implements IEnergyStorage {
        private final MachineEnergyStorage wrapped;
        private final Direction side;

        Sided(MachineEnergyStorage wrapped, Direction side) {
            this.wrapped = wrapped;
            this.side = side;
        }

        public int getEnergyStored() {
            return this.wrapped.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.wrapped.getMaxEnergyStored();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            return this.wrapped.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            return this.wrapped.extractEnergy(maxExtract, simulate);
        }

        public boolean canExtract() {
            if (this.wrapped.getIOMode().respectIOConfig() && !this.wrapped.getConfig().getMode(this.side).canOutput()) {
                return false;
            }
            return this.wrapped.canExtract();
        }

        public boolean canReceive() {
            if (this.wrapped.getIOMode().respectIOConfig() && !this.wrapped.getConfig().getMode(this.side).canInput()) {
                return false;
            }
            return this.wrapped.canReceive();
        }
    }
}

