/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.UseOnly;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.core.common.network.slot.FloatNetworkDataSlot;
import com.enderio.machines.common.blockentity.AlloySmelterBlockEntity;
import com.enderio.machines.common.blockentity.AlloySmelterMode;
import com.enderio.machines.common.blockentity.task.CraftingMachineTask;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.energy.MachineEnergyStorage;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.PrimitiveAlloySmelterMenu;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class PrimitiveAlloySmelterBlockEntity
extends AlloySmelterBlockEntity {
    private int burnTime;
    private int burnDuration;
    public static final SingleSlotAccess FUEL = new SingleSlotAccess();
    public static final MultiSlotAccess INPUTS = new MultiSlotAccess();
    public static final SingleSlotAccess OUTPUT = new SingleSlotAccess();
    @UseOnly(value=LogicalSide.CLIENT)
    private float clientBurnProgress;

    public PrimitiveAlloySmelterBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
        this.addDataSlot(new FloatNetworkDataSlot(this::getBurnProgress, p -> {
            this.clientBurnProgress = p.floatValue();
        }));
    }

    @Override
    protected boolean isPrimitiveSmelter() {
        return true;
    }

    @Override
    protected MultiSlotAccess getInputsSlotAccess() {
        return INPUTS;
    }

    @Override
    protected SingleSlotAccess getOutputSlotAccess() {
        return OUTPUT;
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().inputSlot((s, i) -> ForgeHooks.getBurnTime((ItemStack)i, (RecipeType)RecipeType.f_44108_) > 0).slotAccess(FUEL).inputSlot(3, this::acceptSlotInput).slotAccess(INPUTS).outputSlot().slotAccess(OUTPUT).build();
    }

    @Override
    public AlloySmelterMode getMode() {
        return AlloySmelterMode.ALLOYS;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new PrimitiveAlloySmelterMenu(this, inventory, containerId);
    }

    @Override
    public void serverTick() {
        int burningTime;
        ItemStack fuel;
        super.serverTick();
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (this.canAct() && !this.isBurning() && this.craftingTaskHost.hasTask() && !((CraftingMachineTask)this.craftingTaskHost.getCurrentTask()).isCompleted() && !(fuel = FUEL.getItemStack(this)).m_41619_() && (burningTime = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_)) > 0) {
            this.burnDuration = this.burnTime = burningTime;
            if (fuel.hasCraftingRemainingItem()) {
                FUEL.setStackInSlot(this, fuel.getCraftingRemainingItem());
            } else {
                fuel.m_41774_(1);
            }
        }
    }

    @Override
    protected boolean canAcceptTask() {
        return super.canAcceptTask() || !FUEL.getItemStack(this).m_41619_();
    }

    @Override
    protected MachineEnergyStorage createEnergyStorage(EnergyIOMode energyIOMode, Supplier<Integer> capacity, Supplier<Integer> usageRate) {
        return new MachineEnergyStorage(this.getIOConfig(), energyIOMode, this::getBurnToFE, () -> 0){

            @Override
            public int getEnergyStored() {
                if (PrimitiveAlloySmelterBlockEntity.this.isBurning()) {
                    return PrimitiveAlloySmelterBlockEntity.this.getBurnToFE();
                }
                return 0;
            }

            @Override
            public int consumeEnergy(int energy, boolean simulate) {
                if (PrimitiveAlloySmelterBlockEntity.this.isBurning()) {
                    return PrimitiveAlloySmelterBlockEntity.this.getBurnToFE();
                }
                return 0;
            }

            @Override
            public LazyOptional<IEnergyStorage> getCapability(@Nullable Direction side) {
                return LazyOptional.empty();
            }
        };
    }

    @Override
    @Nullable
    public MachineEnergyStorage createExposedEnergyStorage() {
        return null;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public float getBurnProgress() {
        if (this.f_58857_.f_46443_) {
            return this.clientBurnProgress;
        }
        if (this.burnDuration == 0) {
            return 0.0f;
        }
        return (float)this.burnTime / (float)this.burnDuration;
    }

    public int getBurnToFE() {
        return (Integer)MachinesConfig.COMMON.ENERGY.STIRLING_GENERATOR_PRODUCTION.get() / 2;
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.isBurning();
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("BurnTime", this.burnTime);
        pTag.m_128405_("BurnDuration", this.burnDuration);
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        this.burnTime = pTag.m_128451_("BurnTime");
        this.burnDuration = pTag.m_128451_("BurnDuration");
        super.m_142466_(pTag);
    }
}

