/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.block;

import com.enderio.base.common.tag.EIOTags;
import com.enderio.core.common.blockentity.EnderBlockEntity;
import com.enderio.core.common.compat.FlywheelCompat;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class MachineBlock
extends BaseEntityBlock {
    private final BlockEntityEntry<? extends MachineBlockEntity> blockEntityType;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public MachineBlock(BlockBehaviour.Properties properties, BlockEntityEntry<? extends MachineBlockEntity> blockEntityType) {
        super(properties);
        this.blockEntityType = blockEntityType;
        BlockState any = (BlockState)this.m_49965_().m_61090_();
        this.m_49959_(any.m_61138_((Property)FACING) ? (BlockState)any.m_61124_((Property)FACING, (Comparable)Direction.NORTH) : any);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return MachineBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)this.blockEntityType.get()), EnderBlockEntity::tick);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        this.updateBlockEntityCache((LevelReader)pLevel, pPos);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        this.updateBlockEntityCache(level, pos);
    }

    private void updateBlockEntityCache(LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity machineBlockEntity = (MachineBlockEntity)blockEntity;
            machineBlockEntity.markCapabilityCacheDirty();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult res;
        if (level.m_5776_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity entity = level.m_7702_(pos);
        if (!(entity instanceof MachineBlockEntity)) {
            return InteractionResult.PASS;
        }
        MachineBlockEntity machineBlockEntity = (MachineBlockEntity)entity;
        if (!level.f_46443_ && player.m_21120_(hand).m_204117_(EIOTags.Items.WRENCH) && (res = machineBlockEntity.onWrenched(player, hit.m_82434_())) != InteractionResult.PASS) {
            return res;
        }
        InteractionResult result = machineBlockEntity.onBlockEntityUsed(state, level, pos, player, hand, hit);
        if (result != InteractionResult.CONSUME) {
            if (!machineBlockEntity.canOpenMenu()) {
                return InteractionResult.PASS;
            }
            MenuProvider menuprovider = this.m_7246_(state, level, pos);
            if (menuprovider != null && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)menuprovider, buf -> buf.m_130064_(pos));
            }
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return this.blockEntityType.create(pPos, pState);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity machineBlock = (MachineBlockEntity)blockEntity;
            return machineBlock.supportsRedstoneControl();
        }
        return super.canConnectRedstone(state, level, pos, direction);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity existingBlockEntity = ModList.get().isLoaded("flywheel") ? FlywheelCompat.getExistingBlockEntity(level, pos) : level.getExistingBlockEntity(pos);
        if (existingBlockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity machineBlock = (MachineBlockEntity)existingBlockEntity;
            return machineBlock.getLightEmission();
        }
        return super.getLightEmission(state, level, pos);
    }
}

