/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.capability;

import com.enderio.api.filter.FluidStackFilter;
import com.enderio.core.common.capability.IFilterCapability;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterCapability
implements IFilterCapability<FluidStack>,
FluidStackFilter {
    private static final String NBT_KEY = "IsNbt";
    private static final String INVERTED_KEY = "IsInverted";
    private static final String ENTRIES_KEY = "FluidEntries";
    private final ItemStack container;

    public FluidFilterCapability(ItemStack container, int size) {
        this.container = container;
        CompoundTag tag = container.m_41784_();
        if (!tag.m_128425_(ENTRIES_KEY, 9)) {
            ListTag entriesList = new ListTag();
            for (int i = 0; i < size; ++i) {
                entriesList.add((Object)ItemStack.f_41583_.serializeNBT());
            }
            tag.m_128365_(ENTRIES_KEY, (Tag)entriesList);
        }
    }

    @Override
    public void setNbt(Boolean nbt) {
        CompoundTag tag = this.container.m_41784_();
        tag.m_128379_(NBT_KEY, nbt.booleanValue());
    }

    @Override
    public boolean isNbt() {
        CompoundTag tag = this.container.m_41784_();
        return tag.m_128425_(NBT_KEY, 1) && tag.m_128471_(NBT_KEY);
    }

    @Override
    public void setInverted(Boolean inverted) {
        CompoundTag tag = this.container.m_41784_();
        tag.m_128379_(INVERTED_KEY, inverted.booleanValue());
    }

    @Override
    public boolean isInvert() {
        CompoundTag tag = this.container.m_41784_();
        return tag.m_128425_(INVERTED_KEY, 1) && tag.m_128471_(INVERTED_KEY);
    }

    @Override
    public List<FluidStack> getEntries() {
        CompoundTag tag = this.container.m_41784_();
        ArrayList<FluidStack> entries = new ArrayList<FluidStack>();
        if (tag.m_128425_(ENTRIES_KEY, 9)) {
            ListTag entriesList = tag.m_128437_(ENTRIES_KEY, 10);
            for (Tag entry : entriesList) {
                entries.add(FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)entry)));
            }
        }
        return entries;
    }

    @Override
    public void setEntry(int pSlotId, FluidStack entry) {
        ListTag entriesList;
        CompoundTag tag = this.container.m_41784_();
        if (tag.m_128425_(ENTRIES_KEY, 9)) {
            entriesList = tag.m_128437_(ENTRIES_KEY, 10);
        } else {
            entriesList = new ListTag();
            tag.m_128365_(ENTRIES_KEY, (Tag)entriesList);
        }
        entriesList.set(pSlotId, (Tag)entry.writeToNBT(new CompoundTag()));
    }

    @Override
    public boolean test(FluidStack stack) {
        for (FluidStack testStack : this.getEntries()) {
            boolean test = this.isNbt() ? FluidStack.areFluidStackTagsEqual((FluidStack)testStack, (FluidStack)stack) : testStack.isFluidEqual(stack);
            if (!test) continue;
            return !this.isInvert();
        }
        return this.isInvert();
    }
}

