/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.screen;

import com.enderio.api.misc.Vector2i;
import com.enderio.core.client.gui.screen.IEnderScreen;
import com.enderio.core.client.gui.screen.IFullScreenListener;
import com.enderio.core.client.gui.widgets.EnumIconWidget;
import com.enderio.core.common.menu.SyncedMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class EIOScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IEnderScreen {
    private final boolean renderLabels;
    private final List<EditBox> editBoxList = new ArrayList<EditBox>();
    private final List<IEnderScreen.LateTooltipData> tooltips = new ArrayList<IEnderScreen.LateTooltipData>();

    protected EIOScreen(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        this(pMenu, pPlayerInventory, pTitle, false);
    }

    protected EIOScreen(T pMenu, Inventory pPlayerInventory, Component pTitle, boolean renderLabels) {
        super(pMenu, pPlayerInventory, pTitle);
        this.renderLabels = renderLabels;
        this.f_97726_ = this.getBackgroundImageSize().x();
        this.f_97727_ = this.getBackgroundImageSize().y();
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        EnumIconWidget enumIconWidget;
        HashMap<String, String> oldEditBoxValues = new HashMap<String, String>();
        for (EditBox editBox : this.editBoxList) {
            oldEditBoxValues.put(editBox.m_6035_().getString(), editBox.m_94155_());
        }
        this.editBoxList.clear();
        HashMap<String, Boolean> oldEnums = new HashMap<String, Boolean>();
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof EnumIconWidget)) continue;
            enumIconWidget = (EnumIconWidget)renderable;
            oldEnums.put(enumIconWidget.getOptionName().getString(), enumIconWidget.isExpanded());
        }
        super.m_6574_(pMinecraft, pWidth, pHeight);
        for (EditBox editBox : this.editBoxList) {
            editBox.m_94144_(oldEditBoxValues.getOrDefault(editBox.m_6035_().getString(), ""));
        }
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof EnumIconWidget)) continue;
            enumIconWidget = (EnumIconWidget)renderable;
            enumIconWidget.setExpanded(oldEnums.getOrDefault(enumIconWidget.getOptionName().getString(), false));
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        SyncedMenu syncedMenu;
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof SyncedMenu && (syncedMenu = (SyncedMenu)abstractContainerMenu).getBlockEntity() == null) {
            return;
        }
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        this.m_280072_(guiGraphics, pMouseX, pMouseY);
        for (IEnderScreen.LateTooltipData tooltip : this.tooltips) {
            tooltip.getGuiGraphics().m_280677_(this.f_96547_, tooltip.getText(), Optional.empty(), tooltip.getMouseX(), tooltip.getMouseY());
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.tooltips.clear();
        guiGraphics.m_280218_(this.getBackgroundImage(), this.getGuiLeft(), this.getGuiTop(), 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            Minecraft.m_91087_().f_91074_.m_6915_();
        }
        for (EditBox editBox : this.editBoxList) {
            if (!editBox.m_7933_(pKeyCode, pScanCode, pModifiers) && !editBox.m_94204_()) continue;
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (GuiEventListener widget : this.m_6702_()) {
            AbstractWidget abstractWidget;
            if (!(widget instanceof AbstractWidget) || !(abstractWidget = (AbstractWidget)widget).m_142518_() || !(widget instanceof IFullScreenListener)) continue;
            IFullScreenListener fullScreenListener = (IFullScreenListener)widget;
            fullScreenListener.onGlobalClick(pMouseX, pMouseY);
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        AbstractWidget abstractWidget;
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof AbstractWidget && (abstractWidget = (AbstractWidget)guiEventListener).m_142518_()) {
            return abstractWidget.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        if (this.renderLabels) {
            super.m_280003_(guiGraphics, pMouseX, pMouseY);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        for (EditBox editBox : this.editBoxList) {
            editBox.m_94120_();
        }
    }

    public abstract ResourceLocation getBackgroundImage();

    protected abstract Vector2i getBackgroundImageSize();

    protected <U extends GuiEventListener & NarratableEntry> U m_7787_(U guiEventListener) {
        if (guiEventListener instanceof EditBox) {
            EditBox editBox = (EditBox)guiEventListener;
            this.editBoxList.add(editBox);
        }
        return (U)super.m_7787_(guiEventListener);
    }

    protected void m_169411_(GuiEventListener guiEventListener) {
        super.m_169411_(guiEventListener);
        if (guiEventListener instanceof EditBox) {
            EditBox editBox = (EditBox)guiEventListener;
            this.editBoxList.remove(editBox);
        }
    }

    @Override
    public void addTooltip(IEnderScreen.LateTooltipData data) {
        this.tooltips.add(data);
    }
}

