/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.fluid;

import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.SlotType;
import com.enderio.api.conduit.TieredConduit;
import com.enderio.api.conduit.ticker.ConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.FluidStackFilter;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.conduits.common.capability.ExtractionSpeedUpgrade;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitData;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitTicker;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class FluidConduitType
extends TieredConduit<FluidConduitData> {
    public static final ConduitMenuData NORMAL_MENU_DATA = new ConduitMenuData.Simple(true, true, true, false, false, true);
    public static final ConduitMenuData ADVANCED_MENU_DATA = new ConduitMenuData.Simple(true, true, true, true, true, true);
    private final boolean isMultiFluid;
    private final int transferRate;
    private final ConduitTicker<FluidConduitData> ticker;

    public FluidConduitType(ResourceLocation tierName, int tier, boolean isMultiFluid) {
        super(new ResourceLocation("forge:fluid"), tierName, (isMultiFluid ? 100000 : 0) + tier);
        this.isMultiFluid = isMultiFluid;
        this.transferRate = tier;
        this.ticker = new FluidConduitTicker(!isMultiFluid, this.transferRate);
    }

    @Override
    public ConduitTicker<FluidConduitData> getTicker() {
        return this.ticker;
    }

    @Override
    public ConduitMenuData getMenuData() {
        return this.isMultiFluid ? ADVANCED_MENU_DATA : NORMAL_MENU_DATA;
    }

    @Override
    public FluidConduitData createConduitData(Level level, BlockPos pos) {
        return new FluidConduitData(this.isMultiFluid);
    }

    @Override
    public boolean canApplyUpgrade(SlotType slotType, ConduitUpgrade conduitUpgrade) {
        return conduitUpgrade instanceof ExtractionSpeedUpgrade;
    }

    @Override
    public boolean canApplyFilter(SlotType slotType, ResourceFilter resourceFilter) {
        return resourceFilter instanceof FluidStackFilter;
    }
}

