/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common;

import com.enderio.api.conduit.ConduitType;
import com.enderio.conduits.common.Area;
import com.enderio.conduits.common.conduit.ConduitBundle;
import com.enderio.conduits.common.conduit.OffsetHelper;
import com.enderio.conduits.common.conduit.connection.DynamicConnectionState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ConduitShape {
    private final Map<ConduitType<?>, VoxelShape> conduitShapes = new HashMap();
    private final Map<Direction, VoxelShape> directionShapes = new HashMap<Direction, VoxelShape>();
    private static final VoxelShape CONNECTOR = Block.m_49796_((double)2.5, (double)2.5, (double)15.0, (double)13.5, (double)13.5, (double)16.0);
    private static final VoxelShape CONNECTION = Block.m_49796_((double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5, (double)16.0);
    private static final VoxelShape CORE = Block.m_49796_((double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5);
    private VoxelShape totalShape = CORE;

    public void updateConduit(ConduitBundle bundle) {
        this.conduitShapes.clear();
        this.directionShapes.clear();
        for (ConduitType<?> type : bundle.getTypes()) {
            this.updateShapeForConduit(bundle, type);
        }
        this.updateTotalShape();
    }

    public VoxelShape getShapeFromHit(BlockPos pos, HitResult result) {
        return Optional.ofNullable(this.conduitShapes.get(this.getConduit(pos, result))).orElse(Shapes.m_83040_());
    }

    @Nullable
    public ConduitType<?> getConduit(BlockPos pos, HitResult result) {
        return this.getLookUpValue(this.conduitShapes, pos, result);
    }

    @Nullable
    public Direction getDirection(BlockPos pos, HitResult result) {
        return this.getLookUpValue(this.directionShapes, pos, result);
    }

    @Nullable
    private <T> T getLookUpValue(Map<T, VoxelShape> shapes, BlockPos pos, HitResult result) {
        for (Map.Entry<T, VoxelShape> entry : shapes.entrySet()) {
            Vec3 vec3 = result.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            Optional point = entry.getValue().m_166067_(vec3);
            if (point.isEmpty() || !((Vec3)point.get()).m_82509_((Position)vec3, (double)1.0E-5f)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void updateTotalShape() {
        this.totalShape = Shapes.m_83040_();
        this.conduitShapes.values().forEach(s -> {
            this.totalShape = Shapes.m_83148_((VoxelShape)this.totalShape, (VoxelShape)s, (BooleanOp)BooleanOp.f_82695_);
        });
        this.totalShape.m_83296_();
    }

    public VoxelShape getTotalShape() {
        return this.totalShape;
    }

    private void updateShapeForConduit(ConduitBundle conduitBundle, ConduitType<?> conduitType) {
        Vec3i offset;
        VoxelShape conduitShape = Shapes.m_83040_();
        Direction.Axis axis = OffsetHelper.findMainAxis(conduitBundle);
        HashMap<ConduitType, List> offsets = new HashMap<ConduitType, List>();
        for (Direction direction : Direction.values()) {
            List<ConduitType<?>> connectedTypes;
            VoxelShape directionShape = this.directionShapes.getOrDefault(direction, Shapes.m_83040_());
            if (conduitBundle.getConnectionState(direction, conduitType) instanceof DynamicConnectionState) {
                VoxelShape connectorShape = ConduitShape.rotateVoxelShape(CONNECTOR, direction);
                directionShape = Shapes.m_83148_((VoxelShape)directionShape, (VoxelShape)connectorShape, (BooleanOp)BooleanOp.f_82695_);
                conduitShape = Shapes.m_83148_((VoxelShape)conduitShape, (VoxelShape)connectorShape, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((connectedTypes = conduitBundle.getConnectedTypes(direction)).contains(conduitType)) {
                offset = OffsetHelper.translationFor(direction.m_122434_(), OffsetHelper.offsetConduit(connectedTypes.indexOf(conduitType), connectedTypes.size()));
                offsets.computeIfAbsent(conduitType, ignored -> new ArrayList()).add(offset);
                VoxelShape connectionShape = ConduitShape.rotateVoxelShape(CONNECTION, direction).m_83216_((double)((float)offset.m_123341_() * 3.0f / 16.0f), (double)((float)offset.m_123342_() * 3.0f / 16.0f), (double)((float)offset.m_123343_() * 3.0f / 16.0f));
                directionShape = Shapes.m_83148_((VoxelShape)directionShape, (VoxelShape)connectionShape, (BooleanOp)BooleanOp.f_82695_);
                conduitShape = Shapes.m_83148_((VoxelShape)conduitShape, (VoxelShape)connectionShape, (BooleanOp)BooleanOp.f_82695_);
            }
            this.directionShapes.put(direction, directionShape.m_83296_());
        }
        List<ConduitType<?>> allTypes = conduitBundle.getTypes();
        Area box = null;
        ConduitType<?> notRendered = null;
        int i = allTypes.indexOf(conduitType);
        if (i == -1) {
            this.conduitShapes.put(conduitType, Shapes.m_83144_());
            return;
        }
        ConduitType<?> type = allTypes.get(i);
        @Nullable List offsetsForType = (List)offsets.get(type);
        if (offsetsForType != null) {
            if (offsetsForType.stream().distinct().count() != 1L) {
                box = new Area(offsetsForType.toArray(new Vec3i[0]));
            }
        } else {
            notRendered = type;
        }
        if (!(offsetsForType == null || box != null && box.contains((Vec3i)offsetsForType.get(0)))) {
            conduitShape = Shapes.m_83148_((VoxelShape)conduitShape, (VoxelShape)CORE.m_83216_((double)((float)((Vec3i)offsetsForType.get(0)).m_123341_() * 3.0f / 16.0f), (double)((float)((Vec3i)offsetsForType.get(0)).m_123342_() * 3.0f / 16.0f), (double)((float)((Vec3i)offsetsForType.get(0)).m_123343_() * 3.0f / 16.0f)), (BooleanOp)BooleanOp.f_82695_);
        }
        if (box != null) {
            if (notRendered != null && !box.contains(offset = OffsetHelper.translationFor(axis, OffsetHelper.offsetConduit(i, allTypes.size())))) {
                conduitShape = Shapes.m_83148_((VoxelShape)conduitShape, (VoxelShape)CORE.m_83216_((double)((float)offset.m_123341_() * 3.0f / 16.0f), (double)((float)offset.m_123342_() * 3.0f / 16.0f), (double)((float)offset.m_123343_() * 3.0f / 16.0f)), (BooleanOp)BooleanOp.f_82695_);
            }
            conduitShape = Shapes.m_83148_((VoxelShape)conduitShape, (VoxelShape)CORE.m_83216_((double)((float)box.getMin().m_123341_() * 3.0f / 16.0f), (double)((float)box.getMin().m_123342_() * 3.0f / 16.0f), (double)((float)box.getMin().m_123343_() * 3.0f / 16.0f)), (BooleanOp)BooleanOp.f_82695_);
        } else if (notRendered != null) {
            offset = OffsetHelper.translationFor(axis, OffsetHelper.offsetConduit(i, allTypes.size()));
            conduitShape = Shapes.m_83148_((VoxelShape)conduitShape, (VoxelShape)CORE.m_83216_((double)((float)offset.m_123341_() * 3.0f / 16.0f), (double)((float)offset.m_123342_() * 3.0f / 16.0f), (double)((float)offset.m_123343_() * 3.0f / 16.0f)), (BooleanOp)BooleanOp.f_82695_);
        }
        this.conduitShapes.put(conduitType, conduitShape.m_83296_());
    }

    public static VoxelShape rotateVoxelShape(VoxelShape toRotate, Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{toRotate, Shapes.m_83040_()};
        if (direction.m_122416_() == -1) {
            if (direction == Direction.DOWN) {
                buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY));
                });
            } else {
                buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY));
                });
            }
            return buffer[1];
        }
        for (int i = 0; i < direction.m_122416_() % 4; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

