/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.conduit.ConduitApi;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.SlotType;
import com.enderio.api.conduit.ticker.ConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.api.misc.RedstoneControl;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class ConduitType<T extends ConduitData<T>> {
    public abstract ConduitTicker<T> getTicker();

    public abstract ConduitMenuData getMenuData();

    public abstract T createConduitData(Level var1, BlockPos var2);

    public Item getConduitItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(ConduitApi.INSTANCE.getConduitTypeRegistry().getKey((Object)this));
    }

    public boolean canBeInSameBlock(ConduitType<?> other) {
        return true;
    }

    public boolean canBeReplacedBy(ConduitType<?> other) {
        return false;
    }

    public boolean canApplyUpgrade(SlotType slotType, ConduitUpgrade conduitUpgrade) {
        return false;
    }

    public boolean canApplyFilter(SlotType slotType, ResourceFilter resourceFilter) {
        return false;
    }

    public <K> Optional<LazyOptional<K>> proxyCapability(Capability<K> cap, T extendedConduitData, Level level, BlockPos pos, @Nullable Direction direction, @Nullable ConduitNode.IOState state) {
        return Optional.empty();
    }

    public ConduitConnectionData getDefaultConnection(Level level, BlockPos pos, Direction direction) {
        return new ConduitConnectionData(false, true, RedstoneControl.NEVER_ACTIVE);
    }

    @Nullable
    public static ResourceLocation getKey(ConduitType<?> conduitType) {
        return ConduitApi.INSTANCE.getConduitTypeRegistry().getKey(conduitType);
    }

    public record ConduitConnectionData(boolean isInsert, boolean isExtract, RedstoneControl control) {
    }
}

