/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameType;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import top.seraphjack.simplelogin.command.arguments.ArgumentTypeEntryName;
import top.seraphjack.simplelogin.command.arguments.ArgumentTypeHandlerPlugin;
import top.seraphjack.simplelogin.server.SLRegistries;
import top.seraphjack.simplelogin.server.handler.PlayerLoginHandler;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public class SLCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
    }

    private static int save(CommandContext<CommandSourceStack> ctx) {
        try {
            long start = System.currentTimeMillis();
            SLStorage.instance().storageProvider.save();
            long cost = System.currentTimeMillis() - start;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Done. Took " + cost + " ms.")), true);
        }
        catch (IOException e) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Error during saving entries, see log for details"), false);
        }
        return 1;
    }

    private static int unregister(CommandContext<CommandSourceStack> ctx) {
        SLStorage.instance().storageProvider.unregister(ArgumentTypeEntryName.getEntryName(ctx, "entry"));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Successfully unregistered."), false);
        return 1;
    }

    private static int setDefaultGamemode(CommandContext<CommandSourceStack> ctx) {
        GameType gameType = GameType.m_46393_((int)((Integer)ctx.getArgument("mode", Integer.class)));
        SLStorage.instance().storageProvider.setGameType(ArgumentTypeEntryName.getEntryName(ctx, "entry"), gameType);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Successfully set entry default game type to " + gameType.m_46405_() + ".")), false);
        return 1;
    }

    private static int about(CommandContext<CommandSourceStack> ctx) {
        ModInfo info = FMLLoader.getLoadingModList().getMods().stream().filter(modInfo -> modInfo.getModId().equals("simplelogin")).findAny().get();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.about.info", (Object[])new Object[]{info.getVersion().toString()}), false);
        return 1;
    }

    private static int loadPlugin(CommandContext<CommandSourceStack> ctx) {
        ResourceLocation plugin = ArgumentTypeHandlerPlugin.getPlugin(ctx, "plugin");
        if (SLRegistries.PLUGINS.get(plugin).isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.not_found", (Object[])new Object[]{plugin.toString()}), true);
            return 1;
        }
        if (PlayerLoginHandler.instance().listPlugins().contains(plugin)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.already_loaded", (Object[])new Object[]{plugin.toString()}), true);
            return 1;
        }
        PlayerLoginHandler.instance().loadPlugin(plugin);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.load_success", (Object[])new Object[]{plugin.toString()}), true);
        return 1;
    }

    private static int unloadPlugin(CommandContext<CommandSourceStack> ctx) {
        ResourceLocation plugin = ArgumentTypeHandlerPlugin.getPlugin(ctx, "plugin");
        if (SLRegistries.PLUGINS.get(plugin).isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.not_found", (Object[])new Object[]{plugin.toString()}), true);
            return 1;
        }
        if (!PlayerLoginHandler.instance().listPlugins().contains(plugin)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.not_loaded", (Object[])new Object[]{plugin.toString()}), true);
            return 1;
        }
        PlayerLoginHandler.instance().unloadPlugin(plugin);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.unload_success", (Object[])new Object[]{plugin.toString()}), true);
        return 1;
    }

    private static int listAvailablePlugins(CommandContext<CommandSourceStack> ctx) {
        Set<ResourceLocation> plugins = SLRegistries.PLUGINS.list();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"simplelogin.command.plugin.available_plugin_header"), false);
        for (ResourceLocation plugin : plugins) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.list_member", (Object[])new Object[]{plugin.toString()}), false);
        }
        return 1;
    }

    private static int listLoadedPlugins(CommandContext<CommandSourceStack> ctx) {
        Collection<ResourceLocation> plugins = PlayerLoginHandler.instance().listPlugins();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"simplelogin.command.plugin.loaded_plugin_header"), false);
        for (ResourceLocation plugin : plugins) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.list_member", (Object[])new Object[]{plugin.toString()}), false);
        }
        return 1;
    }
}

