/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.handler.plugins;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import top.seraphjack.simplelogin.network.MessageRequestLogin;
import top.seraphjack.simplelogin.network.NetworkLoader;
import top.seraphjack.simplelogin.server.handler.HandlerPlugin;
import top.seraphjack.simplelogin.server.handler.Login;

public final class ResendRequest
implements HandlerPlugin {
    private ScheduledExecutorService executor;
    private final Map<String, ScheduledFuture<?>> futures = new ConcurrentHashMap();

    @Override
    public void enable(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public void preLogin(ServerPlayer player, Login login) {
        ScheduledFuture<?> future = this.executor.scheduleWithFixedDelay(() -> NetworkLoader.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageRequestLogin()), 0L, 5L, TimeUnit.SECONDS);
        Optional.ofNullable(this.futures.put(login.name, future)).ifPresent(f -> f.cancel(true));
    }

    @Override
    public void postLogin(ServerPlayer player, Login login) {
        Optional.ofNullable(this.futures.remove(login.name)).ifPresent(f -> f.cancel(true));
    }

    @Override
    public void preLogout(ServerPlayer player) {
        Optional.ofNullable(this.futures.remove(player.m_36316_().getName().toLowerCase())).ifPresent(f -> f.cancel(true));
    }

    @Override
    public void disable() {
        this.futures.values().forEach(f -> f.cancel(true));
    }
}

