/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.data;

import io.ejekta.bountiful.Bountiful;
import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.BountyRarity;
import io.ejekta.bountiful.bounty.types.BountyTypeRegistry;
import io.ejekta.bountiful.bounty.types.IBountyType;
import io.ejekta.bountiful.config.JsonFormats;
import io.ejekta.bountiful.data.PoolEntry$;
import io.ejekta.bountiful.data.PoolEntry$EntryRange$;
import io.ejekta.bountiful.data.PoolEntry$ForbiddenContent$;
import io.ejekta.bountiful.util.ExtMiscKt;
import io.ejekta.kambrik.ext.ExtRegIdKt;
import io.ejekta.kudzu.KudzuVine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.ContextualSerializer;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u0086\u00012\u00020\u0001:\b\u0087\u0001\u0086\u0001\u0088\u0001\u0089\u0001B\u00b7\u0001\b\u0017\u0012\u0007\u0010\u0081\u0001\u001a\u00020\u0004\u0012\r\u0010k\u001a\t\u0018\u00010B\u00a2\u0006\u0002\bC\u0012\b\u0010\\\u001a\u0004\u0018\u00010[\u0012\b\u00109\u001a\u0004\u0018\u00010\u001a\u0012\b\u0010Q\u001a\u0004\u0018\u00010\u001a\u0012\r\u0010D\u001a\t\u0018\u00010B\u00a2\u0006\u0002\bC\u0012\b\u0010.\u001a\u0004\u0018\u00010-\u0012\u0006\u0010t\u001a\u00020\u0002\u0012\u0006\u0010w\u001a\u00020\u0002\u0012\u0006\u0010h\u001a\u00020\u0002\u0012\u0006\u0010b\u001a\u00020\u0002\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010?\u0012\b\u00105\u001a\u0004\u0018\u000104\u0012\u0006\u0010K\u001a\u00020\n\u0012\r\u0010U\u001a\t\u0018\u00010T\u00a2\u0006\u0002\bC\u0012\n\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0082\u0001\u00a2\u0006\u0006\b\u0084\u0001\u0010\u0085\u0001B\n\b\u0002\u00a2\u0006\u0005\b\u0084\u0001\u0010JJ\u001b\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u000f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ)\u0010 \u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001d2\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0002\u00a2\u0006\u0004\b#\u0010$J(\u0010+\u001a\u00020*2\u0006\u0010%\u001a\u00020\u00002\u0006\u0010'\u001a\u00020&2\u0006\u0010)\u001a\u00020(H\u00c7\u0001\u00a2\u0006\u0004\b+\u0010,R\"\u0010.\u001a\u00020-8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0019\u00105\u001a\u0004\u0018\u0001048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\"\u00109\u001a\u00020\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020@0?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010AR\u001d\u0010D\u001a\t\u0018\u00010B\u00a2\u0006\u0002\bC8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER(\u0010F\u001a\u00020\u001a8\u0006@\u0006X\u0087.\u00a2\u0006\u0018\n\u0004\bF\u0010:\u0012\u0004\bI\u0010J\u001a\u0004\bG\u0010<\"\u0004\bH\u0010>R\"\u0010K\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR$\u0010Q\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010:\u001a\u0004\bR\u0010<\"\u0004\bS\u0010>R)\u0010U\u001a\t\u0018\u00010T\u00a2\u0006\u0002\bC8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010V\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\"\u0010\\\u001a\u00020[8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR\"\u0010b\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bb\u0010c\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR\"\u0010h\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bh\u0010c\u001a\u0004\bi\u0010e\"\u0004\bj\u0010gR'\u0010k\u001a\u00070B\u00a2\u0006\u0002\bC8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bk\u0010E\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u0013\u0010s\u001a\u0004\u0018\u00010p8F\u00a2\u0006\u0006\u001a\u0004\bq\u0010rR\"\u0010t\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bt\u0010c\u001a\u0004\bu\u0010e\"\u0004\bv\u0010gR\"\u0010w\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bw\u0010c\u001a\u0004\bx\u0010e\"\u0004\by\u0010gR \u0010}\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020z8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b{\u0010|R\u0018\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b~\u0010\u007f\u00a8\u0006\u008a\u0001"}, d2={"Lio/ejekta/bountiful/data/PoolEntry;", "", "", "worth", "", "amountAt", "(Ljava/lang/Double;)I", "Lnet/minecraft/server/level/ServerLevel;", "world", "entry", "", "forbids", "(Lnet/minecraft/server/level/ServerLevel;Lio/ejekta/bountiful/data/PoolEntry;)Z", "", "entries", "forbidsAny", "(Lnet/minecraft/server/level/ServerLevel;Ljava/util/List;)Z", "Lnet/minecraft/world/item/Item;", "getRelatedItems", "(Lnet/minecraft/server/level/ServerLevel;)Ljava/util/List;", "Lnet/minecraft/server/MinecraftServer;", "server", "isValid", "(Lnet/minecraft/server/MinecraftServer;)Z", "Lkotlinx/serialization/json/Json;", "format", "", "save", "(Lkotlinx/serialization/json/Json;)Ljava/lang/String;", "Lnet/minecraft/core/BlockPos;", "pos", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "toEntry", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/lang/Double;)Lio/ejekta/bountiful/bounty/BountyDataEntry;", "value", "worthDistanceFrom", "(D)I", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self", "(Lio/ejekta/bountiful/data/PoolEntry;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "Lio/ejekta/bountiful/data/PoolEntry$EntryRange;", "amount", "Lio/ejekta/bountiful/data/PoolEntry$EntryRange;", "getAmount", "()Lio/ejekta/bountiful/data/PoolEntry$EntryRange;", "setAmount", "(Lio/ejekta/bountiful/data/PoolEntry$EntryRange;)V", "Lkotlinx/serialization/json/JsonObject;", "conditions", "Lkotlinx/serialization/json/JsonObject;", "getConditions", "()Lkotlinx/serialization/json/JsonObject;", "content", "Ljava/lang/String;", "getContent", "()Ljava/lang/String;", "setContent", "(Ljava/lang/String;)V", "", "Lio/ejekta/bountiful/data/PoolEntry$ForbiddenContent;", "Ljava/util/List;", "Lnet/minecraft/resources/ResourceLocation;", "Lkotlinx/serialization/Contextual;", "icon", "Lnet/minecraft/resources/ResourceLocation;", "id", "getId", "setId", "getId$annotations", "()V", "mystery", "Z", "getMystery", "()Z", "setMystery", "(Z)V", "name", "getName", "setName", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "getNbt", "()Lnet/minecraft/nbt/CompoundTag;", "setNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "Lio/ejekta/bountiful/bounty/BountyRarity;", "rarity", "Lio/ejekta/bountiful/bounty/BountyRarity;", "getRarity", "()Lio/ejekta/bountiful/bounty/BountyRarity;", "setRarity", "(Lio/ejekta/bountiful/bounty/BountyRarity;)V", "repRequired", "D", "getRepRequired", "()D", "setRepRequired", "(D)V", "timeMult", "getTimeMult", "setTimeMult", "type", "getType", "()Lnet/minecraft/resources/ResourceLocation;", "setType", "(Lnet/minecraft/resources/ResourceLocation;)V", "Lio/ejekta/bountiful/bounty/types/IBountyType;", "getTypeLogic", "()Lio/ejekta/bountiful/bounty/types/IBountyType;", "typeLogic", "unitWorth", "getUnitWorth", "setUnitWorth", "weightMult", "getWeightMult", "setWeightMult", "Lkotlin/Pair;", "getWorthRange", "()Lkotlin/Pair;", "worthRange", "getWorthSteps", "()Ljava/util/List;", "worthSteps", "seen1", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "<init>", "(ILnet/minecraft/resources/ResourceLocation;Lio/ejekta/bountiful/bounty/BountyRarity;Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/resources/ResourceLocation;Lio/ejekta/bountiful/data/PoolEntry$EntryRange;DDDDLjava/util/List;Lkotlinx/serialization/json/JsonObject;ZLnet/minecraft/nbt/CompoundTag;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "Companion", ".serializer", "EntryRange", "ForbiddenContent", "Bountiful"})
@SourceDebugExtension(value={"SMAP\nPoolEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoolEntry.kt\nio/ejekta/bountiful/data/PoolEntry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1549#2:182\n1620#2,3:183\n1747#2,3:186\n1747#2,3:189\n1747#2,3:192\n*S KotlinDebug\n*F\n+ 1 PoolEntry.kt\nio/ejekta/bountiful/data/PoolEntry\n*L\n70#1:182\n70#1:183,3\n145#1:186,3\n148#1:189,3\n153#1:192,3\n*E\n"})
public final class PoolEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ResourceLocation type;
    @NotNull
    private BountyRarity rarity;
    @NotNull
    private String content;
    @Nullable
    private String name;
    @Nullable
    private ResourceLocation icon;
    @NotNull
    private EntryRange amount;
    private double unitWorth;
    private double weightMult;
    private double timeMult;
    private double repRequired;
    @NotNull
    private final List<ForbiddenContent> forbids;
    public String id;
    @Nullable
    private final JsonObject conditions;
    private boolean mystery;
    @Nullable
    private CompoundTag nbt;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    private PoolEntry() {
        this.type = new ResourceLocation("bountiful", "null_pool");
        this.rarity = BountyRarity.COMMON;
        this.content = "Nope";
        this.amount = new EntryRange(-1, -1);
        this.unitWorth = -1000.0;
        this.weightMult = 1.0;
        this.timeMult = 1.0;
        this.forbids = new ArrayList();
    }

    @NotNull
    public final ResourceLocation getType() {
        return this.type;
    }

    public final void setType(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.type = resourceLocation;
    }

    @NotNull
    public final BountyRarity getRarity() {
        return this.rarity;
    }

    public final void setRarity(@NotNull BountyRarity bountyRarity) {
        Intrinsics.checkNotNullParameter((Object)((Object)bountyRarity), (String)"<set-?>");
        this.rarity = bountyRarity;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    public final void setContent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.content = string;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @NotNull
    public final EntryRange getAmount() {
        return this.amount;
    }

    public final void setAmount(@NotNull EntryRange entryRange) {
        Intrinsics.checkNotNullParameter((Object)entryRange, (String)"<set-?>");
        this.amount = entryRange;
    }

    public final double getUnitWorth() {
        return this.unitWorth;
    }

    public final void setUnitWorth(double d) {
        this.unitWorth = d;
    }

    public final double getWeightMult() {
        return this.weightMult;
    }

    public final void setWeightMult(double d) {
        this.weightMult = d;
    }

    public final double getTimeMult() {
        return this.timeMult;
    }

    public final void setTimeMult(double d) {
        this.timeMult = d;
    }

    public final double getRepRequired() {
        return this.repRequired;
    }

    public final void setRepRequired(double d) {
        this.repRequired = d;
    }

    public final boolean isValid(@NotNull MinecraftServer server) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        try {
            IBountyType bountyType = (IBountyType)BountyTypeRegistry.INSTANCE.m_7745_(this.type);
            if (bountyType == null) {
                Bountiful.Companion.getLOGGER().warn("Bounty Pool Entry has Invalid Type: (" + this.getId() + " - " + this.content + ") details: " + PoolEntry.save$default(this, null, 1, null));
                return false;
            }
            bl = bountyType.isValid(this, server);
        }
        catch (Exception e) {
            Bountiful.Companion.getLOGGER().warn("Bounty Pool Entry Invalid: (" + this.getId() + " - " + this.content + ") details: " + PoolEntry.save$default(this, null, 1, null));
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String getId() {
        String string = this.id;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"id");
        return null;
    }

    public final void setId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.id = string;
    }

    @Transient
    public static /* synthetic */ void getId$annotations() {
    }

    @Nullable
    public final IBountyType getTypeLogic() {
        return (IBountyType)BountyTypeRegistry.INSTANCE.m_7745_(this.type);
    }

    @Nullable
    public final JsonObject getConditions() {
        return this.conditions;
    }

    public final boolean getMystery() {
        return this.mystery;
    }

    public final void setMystery(boolean bl) {
        this.mystery = bl;
    }

    @Nullable
    public final CompoundTag getNbt() {
        return this.nbt;
    }

    public final void setNbt(@Nullable CompoundTag compoundTag) {
        this.nbt = compoundTag;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> getWorthSteps() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)new IntRange(this.amount.getMin(), this.amount.getMax());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)it * this.unitWorth);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String save(@NotNull Json format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return format.encodeToString((SerializationStrategy)Companion.serializer(), (Object)this);
    }

    public static /* synthetic */ String save$default(PoolEntry poolEntry, Json json, int n, Object object) {
        if ((n & 1) != 0) {
            json = JsonFormats.INSTANCE.getDataPack();
        }
        return poolEntry.save(json);
    }

    private final List<Item> getRelatedItems(ServerLevel world) {
        List<Item> list;
        ResourceLocation resourceLocation = this.type;
        if (Intrinsics.areEqual((Object)resourceLocation, (Object)BountyTypeRegistry.INSTANCE.getITEM().getId())) {
            ResourceLocation tagId = new ResourceLocation(StringsKt.substringAfter$default((String)this.content, (String)"#", null, (int)2, null));
            RegistryAccess registryAccess = world.m_9598_();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"world.registryManager");
            list = ExtMiscKt.getTagItems(registryAccess, ExtMiscKt.getTagItemKey(tagId));
        } else if (Intrinsics.areEqual((Object)resourceLocation, (Object)BountyTypeRegistry.INSTANCE.getITEM_TAG().getId())) {
            ResourceLocation tagId = new ResourceLocation(this.content);
            RegistryAccess registryAccess = world.m_9598_();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"world.registryManager");
            list = ExtMiscKt.getTagItems(registryAccess, ExtMiscKt.getTagItemKey(tagId));
        } else {
            list = null;
        }
        return list;
    }

    @NotNull
    public final BountyDataEntry toEntry(@NotNull ServerLevel world, @NotNull BlockPos pos, @Nullable Double worth) {
        String string;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int amt = this.amountAt(worth);
        if (Intrinsics.areEqual((Object)this.type, (Object)BountyTypeRegistry.INSTANCE.getITEM().getId()) && StringsKt.startsWith$default((String)this.content, (String)"#", (boolean)false, (int)2, null)) {
            ResourceLocation tagId = new ResourceLocation(StringsKt.substringAfter$default((String)this.content, (String)"#", null, (int)2, null));
            RegistryAccess registryAccess = world.m_9598_();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"world.registryManager");
            List<Item> tags = ExtMiscKt.getTagItems(registryAccess, ExtMiscKt.getTagItemKey(tagId));
            if (tags.isEmpty()) {
                Bountiful.Companion.getLOGGER().warn("A pool entry tag has an empty list! " + this.content);
                string = "minecraft:air";
            } else {
                String chosen;
                String string2 = ExtRegIdKt.getIdentifier((Item)((Item)CollectionsKt.random((Collection)tags, (Random)((Random)Random.Default)))).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tags.random().identifier.toString()");
                string = chosen = string2;
            }
        } else {
            string = this.content;
        }
        String actualContent = string;
        return BountyDataEntry.Companion.of$default(BountyDataEntry.Companion, this.getId(), world, pos, this.type, actualContent, this.amountAt(worth), (double)amt * this.unitWorth, this.nbt, this.name, this.icon, false, this.rarity, null, this.conditions, 4096, null);
    }

    public static /* synthetic */ BountyDataEntry toEntry$default(PoolEntry poolEntry, ServerLevel serverLevel, BlockPos blockPos, Double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = null;
        }
        return poolEntry.toEntry(serverLevel, blockPos, d);
    }

    private final int amountAt(Double worth) {
        int toGive = RangesKt.coerceIn((int)(worth != null ? Math.max(1, (int)Math.ceil(worth / this.unitWorth)) : this.amount.pick()), (ClosedRange)((ClosedRange)new IntRange(this.amount.getMin(), this.amount.getMax())));
        return toGive;
    }

    static /* synthetic */ int amountAt$default(PoolEntry poolEntry, Double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = null;
        }
        return poolEntry.amountAt(d);
    }

    private final Pair<Double, Double> getWorthRange() {
        return TuplesKt.to((Object)((double)this.amount.getMin() * this.unitWorth), (Object)((double)this.amount.getMax() * this.unitWorth));
    }

    public final int worthDistanceFrom(double value) {
        Pair<Double, Double> rnge = this.getWorthRange();
        return value >= ((Number)rnge.getFirst()).doubleValue() && value <= ((Number)rnge.getSecond()).doubleValue() ? 0 : (int)Math.min(Math.abs(((Number)rnge.getFirst()).doubleValue() - value), Math.abs(((Number)rnge.getSecond()).doubleValue() - value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean forbids(@NotNull ServerLevel world, @NotNull PoolEntry entry) {
        ForbiddenContent it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        List<Item> related = this.getRelatedItems(world);
        Iterable $this$any$iv = this.forbids;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (ForbiddenContent)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getType(), (Object)entry.type) && Intrinsics.areEqual((Object)it.getContent(), (Object)entry.content)) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = related;
        if ($this$any$iv == null) return false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        boolean bl4 = false;
        if (bl4) return false;
        $this$any$iv = related;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (Item)element$iv;
            boolean bl5 = false;
        } while (!Intrinsics.areEqual((Object)ExtRegIdKt.getIdentifier((Item)it).toString(), (Object)entry.content));
        return true;
    }

    public final boolean forbidsAny(@NotNull ServerLevel world, @NotNull List<PoolEntry> entries) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            Iterable $this$any$iv = entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PoolEntry it = (PoolEntry)element$iv;
                    boolean bl2 = false;
                    if (!this.forbids(world, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(PoolEntry self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.type, (Object)new ResourceLocation("bountiful", "null_pool"))) {
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], (Object)self.type);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.rarity != BountyRarity.COMMON) {
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], (Object)self.rarity);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual((Object)self.content, (Object)"Nope")) {
            output.encodeStringElement(serialDesc, 2, self.content);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.name != null) {
            output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.name);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.icon != null) {
            output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)kSerializerArray[4], (Object)self.icon);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : !Intrinsics.areEqual((Object)self.amount, (Object)new EntryRange(-1, -1))) {
            output.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)EntryRange$$serializer.INSTANCE, (Object)self.amount);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : Double.compare(self.unitWorth, -1000.0) != 0) {
            output.encodeDoubleElement(serialDesc, 6, self.unitWorth);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : Double.compare(self.weightMult, 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 7, self.weightMult);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : Double.compare(self.timeMult, 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 8, self.timeMult);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : Double.compare(self.repRequired, 0.0) != 0) {
            output.encodeDoubleElement(serialDesc, 9, self.repRequired);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 10) ? true : !Intrinsics.areEqual(self.forbids, (Object)new ArrayList())) {
            output.encodeSerializableElement(serialDesc, 10, (SerializationStrategy)kSerializerArray[10], self.forbids);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 11) ? true : self.conditions != null) {
            output.encodeNullableSerializableElement(serialDesc, 11, (SerializationStrategy)JsonObjectSerializer.INSTANCE, (Object)self.conditions);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 12) ? true : self.mystery) {
            output.encodeBooleanElement(serialDesc, 12, self.mystery);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 13) ? true : self.nbt != null) {
            output.encodeNullableSerializableElement(serialDesc, 13, (SerializationStrategy)kSerializerArray[13], (Object)self.nbt);
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ PoolEntry(int seen1, ResourceLocation type, BountyRarity rarity, String content, String name, ResourceLocation icon, EntryRange amount, double unitWorth, double weightMult, double timeMult, double repRequired, List forbids, JsonObject conditions, boolean mystery, CompoundTag nbt, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen1) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.type = (seen1 & 1) == 0 ? new ResourceLocation("bountiful", "null_pool") : type;
        this.rarity = (seen1 & 2) == 0 ? BountyRarity.COMMON : rarity;
        this.content = (seen1 & 4) == 0 ? "Nope" : content;
        this.name = (seen1 & 8) == 0 ? null : name;
        this.icon = (seen1 & 0x10) == 0 ? null : icon;
        this.amount = (seen1 & 0x20) == 0 ? new EntryRange(-1, -1) : amount;
        this.unitWorth = (seen1 & 0x40) == 0 ? -1000.0 : unitWorth;
        this.weightMult = (seen1 & 0x80) == 0 ? 1.0 : weightMult;
        this.timeMult = (seen1 & 0x100) == 0 ? 1.0 : timeMult;
        this.repRequired = (seen1 & 0x200) == 0 ? 0.0 : repRequired;
        this.forbids = (seen1 & 0x400) == 0 ? (List)new ArrayList() : forbids;
        this.conditions = (seen1 & 0x800) == 0 ? null : conditions;
        this.mystery = (seen1 & 0x1000) == 0 ? false : mystery;
        this.nbt = (seen1 & 0x2000) == 0 ? null : nbt;
    }

    public /* synthetic */ PoolEntry(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{new ContextualSerializer(Reflection.getOrCreateKotlinClass(ResourceLocation.class), null, new KSerializer[0]), EnumsKt.createSimpleEnumSerializer((String)"io.ejekta.bountiful.bounty.BountyRarity", (Enum[])BountyRarity.values()), null, null, new ContextualSerializer(Reflection.getOrCreateKotlinClass(ResourceLocation.class), null, new KSerializer[0]), null, null, null, null, null, new ArrayListSerializer((KSerializer)ForbiddenContent$$serializer.INSTANCE), null, null, new ContextualSerializer(Reflection.getOrCreateKotlinClass(CompoundTag.class), null, new KSerializer[0])};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/ejekta/bountiful/data/PoolEntry$Companion;", "", "Lio/ejekta/bountiful/data/PoolEntry;", "create", "()Lio/ejekta/bountiful/data/PoolEntry;", "Lio/ejekta/kudzu/KudzuVine;", "kv", "fromKudzu", "(Lio/ejekta/kudzu/KudzuVine;)Lio/ejekta/bountiful/data/PoolEntry;", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "<init>", "()V", "Bountiful"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PoolEntry fromKudzu(@NotNull KudzuVine kv) {
            Intrinsics.checkNotNullParameter((Object)kv, (String)"kv");
            return (PoolEntry)JsonFormats.INSTANCE.getHand().decodeFromString((DeserializationStrategy)Companion.serializer(), kv.toString());
        }

        @NotNull
        public final PoolEntry create() {
            PoolEntry poolEntry;
            PoolEntry $this$create_u24lambda_u240 = poolEntry = new PoolEntry(null);
            boolean bl = false;
            $this$create_u24lambda_u240.setType(BountyTypeRegistry.INSTANCE.getITEM().getId());
            $this$create_u24lambda_u240.setAmount(new EntryRange(1, 1));
            $this$create_u24lambda_u240.setContent("NO_CONTENT");
            $this$create_u24lambda_u240.setUnitWorth(100.0);
            return poolEntry;
        }

        @NotNull
        public final KSerializer<PoolEntry> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001c\u001bB+\b\u0017\u0012\u0006\u0010\u0015\u001a\u00020\u0002\u0012\u0006\u0010\u0013\u001a\u00020\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019B\u0017\u0012\u0006\u0010\u0013\u001a\u00020\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u001aJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u00c7\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0004R\u0017\u0010\u0013\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0011\u001a\u0004\b\u0014\u0010\u0004\u00a8\u0006\u001d"}, d2={"Lio/ejekta/bountiful/data/PoolEntry$EntryRange;", "", "", "pick", "()I", "", "toString", "()Ljava/lang/String;", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self", "(Lio/ejekta/bountiful/data/PoolEntry$EntryRange;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "max", "I", "getMax", "min", "getMin", "seen1", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "<init>", "(IIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(II)V", "Companion", ".serializer", "Bountiful"})
    public static final class EntryRange {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int min;
        private final int max;

        public EntryRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        public final int pick() {
            return RangesKt.random((IntRange)new IntRange(this.min, this.max), (Random)((Random)Random.Default));
        }

        @NotNull
        public String toString() {
            return "[" + this.min + " - " + this.max + "]";
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self(EntryRange self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeIntElement(serialDesc, 0, self.min);
            output.encodeIntElement(serialDesc, 1, self.max);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ EntryRange(int seen1, int min, int max, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)EntryRange$$serializer.INSTANCE.getDescriptor());
            }
            this.min = min;
            this.max = max;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lio/ejekta/bountiful/data/PoolEntry$EntryRange$Companion;", "", "Lkotlinx/serialization/KSerializer;", "Lio/ejekta/bountiful/data/PoolEntry$EntryRange;", "serializer", "()Lkotlinx/serialization/KSerializer;", "<init>", "()V", "Bountiful"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<EntryRange> serializer() {
                return (KSerializer)EntryRange$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001d\u001cB4\b\u0017\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\r\u0010\u0011\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aB\u001c\u0012\u000b\u0010\u0011\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\u001bJ(\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u00c7\u0001\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lio/ejekta/bountiful/data/PoolEntry$ForbiddenContent;", "", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self", "(Lio/ejekta/bountiful/data/PoolEntry$ForbiddenContent;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "", "content", "Ljava/lang/String;", "getContent", "()Ljava/lang/String;", "Lnet/minecraft/resources/ResourceLocation;", "Lkotlinx/serialization/Contextual;", "type", "Lnet/minecraft/resources/ResourceLocation;", "getType", "()Lnet/minecraft/resources/ResourceLocation;", "", "seen1", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "<init>", "(ILnet/minecraft/resources/ResourceLocation;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/String;)V", "Companion", ".serializer", "Bountiful"})
    public static final class ForbiddenContent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceLocation type;
        @NotNull
        private final String content;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public ForbiddenContent(@NotNull ResourceLocation type, @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.type = type;
            this.content = content;
        }

        @NotNull
        public final ResourceLocation getType() {
            return this.type;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self(ForbiddenContent self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], (Object)self.type);
            output.encodeStringElement(serialDesc, 1, self.content);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ ForbiddenContent(int seen1, ResourceLocation type, String content, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)ForbiddenContent$$serializer.INSTANCE.getDescriptor());
            }
            this.type = type;
            this.content = content;
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{new ContextualSerializer(Reflection.getOrCreateKotlinClass(ResourceLocation.class), null, new KSerializer[0]), null};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lio/ejekta/bountiful/data/PoolEntry$ForbiddenContent$Companion;", "", "Lkotlinx/serialization/KSerializer;", "Lio/ejekta/bountiful/data/PoolEntry$ForbiddenContent;", "serializer", "()Lkotlinx/serialization/KSerializer;", "<init>", "()V", "Bountiful"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ForbiddenContent> serializer() {
                return (KSerializer)ForbiddenContent$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

