/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.entities.thrown;

import com.vies.viescraftmachines.common.entities.machines.types.EntityMachineTypeFlying;
import com.vies.viescraftmachines.common.items.ItemConstructionKit;
import com.vies.viescraftmachines.common.items.tools.ItemToolMachineWrench;
import com.vies.viescraftmachines.util.enums.TriggerEvents;
import com.vies.viescraftmachines.util.init.common.InitEntitiesVCM;
import com.vies.viescraftmachines.util.init.common.InitItemsVCM;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityChassisBase
extends Entity {
    private static final EntityDataAccessor<Boolean> DATA_ID_KITPANEL = SynchedEntityData.m_135353_(EntityChassisBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_KITMETAL = SynchedEntityData.m_135353_(EntityChassisBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_KITCLOTH = SynchedEntityData.m_135353_(EntityChassisBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private double waterLevel;
    private double lavaLevel;
    private float landFriction;
    protected Status status;
    protected Status oldStatus;
    private double lastYd;

    public EntityChassisBase(EntityType<? extends EntityChassisBase> entitytypeIn, Level levelIn) {
        super(entitytypeIn, levelIn);
        this.f_19850_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_KITPANEL, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_KITMETAL, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_KITCLOTH, (Object)false);
    }

    protected void m_7380_(CompoundTag tagIn) {
        tagIn.m_128379_("tag-chassis-kitpanel_vcm", this.getStatusKitPanel());
        tagIn.m_128379_("tag-chassis-kitmetal_vcm", this.getStatusKitMetal());
        tagIn.m_128379_("tag-chassis-kitcloth_vcm", this.getStatusKitCloth());
    }

    protected void m_7378_(CompoundTag tagIn) {
        this.setStatusKitPanel(tagIn.m_128471_("tag-chassis-kitpanel_vcm"));
        this.setStatusKitMetal(tagIn.m_128471_("tag-chassis-kitmetal_vcm"));
        this.setStatusKitCloth(tagIn.m_128471_("tag-chassis-kitcloth_vcm"));
    }

    public void m_8119_() {
        this.f_19853_.m_46473_().m_6180_("entityBaseTick");
        this.oldStatus = this.status;
        this.status = this.getStatus();
        if (this.status == Status.IN_AIR) {
            this.m_20242_(false);
        } else {
            this.m_20242_(true);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_20157_();
        if (this.m_5843_()) {
            this.m_20076_();
        }
        if (this.f_19853_.f_46443_) {
            this.m_20095_();
        }
        if (this.m_20077_()) {
            this.m_20093_();
            this.f_19789_ *= 0.5f;
        }
        this.m_146871_();
        this.f_19803_ = false;
        this.f_19853_.m_46473_().m_7238_();
        this.m_20101_();
        Vec3 vec31 = this.m_20184_();
        double d1 = 0.0;
        double d2 = -0.05;
        d1 += this.runUnderwaterFloatingMovementCalculation();
        if (this.status == Status.IN_AIR) {
            this.m_20334_(vec31.f_82479_, vec31.f_82480_ + d2, vec31.f_82481_);
        } else if (this.status == Status.IN_WATER) {
            this.m_20334_(0.0, 0.0, 0.0);
        } else {
            this.m_20334_(0.0, vec31.f_82480_ + d1, 0.0);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_7337_(Entity entityIn) {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public InteractionResult m_6096_(Player playerIn, InteractionHand interactionhandIn) {
        if (playerIn.m_36341_()) {
            if (this.getStatusKitPanel() && this.getStatusKitMetal() && this.getStatusKitCloth() && !playerIn.m_21205_().m_41619_() && playerIn.m_21205_().m_41720_() instanceof ItemToolMachineWrench) {
                this.spawnSmokeParticle();
                if (!playerIn.f_19853_.f_46443_) {
                    EntityMachineTypeFlying machinecomplete = new EntityMachineTypeFlying((EntityType<? extends EntityMachineTypeFlying>)((EntityType)InitEntitiesVCM.MACHINE_FLYING.get()), playerIn.f_19853_);
                    machinecomplete.m_146884_(this.m_20182_());
                    machinecomplete.m_146926_(this.m_146909_());
                    machinecomplete.m_146922_(this.m_146908_());
                    machinecomplete.setStatusDurabilityActive(machinecomplete.getStatusDurabilityTotal());
                    machinecomplete.setStatusBroken(false);
                    machinecomplete.setStatusPowered(false);
                    machinecomplete.setStatusOwner(playerIn.m_20149_());
                    machinecomplete.setStatusOwnerDisplayName(playerIn.f_19853_.m_46003_(UUID.fromString(playerIn.m_20149_())).m_5446_().getString());
                    machinecomplete.setStatusTriggerEvent(TriggerEvents.FIRST_SPAWNED.ordinal());
                    playerIn.f_19853_.m_7967_((Entity)machinecomplete);
                }
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_213846_((Component)Component.m_237115_((String)("item.viescraftmachines.message." + playerIn.m_21205_().m_41720_() + ".1")));
                }
                playerIn.m_21205_().m_41622_(10, (LivingEntity)playerIn, player -> player.m_21190_(player.m_7655_()));
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return InteractionResult.CONSUME;
            }
            if (!playerIn.m_21205_().m_41619_()) {
                if (playerIn.m_21205_().m_41720_() instanceof ItemConstructionKit) {
                    ItemConstructionKit constructionKit = (ItemConstructionKit)playerIn.m_21205_().m_41720_();
                    ItemConstructionKit.Type constructionKitType = constructionKit.getKitType();
                    if (constructionKitType == ItemConstructionKit.Type.PANEL && !this.getStatusKitPanel()) {
                        this.setStatusKitPanel(true);
                        if (playerIn.f_19853_.m_5776_()) {
                            playerIn.m_213846_((Component)Component.m_237115_((String)("item.viescraftmachines.message." + playerIn.m_21205_().m_41720_() + ".1")));
                        }
                        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12524_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                        playerIn.m_21205_().m_41774_(1);
                        if (playerIn.m_21205_().m_41619_()) {
                            playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                        }
                        return InteractionResult.CONSUME;
                    }
                    if (constructionKitType == ItemConstructionKit.Type.METAL && !this.getStatusKitMetal()) {
                        this.setStatusKitMetal(true);
                        if (playerIn.f_19853_.m_5776_()) {
                            playerIn.m_213846_((Component)Component.m_237115_((String)("item.viescraftmachines.message." + playerIn.m_21205_().m_41720_() + ".1")));
                        }
                        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12524_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                        playerIn.m_21205_().m_41774_(1);
                        if (playerIn.m_21205_().m_41619_()) {
                            playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                        }
                        return InteractionResult.CONSUME;
                    }
                    if (constructionKitType == ItemConstructionKit.Type.CLOTH && !this.getStatusKitCloth()) {
                        this.setStatusKitCloth(true);
                        if (playerIn.f_19853_.m_5776_()) {
                            playerIn.m_213846_((Component)Component.m_237115_((String)("item.viescraftmachines.message." + playerIn.m_21205_().m_41720_() + ".1")));
                        }
                        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12524_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                        playerIn.m_21205_().m_41774_(1);
                        if (playerIn.m_21205_().m_41619_()) {
                            playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                        }
                        return InteractionResult.CONSUME;
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
            ItemStack droppedmachine = this.m_142340_();
            CompoundTag nbtData = new CompoundTag();
            nbtData.m_128379_("tag-chassis-kitpanel_vcm", this.getStatusKitPanel());
            nbtData.m_128379_("tag-chassis-kitmetal_vcm", this.getStatusKitMetal());
            nbtData.m_128379_("tag-chassis-kitcloth_vcm", this.getStatusKitCloth());
            droppedmachine.m_41751_(nbtData);
            if (playerIn.f_19853_.m_5776_()) {
                playerIn.m_213846_((Component)Component.m_237115_((String)"item.viescraftmachines.message.chassisconverttoitem"));
            }
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11664_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            if (!playerIn.f_19853_.f_46443_) {
                this.m_19983_(droppedmachine);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7840_(double yDistanceIn, boolean onGroundIn, BlockState p_38309_, BlockPos p_38310_) {
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public Item getDropItem() {
        return (Item)InitItemsVCM.MACHINE_CHASSIS_BASIC.get();
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public Status getStatus() {
        Status machine$status = this.isUnderwater();
        if (machine$status != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return machine$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        if (this.checkInLava()) {
            return Status.IN_LAVA;
        }
        if (this.isUnderLava()) {
            return Status.UNDER_LAVA;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)(aabb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (fluidstate.m_205070_(FluidTags.f_13131_) || fluidstate.m_205070_(FluidTags.f_13132_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutableblockpos.m_123342_() + f;
        }
        return l + 1;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.f_19853_, (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status isUnderwater() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private boolean checkInLava() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.lavaLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13132_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos);
                    this.lavaLevel = Math.max((double)f, this.lavaLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status isUnderlava() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13132_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_LAVA;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_LAVA : null;
    }

    public boolean m_5842_() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    public boolean isUnderLava() {
        return this.status == Status.UNDER_LAVA || this.status == Status.UNDER_FLOWING_LAVA;
    }

    protected void spawnSmokeParticle() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 80; ++i) {
                if (i != i % 2) continue;
                Vec3 vec3 = this.m_20184_();
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + this.f_19796_.m_188500_(), this.m_20186_() + this.f_19796_.m_188500_() + 0.5, this.m_20189_() + this.f_19796_.m_188500_(), vec3.f_82479_ * -4.0, 1.5, vec3.f_82481_ * -4.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + this.f_19796_.m_188500_(), this.m_20186_() + this.f_19796_.m_188500_() + 0.5, this.m_20189_() + this.f_19796_.m_188500_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_188583_() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)pInaccuracy).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        float f = -Mth.m_14031_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, pVelocity, pInaccuracy);
        Vec3 vec3 = pShooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, pShooter.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    protected double runUnderwaterFloatingMovementCalculation() {
        double f1 = 0.0;
        f1 = this.status == Status.UNDER_FLOWING_WATER || this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_LAVA || this.status == Status.UNDER_LAVA ? (f1 += 0.05) : 0.0;
        return f1;
    }

    public void setStatusKitPanel(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_KITPANEL, (Object)valueIn);
    }

    public boolean getStatusKitPanel() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_KITPANEL);
    }

    public void setStatusKitMetal(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_KITMETAL, (Object)valueIn);
    }

    public boolean getStatusKitMetal() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_KITMETAL);
    }

    public void setStatusKitCloth(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_KITCLOTH, (Object)valueIn);
    }

    public boolean getStatusKitCloth() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_KITCLOTH);
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        IN_LAVA,
        UNDER_LAVA,
        UNDER_FLOWING_LAVA,
        ON_LAND,
        IN_AIR;

    }
}

