/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.entities.machines.types;

import com.vies.viescraftmachines.VCMCommonConfig;
import com.vies.viescraftmachines.common.entities.machines.EntityMachineDurabilityAndEnergy;
import com.vies.viescraftmachines.common.entities.machines.EntityMountable;
import com.vies.viescraftmachines.common.entities.machines.types.EntityMachineTypeBasic;
import com.vies.viescraftmachines.util.enums.MachineType;
import com.vies.viescraftmachines.util.enums.MachineUpgrade;
import com.vies.viescraftmachines.util.init.common.InitEntitiesVCM;
import com.vies.viescraftmachines.util.init.common.InitItemsVCM;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class EntityMachineTypeGround
extends EntityMachineDurabilityAndEnergy {
    protected int tickingVariableWaterDamage = 0;
    protected boolean machineJumping;
    protected float jumpPower;
    protected int jumpTime = 0;
    protected boolean floatingupwards;
    private boolean autorunmovement = false;

    public EntityMachineTypeGround(EntityType<? extends EntityMachineTypeGround> entitytypeIn, Level levelIn) {
        super((EntityType<? extends EntityMachineDurabilityAndEnergy>)entitytypeIn, levelIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    protected void m_7380_(CompoundTag tagIn) {
        super.m_7380_(tagIn);
    }

    @Override
    protected void m_7378_(CompoundTag tagIn) {
        super.m_7378_(tagIn);
    }

    @Override
    public void m_8119_() {
        if (this.PoweredAndHasFuel()) {
            this.m_20242_(true);
        } else {
            this.m_20242_(false);
        }
        if (!this.f_19853_.f_46443_) {
            EntityMachineTypeBasic machinechassis = new EntityMachineTypeBasic((EntityType<? extends EntityMachineTypeBasic>)((EntityType)InitEntitiesVCM.MACHINE_BASIC.get()), this.f_19853_);
            machinechassis.m_146884_(this.m_20182_());
            machinechassis.m_146926_(this.m_146909_());
            machinechassis.m_146922_(this.m_146908_());
            machinechassis.setStatusBroken(this.getStatusBroken());
            machinechassis.setStatusDurabilityActive(this.getStatusDurabilityActive());
            machinechassis.setStatusEnergyActive(this.getStatusEnergyActive());
            machinechassis.setStatusLocked(this.getStatusLocked());
            machinechassis.setStatusOwner(this.getStatusOwner());
            machinechassis.setStatusOwnerDisplayName(this.getStatusOwnerDisplayName());
            machinechassis.setStatusTexturePanel(this.getStatusTexturePanel());
            machinechassis.setStatusTextureMetal(this.getStatusTextureMetal());
            machinechassis.setStatusTextureCloth(this.getStatusTextureCloth());
            machinechassis.setStatusTextureFrame(this.getStatusTextureFrame());
            if (machinechassis.inventory != null) {
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    machinechassis.inventory.setStackInSlot(i, this.inventory.getStackInSlot(i));
                }
            }
            machinechassis.inventory.setStackInSlot(this.ItemslotInstruction, new ItemStack((ItemLike)InitItemsVCM.INSTRUCTION_CIRCUIT_GROUND.get()));
            this.f_19853_.m_7967_((Entity)machinechassis);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public InteractionResult m_6096_(Player playerIn, InteractionHand interactionhandIn) {
        return super.m_6096_(playerIn, interactionhandIn);
    }

    @Override
    protected void controlMachine() {
        if (this.m_20160_() && this.getStatusPowered() && this.IsBurningFuel()) {
            float f = 0.0f;
            float upgrademodifier = MachineUpgrade.NONE.getModifier();
            if (this.getStatusUpgradeTier() == MachineUpgrade.MINOR.ordinal()) {
                upgrademodifier = MachineUpgrade.MINOR.getModifier();
            }
            if (this.getStatusUpgradeTier() == MachineUpgrade.LESSER.ordinal()) {
                upgrademodifier = MachineUpgrade.LESSER.getModifier();
            }
            if (this.getStatusUpgradeTier() == MachineUpgrade.GREATER.ordinal()) {
                upgrademodifier = MachineUpgrade.GREATER.getModifier();
            }
            if (this.getStatusUpgradeTier() == MachineUpgrade.MASTERWORK.ordinal()) {
                upgrademodifier = MachineUpgrade.MASTERWORK.getModifier();
            }
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputForward && !this.inputBackward) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            float speedIn = 0.085f * upgrademodifier * this.ReducedSpeedMultiplier();
            if (this.inputActivateTurbo) {
                speedIn *= 1.5f;
            }
            if (this.inputForward || this.autorunmovement) {
                f += speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_GROUNDMACHINE.get()).intValue();
                if (this.getStatusAutorun() && !this.autorunmovement) {
                    this.autorunmovement = true;
                }
            }
            if (this.inputBackward) {
                f -= speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_GROUNDMACHINE.get()).intValue() / 2.0f;
                if (this.autorunmovement) {
                    this.autorunmovement = false;
                }
            }
            float f1 = 0.0f;
            if (this.inputUp) {
                if (!this.machineJumping) {
                    this.machineJumping = true;
                }
                if (this.jumpTime <= 15 && this.jumpTime >= 1) {
                    f1 += 0.15f;
                }
            }
            if ((this.getStatus() != EntityMountable.Status.UNDER_FLOWING_WATER || this.getStatus() != EntityMountable.Status.UNDER_WATER) && this.inputDown) {
                f1 -= 0.05f;
            }
            if (this.jumpTime > 15 || this.isGroundMachineHeightMaximum() && !this.machineJumping) {
                f1 -= 0.1f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f)), (double)(f1 += this.runHoveringMovementCalculation()), (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f))));
        }
    }

    @Override
    public Item getDropItem() {
        return (Item)InitItemsVCM.ADMINTOOL_COMPLETE_MACHINE_BASIC.get();
    }

    @Override
    @Nullable
    protected SoundEvent getSoundEngineOn() {
        switch (this.getStatus()) {
            default: 
        }
        return null;
    }

    @Override
    protected float volumeAmbientMachineSound() {
        return 1.0f;
    }

    @Override
    public MachineType GetTEMPMachineType() {
        return MachineType.GROUND;
    }

    @Override
    protected float setInvFrictionOnGround() {
        return 0.01f;
    }

    @Override
    protected float setInvFrictionInAir() {
        return 0.5f;
    }

    @Override
    protected float setInvFrictionInWater() {
        return 0.05f;
    }

    @Override
    protected float setInvFrictionUnderWater() {
        return 0.05f;
    }

    @Override
    protected float setInvFrictionUnderFlowingWater() {
        return 0.05f;
    }

    @Override
    protected float setInvFrictionInLava() {
        return 0.05f;
    }

    @Override
    protected float setInvFrictionUnderLava() {
        return 0.05f;
    }

    @Override
    protected float setInvFrictionUnderFlowingLava() {
        return 0.05f;
    }

    @Override
    protected float setTurnFriction() {
        float upgrademodifier = MachineUpgrade.NONE.getModifier();
        if (this.getStatusUpgradeTier() == MachineUpgrade.MINOR.ordinal()) {
            upgrademodifier = MachineUpgrade.MINOR.getModifier();
        }
        if (this.getStatusUpgradeTier() == MachineUpgrade.LESSER.ordinal()) {
            upgrademodifier = MachineUpgrade.LESSER.getModifier();
        }
        if (this.getStatusUpgradeTier() == MachineUpgrade.GREATER.ordinal()) {
            upgrademodifier = MachineUpgrade.GREATER.getModifier();
        }
        if (this.getStatusUpgradeTier() == MachineUpgrade.MASTERWORK.ordinal()) {
            upgrademodifier = MachineUpgrade.MASTERWORK.getModifier();
        }
        return 0.3f * upgrademodifier;
    }

    protected void damageMachineByStatus() {
        if (this.getStatusDurabilityActive() > 0 && (this.getStatus() == EntityMountable.Status.UNDER_LAVA || this.getStatus() == EntityMountable.Status.UNDER_FLOWING_LAVA || this.getStatus() == EntityMountable.Status.UNDER_WATER || this.getStatus() == EntityMountable.Status.UNDER_FLOWING_WATER) && this.tickingVariableWaterDamage >= 4) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
            this.tickingVariableWaterDamage = 0;
        }
    }

    @Override
    public Component m_5446_() {
        return Component.m_237113_((String)this.getStatusOwnerDisplayName());
    }

    public boolean isBlockUnderMachineAir() {
        Block blockundermachine = this.f_19853_.m_8055_(this.m_20183_().m_6625_(2)).m_60734_();
        Block blockundermachineN = this.f_19853_.m_8055_(this.m_20183_().m_122013_(1).m_6625_(2)).m_60734_();
        Block blockundermachineS = this.f_19853_.m_8055_(this.m_20183_().m_122020_(1).m_6625_(2)).m_60734_();
        Block blockundermachineE = this.f_19853_.m_8055_(this.m_20183_().m_122030_(1).m_6625_(2)).m_60734_();
        Block blockundermachineW = this.f_19853_.m_8055_(this.m_20183_().m_122025_(1).m_6625_(2)).m_60734_();
        return blockundermachine == Blocks.f_50016_;
    }

    public boolean isGroundMachineHeightMaximum() {
        Block blockundermachine = this.f_19853_.m_8055_(this.m_20183_().m_6625_(3)).m_60734_();
        return blockundermachine == Blocks.f_50016_;
    }

    protected float runHoveringMovementCalculation() {
        float f1 = 0.0f;
        if (this.floatingupwards) {
            f1 += 0.02f;
            if (this.isGroundMachineHeightMaximum()) {
                this.floatingupwards = false;
            }
        } else {
            f1 -= 0.02f;
            if (!this.isBlockUnderMachineAir()) {
                this.floatingupwards = true;
            }
        }
        return f1;
    }
}

