/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.entities.machines.types;

import com.vies.viescraftmachines.VCMCommonConfig;
import com.vies.viescraftmachines.common.entities.machines.EntityMachineDurabilityAndEnergy;
import com.vies.viescraftmachines.common.entities.machines.EntityMountable;
import com.vies.viescraftmachines.common.entities.thrown.EntityChassisTypeBasic;
import com.vies.viescraftmachines.common.screens.MachineTypeBasicMenu;
import com.vies.viescraftmachines.util.enums.MachineType;
import com.vies.viescraftmachines.util.enums.MachineUpgrade;
import com.vies.viescraftmachines.util.enums.TriggerEvents;
import com.vies.viescraftmachines.util.init.common.InitEntitiesVCM;
import com.vies.viescraftmachines.util.init.common.InitItemsVCM;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class EntityMachineTypeBasic
extends EntityMachineDurabilityAndEnergy {
    protected int tickingVariableWaterDamage = 0;
    protected boolean machineJumping;
    protected float jumpPower;
    protected int jumpTime = 0;
    protected boolean floatingupwards;
    private boolean autorunmovement = false;

    public EntityMachineTypeBasic(EntityType<? extends EntityMachineTypeBasic> entitytypeIn, Level levelIn) {
        super((EntityType<? extends EntityMachineDurabilityAndEnergy>)entitytypeIn, levelIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    protected void m_7380_(CompoundTag tagIn) {
        super.m_7380_(tagIn);
    }

    @Override
    protected void m_7378_(CompoundTag tagIn) {
        super.m_7378_(tagIn);
    }

    @Override
    public void m_8119_() {
        if (!this.getStatusItemStackInSlot4().m_41619_() && this.getStatusItemStackInSlot4().m_41720_().toString().contains(MachineType.SEA.getName())) {
            if (this.status == EntityMountable.Status.UNDER_FLOWING_WATER || this.status == EntityMountable.Status.UNDER_WATER || this.status == EntityMountable.Status.UNDER_FLOWING_LAVA || this.status == EntityMountable.Status.UNDER_LAVA || this.status == EntityMountable.Status.IN_WATER) {
                this.m_20242_(true);
            } else {
                this.m_20242_(false);
            }
        } else if (this.PoweredAndHasFuel()) {
            this.m_20242_(true);
        } else {
            this.m_20242_(false);
        }
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.controlMachine();
        }
        if (!this.getStatusItemStackInSlot4().m_41619_() && (this.getStatusItemStackInSlot4().m_41720_().toString().contains(MachineType.GROUND.getName()) || this.getStatusItemStackInSlot4().m_41720_().toString().contains(MachineType.HAULER.getName())) && this.m_6688_() == null && this.PoweredAndHasFuel()) {
            float f1 = this.runHoveringMovementCalculation();
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)f1, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.damageMachineByStatus();
        this.playAmbientMachineSound();
        if (this.getStatusVeryBrokenCounter() >= 3) {
            if (!this.f_19853_.f_46443_) {
                EntityChassisTypeBasic machinechassis = new EntityChassisTypeBasic((EntityType<? extends EntityChassisTypeBasic>)((EntityType)InitEntitiesVCM.MACHINE_CHASSIS_BASIC.get()), this.f_19853_);
                machinechassis.m_146884_(this.m_20182_());
                machinechassis.m_146926_(this.m_146909_());
                machinechassis.m_146922_(this.m_146908_());
                int backluck = this.f_19853_.f_46441_.m_216339_(1, 4);
                if (backluck == 1) {
                    machinechassis.setStatusKitPanel(true);
                    machinechassis.setStatusKitMetal(true);
                }
                if (backluck == 2) {
                    machinechassis.setStatusKitMetal(true);
                    machinechassis.setStatusKitCloth(true);
                }
                if (backluck == 3) {
                    machinechassis.setStatusKitPanel(true);
                    machinechassis.setStatusKitCloth(true);
                }
                this.explodeMachine();
                this.f_19853_.m_7967_((Entity)machinechassis);
            }
            this.setStatusTriggerEvent(TriggerEvents.EXPLODE_MACHINE.ordinal());
            this.dropInventory();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!this.getStatusItemStackInSlot4().m_41619_() && (this.getStatusItemStackInSlot4().m_41720_().toString().contains(MachineType.GROUND.getName()) || this.getStatusItemStackInSlot4().m_41720_().toString().contains(MachineType.HAULER.getName()))) {
            if (!this.isBlockUnderMachineAir() && this.machineJumping) {
                this.machineJumping = false;
                this.jumpTime = 0;
            }
            if (this.machineJumping) {
                ++this.jumpTime;
            }
        }
        this.dropInventoryContentsStorageSlot6();
    }

    @Override
    public InteractionResult m_6096_(Player playerIn, InteractionHand interactionhandIn) {
        return super.m_6096_(playerIn, interactionhandIn);
    }

    @Override
    public double m_6048_() {
        if (!this.getStatusItemStackInSlot4().m_41619_() && this.getStatusItemStackInSlot4().m_41720_().toString().contains(MachineType.SEA.getName())) {
            return 0.4;
        }
        return super.m_6048_();
    }

    @Override
    protected void controlMachine() {
        if (this.m_20160_() && this.getStatusPowered()) {
            float upgrademodifier = MachineUpgrade.NONE.getModifier();
            for (MachineUpgrade type : MachineUpgrade.values()) {
                if (!this.getStatusItemStackInSlot5().m_41720_().toString().contains(type.getName())) continue;
                upgrademodifier = type.getModifier();
            }
            if (this.getStatusMachineType() == MachineType.FLYING.ordinal()) {
                this.ApplyMovementControlsFlying(upgrademodifier);
            }
            if (this.getStatusMachineType() == MachineType.GROUND.ordinal()) {
                this.ApplyMovementControlsGround(upgrademodifier);
            }
            if (this.getStatusMachineType() == MachineType.SEA.ordinal()) {
                this.ApplyMovementControlsSea(upgrademodifier);
            }
            if (this.getStatusMachineType() == MachineType.HAULER.ordinal()) {
                this.ApplyMovementControlsHauler(upgrademodifier);
            }
        }
    }

    @Override
    public Item getDropItem() {
        return (Item)InitItemsVCM.ADMINTOOL_COMPLETE_MACHINE_BASIC.get();
    }

    @Override
    protected boolean m_7310_(Entity entityIn) {
        int numberofpassengers = 2;
        if (this.getStatusMachineType() == MachineType.NONE.ordinal() || this.getStatusMachineType() == MachineType.HAULER.ordinal()) {
            numberofpassengers = 1;
        }
        return this.m_20197_().size() < numberofpassengers;
    }

    @Override
    @Nullable
    protected SoundEvent getSoundEngineOn() {
        switch (this.getStatus()) {
            default: 
        }
        return null;
    }

    @Override
    protected float volumeAmbientMachineSound() {
        return 1.0f;
    }

    @Override
    public MachineType getDefaultMachineType() {
        return MachineType.NONE;
    }

    @Override
    protected float setInvFrictionOnGround() {
        return MachineType.byId(this.getStatusMachineType()).getFrictionOnGround();
    }

    @Override
    protected float setInvFrictionInAir() {
        return MachineType.byId(this.getStatusMachineType()).getFrictionInAir();
    }

    @Override
    protected float setInvFrictionInWater() {
        return MachineType.byId(this.getStatusMachineType()).getFrictionInWater();
    }

    @Override
    protected float setInvFrictionUnderWater() {
        return MachineType.byId(this.getStatusMachineType()).getFrictionUnderWater();
    }

    @Override
    protected float setInvFrictionUnderFlowingWater() {
        return MachineType.byId(this.getStatusMachineType()).getFrictionUnderFlowingWater();
    }

    @Override
    protected float setInvFrictionInLava() {
        return MachineType.byId(this.getStatusMachineType()).getFrictionInLava();
    }

    @Override
    protected float setInvFrictionUnderLava() {
        return MachineType.byId(this.getStatusMachineType()).getFrictionUnderLava();
    }

    @Override
    protected float setInvFrictionUnderFlowingLava() {
        return MachineType.byId(this.getStatusMachineType()).getFrictionUnderFlowingLava();
    }

    @Override
    protected float setTurnFriction() {
        float upgrademodifier = MachineUpgrade.NONE.getModifier();
        for (MachineUpgrade type : MachineUpgrade.values()) {
            if (!this.getStatusItemStackInSlot5().m_41720_().toString().contains(type.getName())) continue;
            upgrademodifier = type.getModifier();
        }
        return MachineType.byId(this.getStatusMachineType()).getTurningSpeed() * upgrademodifier;
    }

    protected void damageMachineByStatus() {
        if (this.getStatusDurabilityActive() > 0 && (this.getStatus() == EntityMountable.Status.UNDER_LAVA || this.getStatus() == EntityMountable.Status.UNDER_FLOWING_LAVA || this.getStatus() == EntityMountable.Status.UNDER_WATER || this.getStatus() == EntityMountable.Status.UNDER_FLOWING_WATER) && this.tickingVariableWaterDamage >= 4) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
            this.tickingVariableWaterDamage = 0;
        }
    }

    public boolean isBlockUnderMachineAir() {
        Block blockundermachine = this.f_19853_.m_8055_(this.m_20183_().m_6625_(2)).m_60734_();
        Block blockundermachineN = this.f_19853_.m_8055_(this.m_20183_().m_122013_(1).m_6625_(2)).m_60734_();
        Block blockundermachineS = this.f_19853_.m_8055_(this.m_20183_().m_122020_(1).m_6625_(2)).m_60734_();
        Block blockundermachineE = this.f_19853_.m_8055_(this.m_20183_().m_122030_(1).m_6625_(2)).m_60734_();
        Block blockundermachineW = this.f_19853_.m_8055_(this.m_20183_().m_122025_(1).m_6625_(2)).m_60734_();
        return blockundermachine == Blocks.f_50016_;
    }

    public boolean isGroundMachineHeightMaximum() {
        Block blockundermachine = this.f_19853_.m_8055_(this.m_20183_().m_6625_(3)).m_60734_();
        return blockundermachine == Blocks.f_50016_;
    }

    protected float runHoveringMovementCalculation() {
        float f1 = 0.0f;
        if (this.floatingupwards) {
            f1 += 0.02f;
            if (this.isGroundMachineHeightMaximum()) {
                this.floatingupwards = false;
            }
        } else {
            f1 -= 0.02f;
            if (!this.isBlockUnderMachineAir()) {
                this.floatingupwards = true;
            }
        }
        return f1;
    }

    protected float runUnderwaterFloatingMovementCalculation() {
        float f1 = 0.0f;
        if (this.status == EntityMountable.Status.UNDER_FLOWING_WATER || this.status == EntityMountable.Status.UNDER_WATER || this.status == EntityMountable.Status.UNDER_FLOWING_LAVA || this.status == EntityMountable.Status.UNDER_LAVA) {
            f1 += 0.2f;
        }
        return f1;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new MachineTypeBasicMenu(pContainerId, pPlayerInventory, this, this.dataAccess);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237113_((String)this.getStatusOwnerDisplayName());
    }

    private void ApplyMovementControlsFlying(float upgrademodifierIn) {
        float f = 0.0f;
        float f1 = 0.0f;
        if (this.IsBurningFuel()) {
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputForward && !this.inputBackward) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            float speedIn = MachineType.byId(this.getStatusMachineType()).getForwardSpeed() * upgrademodifierIn * this.ReducedSpeedMultiplier();
            if (this.inputActivateTurbo) {
                speedIn *= 1.5f;
            }
            if (this.inputForward || this.autorunmovement) {
                f += speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_FLYINGMACHINE.get()).intValue();
                if (this.getStatusAutorun() && !this.autorunmovement) {
                    this.autorunmovement = true;
                }
            }
            if (this.inputBackward) {
                f -= speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_FLYINGMACHINE.get()).intValue() / 2.0f;
                if (this.autorunmovement) {
                    this.autorunmovement = false;
                }
            }
            if (this.inputUp) {
                f1 += 0.05f * upgrademodifierIn;
            }
            if ((this.getStatus() != EntityMountable.Status.UNDER_FLOWING_WATER || this.getStatus() != EntityMountable.Status.UNDER_WATER) && this.inputDown) {
                f1 -= 0.05f * upgrademodifierIn;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f)), (double)f1, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f))));
        }
    }

    private void ApplyMovementControlsGround(float upgrademodifierIn) {
        float f = 0.0f;
        float f1 = 0.0f;
        if (this.IsBurningFuel()) {
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputForward && !this.inputBackward) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            float speedIn = MachineType.byId(this.getStatusMachineType()).getForwardSpeed() * upgrademodifierIn * this.ReducedSpeedMultiplier();
            if (this.inputActivateTurbo) {
                speedIn *= 1.5f;
            }
            if (this.inputForward || this.autorunmovement) {
                f += speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_GROUNDMACHINE.get()).intValue();
                if (this.getStatusAutorun() && !this.autorunmovement) {
                    this.autorunmovement = true;
                }
            }
            if (this.inputBackward) {
                f -= speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_GROUNDMACHINE.get()).intValue() / 2.0f;
                if (this.autorunmovement) {
                    this.autorunmovement = false;
                }
            }
            if (this.inputUp) {
                if (!this.machineJumping) {
                    this.machineJumping = true;
                }
                if (this.jumpTime <= 15 && this.jumpTime >= 1) {
                    f1 += 0.12f;
                }
            }
            if ((this.getStatus() != EntityMountable.Status.UNDER_FLOWING_WATER || this.getStatus() != EntityMountable.Status.UNDER_WATER) && this.inputDown) {
                f1 -= 0.05f;
            }
            if (this.jumpTime > 15 || this.isGroundMachineHeightMaximum() && !this.machineJumping) {
                f1 -= 0.08f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f)), (double)(f1 += this.runHoveringMovementCalculation()), (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f))));
        }
    }

    private void ApplyMovementControlsSea(float upgrademodifierIn) {
        float f = 0.0f;
        float f1 = 0.0f;
        if (this.IsBurningFuel()) {
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputForward && !this.inputBackward) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            float speedIn = MachineType.byId(this.getStatusMachineType()).getForwardSpeed() * upgrademodifierIn * this.ReducedSpeedMultiplier();
            if (this.inputActivateTurbo) {
                speedIn *= 1.5f;
            }
            if (this.inputForward || this.autorunmovement) {
                f += speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_SEAMACHINE.get()).intValue();
                if (this.getStatusAutorun() && !this.autorunmovement) {
                    this.autorunmovement = true;
                }
            }
            if (this.inputBackward) {
                f -= speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_SEAMACHINE.get()).intValue() / 2.0f;
                if (this.autorunmovement) {
                    this.autorunmovement = false;
                }
            }
            if (this.inputUp && (this.status == EntityMountable.Status.UNDER_FLOWING_WATER || this.status == EntityMountable.Status.UNDER_WATER || this.status == EntityMountable.Status.UNDER_FLOWING_LAVA || this.status == EntityMountable.Status.UNDER_LAVA)) {
                f1 += 0.025f;
            }
        }
        f1 = this.status == EntityMountable.Status.IN_AIR ? (f1 += -0.5f) : (f1 += this.runUnderwaterFloatingMovementCalculation());
        this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f)), (double)f1, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f))));
    }

    private void ApplyMovementControlsHauler(float upgrademodifierIn) {
        float f = 0.0f;
        float f1 = 0.0f;
        if (this.IsBurningFuel()) {
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputForward && !this.inputBackward) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            float speedIn = MachineType.byId(this.getStatusMachineType()).getForwardSpeed() * upgrademodifierIn * this.ReducedSpeedMultiplier();
            if (this.inputActivateTurbo) {
                speedIn *= 1.5f;
            }
            if (this.inputForward || this.autorunmovement) {
                f += speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_HAULERMACHINE.get()).intValue();
                if (this.getStatusAutorun() && !this.autorunmovement) {
                    this.autorunmovement = true;
                }
            }
            if (this.inputBackward) {
                f -= speedIn / 100.0f * (float)((Integer)VCMCommonConfig.MOVEMENT_FORWARDSPEED_HAULERMACHINE.get()).intValue() / 2.0f;
                if (this.autorunmovement) {
                    this.autorunmovement = false;
                }
            }
            if (this.inputUp) {
                if (!this.machineJumping) {
                    this.machineJumping = true;
                }
                if (this.jumpTime <= 15 && this.jumpTime >= 1) {
                    f1 += 0.08f;
                }
            }
            if ((this.getStatus() != EntityMountable.Status.UNDER_FLOWING_WATER || this.getStatus() != EntityMountable.Status.UNDER_WATER) && this.inputDown) {
                f1 -= 0.05f;
            }
            if (this.jumpTime > 15 || this.isGroundMachineHeightMaximum() && !this.machineJumping) {
                f1 -= 0.1f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f)), (double)(f1 += this.runHoveringMovementCalculation()), (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (f * 1.0f))));
        }
    }
}

