/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.entities.machines;

import com.vies.viescraftmachines.common.entities.machines.EntityMountable;
import com.vies.viescraftmachines.common.screens.MachineTypeBasicMenu;
import com.vies.viescraftmachines.network.MessagesVCM;
import com.vies.viescraftmachines.network.packets.PacketOpenRidingMenu;
import com.vies.viescraftmachines.network.packets.PacketToggleMachineTurboOff;
import com.vies.viescraftmachines.network.packets.PacketToggleMachineTurboOn;
import com.vies.viescraftmachines.util.enums.MachineType;
import com.vies.viescraftmachines.util.enums.MachineUpgrade;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class EntityMachineBase
extends EntityMountable
implements Container,
MenuProvider {
    private static final EntityDataAccessor<Integer> DATA_ID_MACHINETYPE = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_ID_OWNER = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_ID_OWNERDISPLAYNAME = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> DATA_ID_LOCKED = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_TEXTUREPANEL = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TEXTUREMETAL = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TEXTURECLOTH = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TEXTUREFRAME = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT0_FUEL = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT1_IGNITIONKEY = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT2_RECORD = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT3_PATREON = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT4_INSTRUCTION = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT5_UPGRADE = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT6_STORAGE1 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT7_STORAGE2 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT8_STORAGE3 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ITEMSTACKINSLOT9_STORAGE4 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> DATA_ID_UPGRADETIER = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_PATREONITEMSIDE = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_PATREONITEMSPIN = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected EntityDimensions f_19815_;
    protected MachineType statusMachineType;
    protected MachineType oldStatusMachineType;
    protected int currentTotalFuel;
    protected int overallTotalFuel;
    protected int stacksizeOfFuelSlot;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int switchIn) {
            switch (switchIn) {
                case 0: {
                    return EntityMachineBase.this.getStatusCurrentActiveFuel();
                }
                case 1: {
                    return EntityMachineBase.this.currentTotalFuel;
                }
                case 2: {
                    return EntityMachineBase.this.getStatusOverallActiveFuel();
                }
                case 3: {
                    return EntityMachineBase.this.overallTotalFuel;
                }
                case 4: {
                    return EntityMachineBase.this.stacksizeOfFuelSlot;
                }
            }
            return 0;
        }

        public void m_8050_(int switchIn, int varIn) {
            switch (switchIn) {
                case 0: {
                    EntityMachineBase.this.setStatusCurrentActiveFuel(varIn);
                    break;
                }
                case 1: {
                    EntityMachineBase.this.currentTotalFuel = varIn;
                    break;
                }
                case 2: {
                    EntityMachineBase.this.setStatusOverallActiveFuel(varIn);
                    break;
                }
                case 3: {
                    EntityMachineBase.this.overallTotalFuel = varIn;
                    break;
                }
                case 4: {
                    EntityMachineBase.this.stacksizeOfFuelSlot = varIn;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    public int ItemslotFuel = 0;
    public int ItemslotIgnitionKey = 1;
    public int ItemslotRecord = 2;
    public int ItemslotPatreon = 3;
    public int ItemslotInstruction = 4;
    public int ItemslotUpgrade = 5;
    public int ItemslotStorage1 = 6;
    public int ItemslotStorage2 = 7;
    public int ItemslotStorage3 = 8;
    public int ItemslotStorage4 = 9;
    public int ItemslotItemFrame = 118;
    public int ItemslotItemDisplay = 119;
    public int MaxSlotSize = 128;
    public ItemStackHandler inventory = this.createHandler();
    public LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.inventory);
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)this.MaxSlotSize, (Object)ItemStack.f_41583_);

    public EntityMachineBase(EntityType<? extends EntityMachineBase> entitytypeIn, Level levelIn) {
        super(entitytypeIn, levelIn);
        this.f_19815_ = entitytypeIn.m_20680_();
        this.lazyItemHandler = LazyOptional.of(() -> this.inventory);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_MACHINETYPE, (Object)MachineType.NONE.ordinal());
        this.f_19804_.m_135372_(DATA_ID_OWNER, (Object)"");
        this.f_19804_.m_135372_(DATA_ID_OWNERDISPLAYNAME, (Object)"");
        this.f_19804_.m_135372_(DATA_ID_LOCKED, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TEXTUREPANEL, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TEXTUREMETAL, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TEXTURECLOTH, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TEXTUREFRAME, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT0_FUEL, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT1_IGNITIONKEY, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT2_RECORD, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT3_PATREON, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT4_INSTRUCTION, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT5_UPGRADE, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT6_STORAGE1, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT7_STORAGE2, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT8_STORAGE3, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ITEMSTACKINSLOT9_STORAGE4, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_UPGRADETIER, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_PATREONITEMSIDE, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_PATREONITEMSPIN, (Object)0);
    }

    @Override
    protected void m_7380_(CompoundTag tagIn) {
        tagIn.m_128365_("tag-machine-inventory_vcm", (Tag)this.inventory.serializeNBT());
        tagIn.m_128359_("tag-machine-owner_vcm", this.getStatusOwner());
        tagIn.m_128359_("tag-machine-ownerdisplayname_vcm", this.getStatusOwnerDisplayName());
        tagIn.m_128379_("tag-machine-locked_vcm", this.getStatusLocked());
        tagIn.m_128405_("tag-machine-texturepanel_vcm", this.getStatusTexturePanel());
        tagIn.m_128405_("tag-machine-texturemetal_vcm", this.getStatusTextureMetal());
        tagIn.m_128405_("tag-machine-texturecloth_vcm", this.getStatusTextureCloth());
        tagIn.m_128405_("tag-machine-textureframe_vcm", this.getStatusTextureFrame());
        tagIn.m_128365_("tag-machine-iteminslot0_vcm", (Tag)this.getStatusItemStackInSlot0().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot1_vcm", (Tag)this.getStatusItemStackInSlot1().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot2_vcm", (Tag)this.getStatusItemStackInSlot2().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot3_vcm", (Tag)this.getStatusItemStackInSlot3().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot4_vcm", (Tag)this.getStatusItemStackInSlot4().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot5_vcm", (Tag)this.getStatusItemStackInSlot5().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot6_vcm", (Tag)this.getStatusItemStackInSlot6().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot7_vcm", (Tag)this.getStatusItemStackInSlot7().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot8_vcm", (Tag)this.getStatusItemStackInSlot8().m_41739_(new CompoundTag()));
        tagIn.m_128365_("tag-machine-iteminslot9_vcm", (Tag)this.getStatusItemStackInSlot9().m_41739_(new CompoundTag()));
        tagIn.m_128405_("tag-machine-upgradetier_vcm", this.getStatusUpgradeTier());
        tagIn.m_128405_("tag-machine-patreonside_vcm", this.getStatusPatreonSide());
        tagIn.m_128405_("tag-machine-patreonspin_vcm", this.getStatusPatreonSpin());
        tagIn.m_128405_("tag-machine-type_vcm", this.getStatusMachineType());
        super.m_7380_(tagIn);
    }

    @Override
    protected void m_7378_(CompoundTag tagIn) {
        super.m_7378_(tagIn);
        this.inventory.deserializeNBT(tagIn.m_128469_("tag-machine-inventory_vcm"));
        this.setStatusOwner(tagIn.m_128461_("tag-machine-owner_vcm"));
        this.setStatusOwnerDisplayName(tagIn.m_128461_("tag-machine-ownerdisplayname_vcm"));
        this.setStatusLocked(tagIn.m_128471_("tag-machine-locked_vcm"));
        this.setStatusTexturePanel(tagIn.m_128451_("tag-machine-texturepanel_vcm"));
        this.setStatusTextureMetal(tagIn.m_128451_("tag-machine-texturemetal_vcm"));
        this.setStatusTextureCloth(tagIn.m_128451_("tag-machine-texturecloth_vcm"));
        this.setStatusTextureFrame(tagIn.m_128451_("tag-machine-textureframe_vcm"));
        this.setStatusItemStackInSlot0(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot0_vcm")));
        this.setStatusItemStackInSlot1(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot1_vcm")));
        this.setStatusItemStackInSlot2(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot2_vcm")));
        this.setStatusItemStackInSlot3(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot3_vcm")));
        this.setStatusItemStackInSlot4(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot4_vcm")));
        this.setStatusItemStackInSlot5(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot5_vcm")));
        this.setStatusItemStackInSlot6(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot6_vcm")));
        this.setStatusItemStackInSlot7(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot7_vcm")));
        this.setStatusItemStackInSlot8(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot8_vcm")));
        this.setStatusItemStackInSlot9(ItemStack.m_41712_((CompoundTag)tagIn.m_128469_("tag-machine-iteminslot9_vcm")));
        this.setStatusUpgradeTier(tagIn.m_128451_("tag-machine-upgradetier_vcm"));
        this.setStatusPatreonSide(tagIn.m_128451_("tag-machine-patreonside_vcm"));
        this.setStatusPatreonSpin(tagIn.m_128451_("tag-machine-patreonspin_vcm"));
        this.setStatusMachineType(tagIn.m_128451_("tag-machine-type_vcm"));
    }

    @Override
    public void m_8119_() {
        this.oldStatusMachineType = this.statusMachineType;
        this.statusMachineType = MachineType.byId(this.getStatusMachineType());
        super.m_8119_();
        if (this.m_6688_() instanceof Player && (this.getStatusOwner() == "" || this.getStatusOwnerDisplayName() == "")) {
            this.setStatusOwner(this.m_6688_().m_20148_().toString());
            this.setStatusOwnerDisplayName(this.f_19853_.m_46003_(UUID.fromString(this.getStatusOwner())).m_5446_().getString());
            if (this.m_6688_().f_19853_.m_5776_()) {
                this.m_6688_().m_213846_((Component)Component.m_237115_((String)"item.viescraftmachines.message.youarenowtheowner.1"));
            }
        }
        if (this.m_6109_() && this.f_19853_.f_46443_ && this.m_6688_() instanceof Player && this.inputMachineMenu) {
            MessagesVCM.sendToServer(new PacketOpenRidingMenu(this.m_19879_()));
        }
        if (this.f_19853_.m_5776_()) {
            if (this.inputActivateTurbo) {
                if (!this.getStatusTurboActivated()) {
                    MessagesVCM.sendToServer(new PacketToggleMachineTurboOn(this.m_19879_()));
                }
            } else if (this.getStatusTurboActivated()) {
                MessagesVCM.sendToServer(new PacketToggleMachineTurboOff(this.m_19879_()));
            }
        }
        if (this.getStatusLocked() && this.m_6688_() instanceof Player && !this.getStatusOwner().equals(this.m_6688_().m_20149_())) {
            if (this.getStatusItemStackInSlot1().m_41619_()) {
                this.m_6688_().m_8127_();
            } else if (!this.getStatusItemStackInSlot1().m_41619_() && !this.getStatusItemStackInSlot1().m_41782_()) {
                this.m_6688_().m_8127_();
            } else if (!this.getStatusItemStackInSlot1().m_41619_() && !this.getStatusItemStackInSlot1().m_41783_().m_128461_("tag-machine-owner_vcm").equals(this.getStatusOwner())) {
                this.m_6688_().m_8127_();
            }
        }
        if (this.oldStatusMachineType != this.statusMachineType) {
            SimpleContainer inventoryIn;
            if (this.statusMachineType == MachineType.NONE || this.statusMachineType == MachineType.FLYING || this.statusMachineType == MachineType.GROUND) {
                inventoryIn = new SimpleContainer(this.inventory.getSlots());
                inventoryIn.m_6836_(7, this.inventory.getStackInSlot(7));
                inventoryIn.m_6836_(8, this.inventory.getStackInSlot(8));
                inventoryIn.m_6836_(9, this.inventory.getStackInSlot(9));
                Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
            }
            if (this.statusMachineType == MachineType.SEA) {
                inventoryIn = new SimpleContainer(this.inventory.getSlots());
                inventoryIn.m_6836_(8, this.inventory.getStackInSlot(8));
                inventoryIn.m_6836_(9, this.inventory.getStackInSlot(9));
                Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
            }
        }
        this.dropInventoryContentsStorageSlot6();
        this.dropInventoryContentsStorageSlot7();
        this.dropInventoryContentsStorageSlot8();
        this.dropInventoryContentsStorageSlot9();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(this.MaxSlotSize){

            protected void onContentsChanged(int slot) {
                EntityMachineBase.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }

            protected void onLoad() {
            }
        };
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void dropInventory() {
        SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
    }

    @Override
    public InteractionResult m_6096_(Player playerIn, InteractionHand interactionhandIn) {
        return super.m_6096_(playerIn, interactionhandIn);
    }

    @Nullable
    protected SoundEvent getSoundEngineOn() {
        switch (this.getStatus()) {
            default: 
        }
        return null;
    }

    protected void playAmbientMachineSound() {
        SoundEvent soundevent = this.getSoundEngineOn();
        if (soundevent != null) {
            Vec3 vec3 = this.m_20252_(1.0f);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), this.volumeAmbientMachineSound(), 0.8f + 0.4f * this.f_19796_.m_188501_());
        }
    }

    protected float volumeAmbientMachineSound() {
        return 1.0f;
    }

    public int m_6643_() {
        return this.MaxSlotSize;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.itemStacks.get(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.itemStacks, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        ItemStack itemstack = (ItemStack)this.itemStacks.get(pIndex);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.itemStacks.set(pIndex, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.itemStacks.set(pIndex, (Object)pStack);
        if (!pStack.m_41619_() && pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
    }

    public SlotAccess m_141942_(final int pSlot) {
        return pSlot >= 0 && pSlot < this.m_6643_() ? new SlotAccess(){

            public ItemStack m_142196_() {
                return EntityMachineBase.this.m_8020_(pSlot);
            }

            public boolean m_142104_(ItemStack p_150265_) {
                EntityMachineBase.this.m_6836_(pSlot, p_150265_);
                return true;
            }
        } : super.m_141942_(pSlot);
    }

    public void m_6596_() {
        this.IsItemStackInSlot0();
        this.IsItemStackInSlot1();
        this.IsItemStackInSlot2();
        this.IsItemStackInSlot3();
        this.IsItemStackInSlot4();
        this.IsItemStackInSlot5();
        this.IsItemStackInSlot6();
        this.IsItemStackInSlot7();
        this.IsItemStackInSlot8();
        this.IsItemStackInSlot9();
        this.UpdateMachineTypeFromSlot4();
        this.UpdateUpgradeTypeFromSlot5();
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.m_213877_()) {
            return false;
        }
        return !(pPlayer.m_20280_((Entity)this) > 64.0);
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (!this.f_19853_.f_46443_ && pReason.m_146965_()) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
        super.m_142687_(pReason);
    }

    public void m_6211_() {
        this.itemStacks.clear();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new MachineTypeBasicMenu(pContainerId, pPlayerInventory, this, this.dataAccess);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)this.getStatusOwnerDisplayName());
    }

    public void setStatusMachineType(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_MACHINETYPE, (Object)valueIn);
    }

    public int getStatusMachineType() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_MACHINETYPE);
    }

    public void setStatusOwner(String valueIn) {
        this.f_19804_.m_135381_(DATA_ID_OWNER, (Object)valueIn);
    }

    public String getStatusOwner() {
        return (String)this.f_19804_.m_135370_(DATA_ID_OWNER);
    }

    public void setStatusOwnerDisplayName(String valueIn) {
        this.f_19804_.m_135381_(DATA_ID_OWNERDISPLAYNAME, (Object)valueIn);
    }

    public String getStatusOwnerDisplayName() {
        return (String)this.f_19804_.m_135370_(DATA_ID_OWNERDISPLAYNAME);
    }

    public void setStatusLocked(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_LOCKED, (Object)valueIn);
    }

    public boolean getStatusLocked() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_LOCKED);
    }

    public void setStatusItemStackInSlot0(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT0_FUEL, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot0() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT0_FUEL);
    }

    public void setStatusItemStackInSlot1(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT1_IGNITIONKEY, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot1() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT1_IGNITIONKEY);
    }

    public void setStatusItemStackInSlot2(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT2_RECORD, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot2() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT2_RECORD);
    }

    public void setStatusItemStackInSlot3(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT3_PATREON, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot3() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT3_PATREON);
    }

    public void setStatusItemStackInSlot4(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT4_INSTRUCTION, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot4() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT4_INSTRUCTION);
    }

    public void setStatusItemStackInSlot5(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT5_UPGRADE, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot5() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT5_UPGRADE);
    }

    public void setStatusItemStackInSlot6(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT6_STORAGE1, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot6() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT6_STORAGE1);
    }

    public void setStatusItemStackInSlot7(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT7_STORAGE2, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot7() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT7_STORAGE2);
    }

    public void setStatusItemStackInSlot8(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT8_STORAGE3, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot8() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT8_STORAGE3);
    }

    public void setStatusItemStackInSlot9(ItemStack valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMSTACKINSLOT9_STORAGE4, (Object)valueIn);
    }

    public ItemStack getStatusItemStackInSlot9() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ITEMSTACKINSLOT9_STORAGE4);
    }

    public void setStatusUpgradeTier(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_UPGRADETIER, (Object)valueIn);
    }

    public int getStatusUpgradeTier() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_UPGRADETIER);
    }

    public void setStatusPatreonSide(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_PATREONITEMSIDE, (Object)valueIn);
    }

    public int getStatusPatreonSide() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_PATREONITEMSIDE);
    }

    public void setStatusPatreonSpin(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_PATREONITEMSPIN, (Object)valueIn);
    }

    public int getStatusPatreonSpin() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_PATREONITEMSPIN);
    }

    @Override
    public void setStatusBroken(boolean valueIn) {
    }

    @Override
    public boolean getStatusBroken() {
        return false;
    }

    @Override
    public void setStatusPowered(boolean valueIn) {
    }

    @Override
    public boolean getStatusPowered() {
        return false;
    }

    public void setStatusAutorun(boolean valueIn) {
    }

    public boolean getStatusAutorun() {
        return false;
    }

    public void setStatusTurboActivated(boolean valueIn) {
    }

    public boolean getStatusTurboActivated() {
        return false;
    }

    public void setStatusCurrentActiveFuel(int valueIn) {
    }

    public int getStatusCurrentActiveFuel() {
        return 0;
    }

    public void setStatusOverallActiveFuel(int valueIn) {
    }

    public int getStatusOverallActiveFuel() {
        return 0;
    }

    public void setStatusDurabilityActive(int valueIn) {
    }

    public int getStatusDurabilityActive() {
        return 0;
    }

    public void setStatusDurabilityTotal(int valueIn) {
    }

    public int getStatusDurabilityTotal() {
        return 250;
    }

    public void setStatusEnergyActive(int valueIn) {
    }

    public int getStatusEnergyActive() {
        return 250;
    }

    public void setStatusEnergyTotal(int valueIn) {
    }

    public int getStatusEnergyTotal() {
        return 0;
    }

    public void setStatusTriggerEvent(int valueIn) {
    }

    public int getStatusTriggerEvent() {
        return 0;
    }

    public void setStatusEngineIssues(int valueIn) {
    }

    public int getStatusEngineIssues() {
        return 0;
    }

    public void setStatusTexturePanel(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TEXTUREPANEL, (Object)valueIn);
    }

    public int getStatusTexturePanel() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TEXTUREPANEL);
    }

    public void setStatusTextureMetal(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TEXTUREMETAL, (Object)valueIn);
    }

    public int getStatusTextureMetal() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TEXTUREMETAL);
    }

    public void setStatusTextureCloth(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TEXTURECLOTH, (Object)valueIn);
    }

    public int getStatusTextureCloth() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TEXTURECLOTH);
    }

    public void setStatusTextureFrame(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TEXTUREFRAME, (Object)valueIn);
    }

    public int getStatusTextureFrame() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TEXTUREFRAME);
    }

    public void openMachineMenu(Player playerIn) {
        if (!this.f_19853_.m_5776_()) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)playerIn;
            NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
        }
    }

    public static void ConvertMachineToItem(Player playerIn) {
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_188583_() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)pInaccuracy).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        float f = -Mth.m_14031_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, pVelocity, pInaccuracy);
        Vec3 vec3 = pShooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, pShooter.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    public void dropInventoryContentsStorageSlot6() {
        if (this.inventory.getStackInSlot(this.ItemslotStorage1).m_41619_() && this.areItemsInStorageSlot6Range(this.inventory)) {
            SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
            for (int i = 10; i <= 36; ++i) {
                inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
        }
    }

    private boolean areItemsInStorageSlot6Range(ItemStackHandler inventoryIn) {
        boolean hasItems = false;
        if (!(inventoryIn.getStackInSlot(10).m_41619_() && inventoryIn.getStackInSlot(11).m_41619_() && inventoryIn.getStackInSlot(12).m_41619_() && inventoryIn.getStackInSlot(13).m_41619_() && inventoryIn.getStackInSlot(14).m_41619_() && inventoryIn.getStackInSlot(15).m_41619_() && inventoryIn.getStackInSlot(16).m_41619_() && inventoryIn.getStackInSlot(17).m_41619_() && inventoryIn.getStackInSlot(18).m_41619_() && inventoryIn.getStackInSlot(19).m_41619_() && inventoryIn.getStackInSlot(20).m_41619_() && inventoryIn.getStackInSlot(21).m_41619_() && inventoryIn.getStackInSlot(22).m_41619_() && inventoryIn.getStackInSlot(23).m_41619_() && inventoryIn.getStackInSlot(24).m_41619_() && inventoryIn.getStackInSlot(25).m_41619_() && inventoryIn.getStackInSlot(26).m_41619_() && inventoryIn.getStackInSlot(27).m_41619_() && inventoryIn.getStackInSlot(28).m_41619_() && inventoryIn.getStackInSlot(29).m_41619_() && inventoryIn.getStackInSlot(30).m_41619_() && inventoryIn.getStackInSlot(31).m_41619_() && inventoryIn.getStackInSlot(32).m_41619_() && inventoryIn.getStackInSlot(33).m_41619_() && inventoryIn.getStackInSlot(34).m_41619_() && inventoryIn.getStackInSlot(35).m_41619_() && inventoryIn.getStackInSlot(36).m_41619_())) {
            hasItems = true;
        }
        return hasItems;
    }

    public void dropInventoryContentsStorageSlot7() {
        if (this.inventory.getStackInSlot(this.ItemslotStorage2).m_41619_() && this.areItemsInStorageSlot7Range(this.inventory)) {
            SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
            for (int i = 37; i <= 63; ++i) {
                inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
        }
    }

    private boolean areItemsInStorageSlot7Range(ItemStackHandler inventoryIn) {
        boolean hasItems = false;
        if (!(inventoryIn.getStackInSlot(37).m_41619_() && inventoryIn.getStackInSlot(38).m_41619_() && inventoryIn.getStackInSlot(39).m_41619_() && inventoryIn.getStackInSlot(40).m_41619_() && inventoryIn.getStackInSlot(41).m_41619_() && inventoryIn.getStackInSlot(42).m_41619_() && inventoryIn.getStackInSlot(43).m_41619_() && inventoryIn.getStackInSlot(44).m_41619_() && inventoryIn.getStackInSlot(45).m_41619_() && inventoryIn.getStackInSlot(46).m_41619_() && inventoryIn.getStackInSlot(47).m_41619_() && inventoryIn.getStackInSlot(48).m_41619_() && inventoryIn.getStackInSlot(49).m_41619_() && inventoryIn.getStackInSlot(50).m_41619_() && inventoryIn.getStackInSlot(51).m_41619_() && inventoryIn.getStackInSlot(52).m_41619_() && inventoryIn.getStackInSlot(53).m_41619_() && inventoryIn.getStackInSlot(54).m_41619_() && inventoryIn.getStackInSlot(55).m_41619_() && inventoryIn.getStackInSlot(56).m_41619_() && inventoryIn.getStackInSlot(57).m_41619_() && inventoryIn.getStackInSlot(58).m_41619_() && inventoryIn.getStackInSlot(59).m_41619_() && inventoryIn.getStackInSlot(60).m_41619_() && inventoryIn.getStackInSlot(61).m_41619_() && inventoryIn.getStackInSlot(62).m_41619_() && inventoryIn.getStackInSlot(63).m_41619_())) {
            hasItems = true;
        }
        return hasItems;
    }

    public void dropInventoryContentsStorageSlot8() {
        if (this.inventory.getStackInSlot(this.ItemslotStorage3).m_41619_() && this.areItemsInStorageSlot8Range(this.inventory)) {
            SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
            for (int i = 64; i <= 90; ++i) {
                inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
        }
    }

    private boolean areItemsInStorageSlot8Range(ItemStackHandler inventoryIn) {
        boolean hasItems = false;
        if (!(inventoryIn.getStackInSlot(64).m_41619_() && inventoryIn.getStackInSlot(65).m_41619_() && inventoryIn.getStackInSlot(66).m_41619_() && inventoryIn.getStackInSlot(67).m_41619_() && inventoryIn.getStackInSlot(68).m_41619_() && inventoryIn.getStackInSlot(69).m_41619_() && inventoryIn.getStackInSlot(70).m_41619_() && inventoryIn.getStackInSlot(71).m_41619_() && inventoryIn.getStackInSlot(72).m_41619_() && inventoryIn.getStackInSlot(73).m_41619_() && inventoryIn.getStackInSlot(74).m_41619_() && inventoryIn.getStackInSlot(75).m_41619_() && inventoryIn.getStackInSlot(76).m_41619_() && inventoryIn.getStackInSlot(77).m_41619_() && inventoryIn.getStackInSlot(78).m_41619_() && inventoryIn.getStackInSlot(79).m_41619_() && inventoryIn.getStackInSlot(80).m_41619_() && inventoryIn.getStackInSlot(81).m_41619_() && inventoryIn.getStackInSlot(82).m_41619_() && inventoryIn.getStackInSlot(83).m_41619_() && inventoryIn.getStackInSlot(84).m_41619_() && inventoryIn.getStackInSlot(85).m_41619_() && inventoryIn.getStackInSlot(86).m_41619_() && inventoryIn.getStackInSlot(87).m_41619_() && inventoryIn.getStackInSlot(88).m_41619_() && inventoryIn.getStackInSlot(89).m_41619_() && inventoryIn.getStackInSlot(90).m_41619_())) {
            hasItems = true;
        }
        return hasItems;
    }

    public void dropInventoryContentsStorageSlot9() {
        if (this.inventory.getStackInSlot(this.ItemslotStorage4).m_41619_() && this.areItemsInStorageSlot9Range(this.inventory)) {
            SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
            for (int i = 91; i <= 117; ++i) {
                inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
        }
    }

    private boolean areItemsInStorageSlot9Range(ItemStackHandler inventoryIn) {
        boolean hasItems = false;
        if (!(inventoryIn.getStackInSlot(91).m_41619_() && inventoryIn.getStackInSlot(92).m_41619_() && inventoryIn.getStackInSlot(93).m_41619_() && inventoryIn.getStackInSlot(94).m_41619_() && inventoryIn.getStackInSlot(95).m_41619_() && inventoryIn.getStackInSlot(96).m_41619_() && inventoryIn.getStackInSlot(97).m_41619_() && inventoryIn.getStackInSlot(98).m_41619_() && inventoryIn.getStackInSlot(99).m_41619_() && inventoryIn.getStackInSlot(100).m_41619_() && inventoryIn.getStackInSlot(101).m_41619_() && inventoryIn.getStackInSlot(102).m_41619_() && inventoryIn.getStackInSlot(103).m_41619_() && inventoryIn.getStackInSlot(104).m_41619_() && inventoryIn.getStackInSlot(105).m_41619_() && inventoryIn.getStackInSlot(106).m_41619_() && inventoryIn.getStackInSlot(107).m_41619_() && inventoryIn.getStackInSlot(108).m_41619_() && inventoryIn.getStackInSlot(109).m_41619_() && inventoryIn.getStackInSlot(110).m_41619_() && inventoryIn.getStackInSlot(111).m_41619_() && inventoryIn.getStackInSlot(112).m_41619_() && inventoryIn.getStackInSlot(113).m_41619_() && inventoryIn.getStackInSlot(114).m_41619_() && inventoryIn.getStackInSlot(115).m_41619_() && inventoryIn.getStackInSlot(116).m_41619_() && inventoryIn.getStackInSlot(117).m_41619_())) {
            hasItems = true;
        }
        return hasItems;
    }

    public void IsItemStackInSlot0() {
        if (!this.inventory.getStackInSlot(this.ItemslotFuel).m_41619_()) {
            this.setStatusItemStackInSlot0(this.inventory.getStackInSlot(this.ItemslotFuel));
        } else {
            this.setStatusItemStackInSlot0(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot1() {
        if (!this.inventory.getStackInSlot(this.ItemslotIgnitionKey).m_41619_()) {
            this.setStatusItemStackInSlot1(this.inventory.getStackInSlot(this.ItemslotIgnitionKey));
        } else {
            this.setStatusItemStackInSlot1(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot2() {
        if (!this.inventory.getStackInSlot(this.ItemslotRecord).m_41619_()) {
            this.setStatusItemStackInSlot2(this.inventory.getStackInSlot(this.ItemslotRecord));
        } else {
            this.setStatusItemStackInSlot2(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot3() {
        if (!this.inventory.getStackInSlot(this.ItemslotPatreon).m_41619_()) {
            this.setStatusItemStackInSlot3(this.inventory.getStackInSlot(this.ItemslotPatreon));
        } else {
            this.setStatusItemStackInSlot3(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot4() {
        if (!this.inventory.getStackInSlot(this.ItemslotInstruction).m_41619_()) {
            this.setStatusItemStackInSlot4(this.inventory.getStackInSlot(this.ItemslotInstruction));
        } else {
            this.setStatusItemStackInSlot4(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot5() {
        if (!this.inventory.getStackInSlot(this.ItemslotUpgrade).m_41619_()) {
            this.setStatusItemStackInSlot5(this.inventory.getStackInSlot(this.ItemslotUpgrade));
        } else {
            this.setStatusItemStackInSlot5(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot6() {
        if (!this.inventory.getStackInSlot(this.ItemslotStorage1).m_41619_()) {
            this.setStatusItemStackInSlot6(this.inventory.getStackInSlot(this.ItemslotStorage1));
        } else {
            this.setStatusItemStackInSlot6(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot7() {
        if (!this.inventory.getStackInSlot(this.ItemslotStorage2).m_41619_()) {
            this.setStatusItemStackInSlot7(this.inventory.getStackInSlot(this.ItemslotStorage2));
        } else {
            this.setStatusItemStackInSlot7(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot8() {
        if (!this.inventory.getStackInSlot(this.ItemslotStorage3).m_41619_()) {
            this.setStatusItemStackInSlot8(this.inventory.getStackInSlot(this.ItemslotStorage3));
        } else {
            this.setStatusItemStackInSlot8(ItemStack.f_41583_);
        }
    }

    public void IsItemStackInSlot9() {
        if (!this.inventory.getStackInSlot(this.ItemslotStorage4).m_41619_()) {
            this.setStatusItemStackInSlot9(this.inventory.getStackInSlot(this.ItemslotStorage4));
        } else {
            this.setStatusItemStackInSlot9(ItemStack.f_41583_);
        }
    }

    public void UpdateMachineTypeFromSlot4() {
        int machinetypefromslot4 = MachineType.NONE.ordinal();
        if (!this.getStatusItemStackInSlot4().m_41619_()) {
            for (MachineType type : MachineType.values()) {
                if (!this.getStatusItemStackInSlot4().m_41720_().toString().contains(type.getName())) continue;
                machinetypefromslot4 = type.ordinal();
            }
        }
        this.setStatusMachineType(machinetypefromslot4);
    }

    public void UpdateUpgradeTypeFromSlot5() {
        int upgradetypefromslot5 = MachineUpgrade.NONE.ordinal();
        if (!this.getStatusItemStackInSlot5().m_41619_()) {
            for (MachineUpgrade type : MachineUpgrade.values()) {
                if (!this.getStatusItemStackInSlot5().m_41720_().toString().contains(type.getName())) continue;
                upgradetypefromslot5 = type.ordinal();
            }
        }
        this.setStatusUpgradeTier(upgradetypefromslot5);
    }

    protected float ReducedSpeedMultiplier() {
        float adjustedspeed = 1.0f;
        if (!(this.getStatusMachineType() == MachineType.HAULER.ordinal() || this.getStatusItemStackInSlot6().m_41619_() && this.getStatusItemStackInSlot7().m_41619_() && this.getStatusItemStackInSlot8().m_41619_() && this.getStatusItemStackInSlot9().m_41619_())) {
            adjustedspeed = 0.75f;
        }
        return adjustedspeed;
    }

    public MachineType GetTEMPMachineType() {
        return MachineType.NONE;
    }
}

