/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IEquipmentChangeListener;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PostmanHatItem
extends AbstractHatItem
implements IEquipmentChangeListener,
IUsefulHatModelOwner {
    private static final int HUNGER_AMPLIFIER = 0;
    private static final int HUNGER_DURATION = 219;
    private static final int SPEED_DURATION = 219;

    public PostmanHatItem() {
        super(HatArmorMaterial.POSTMAN, PostmanHatItem.rawColorFromRGB(57, 99, 150), ServerConfig.POSTMAN_HAT_DAMAGE_ENABLED);
        this.addAllowedEnchantment(Enchantments.f_44984_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int enchantmentLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44984_, (ItemStack)stack) + 1;
        tooltip.add((Component)Component.m_237110_((String)"item.usefulhats.postman_hat.desc.speed", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(enchantmentLevel, false)}).m_130940_(ChatFormatting.BLUE));
        if (((Boolean)ServerConfig.POSTMAN_HAT_HUNGER_ENABLED.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.postman_hat.desc.hunger").m_130940_(ChatFormatting.RED));
        }
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            if (!UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            int speedAmplifier = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44984_, (ItemStack)stack);
            if (this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19596_, 219, speedAmplifier)) {
                return;
            }
            if (player.m_20142_()) {
                if (player.m_21124_(MobEffects.f_19596_) == null || player.f_19797_ % 19 == 0) {
                    this.addEffect((LivingEntity)player, MobEffects.f_19596_, 219, speedAmplifier);
                }
                if (((Boolean)ServerConfig.POSTMAN_HAT_HUNGER_ENABLED.get()).booleanValue() && !this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19612_, 219, 0) && (player.m_21124_(MobEffects.f_19612_) == null || player.f_19797_ % 19 == 0)) {
                    this.addEffect((LivingEntity)player, MobEffects.f_19612_, 219, 0);
                }
                if (level.f_46441_.m_188503_(20) == 0) {
                    this.damageHatItemByOne(stack, player);
                }
            } else {
                this.removeEffect((LivingEntity)player, MobEffects.f_19596_, 219, speedAmplifier);
                if (((Boolean)ServerConfig.POSTMAN_HAT_HUNGER_ENABLED.get()).booleanValue()) {
                    this.removeEffect((LivingEntity)player, MobEffects.f_19612_, 219, 0);
                }
            }
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        int speedAmplifier = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44984_, (ItemStack)oldStack);
        this.removeEffect(entity, MobEffects.f_19596_, 219, speedAmplifier);
        if (((Boolean)ServerConfig.POSTMAN_HAT_HUNGER_ENABLED.get()).booleanValue()) {
            this.removeEffect(entity, MobEffects.f_19612_, 219, 0);
        }
    }
}

