/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.compat.LucentMod;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.init.ModItems;
import cech12.usefulhats.item.AbstractMiningHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IEquipmentChangeListener;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;

public class MiningHatItem
extends AbstractMiningHatItem
implements IEquipmentChangeListener,
IUsefulHatModelOwner {
    private static final int NIGHT_VISION_DURATION = 239;
    private static final int NIGHT_VISION_AMPLIFIER = 0;

    public MiningHatItem() {
        super(HatArmorMaterial.MINING, MiningHatItem.rawColorFromRGB(255, 216, 0), ServerConfig.MINING_HAT_DAMAGE_ENABLED);
    }

    public static boolean isLightEnabled(Player player) {
        return (Boolean)ServerConfig.MINING_HAT_NIGHT_VISION_ENABLED.get() != false && UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).stream().anyMatch(stack -> stack.m_41720_() == ModItems.MINING_HAT.get()) && StreamSupport.stream(player.m_6167_().spliterator(), false).anyMatch(stack -> stack.canPerformAction(ToolActions.PICKAXE_DIG)) && player.m_21124_(MobEffects.f_19611_) == null && player.f_19853_.m_46803_(player.m_20183_()) < 8;
    }

    @Override
    protected double[] getSpeedConfig() {
        double[] speedConfig = new double[]{(Double)ServerConfig.MINING_HAT_SPEED_WITH_EFFICIENCY_0.get(), (Double)ServerConfig.MINING_HAT_SPEED_WITH_EFFICIENCY_1.get(), (Double)ServerConfig.MINING_HAT_SPEED_WITH_EFFICIENCY_2.get(), (Double)ServerConfig.MINING_HAT_SPEED_WITH_EFFICIENCY_3.get(), (Double)ServerConfig.MINING_HAT_SPEED_WITH_EFFICIENCY_4.get(), (Double)ServerConfig.MINING_HAT_SPEED_WITH_EFFICIENCY_5.get()};
        return speedConfig;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int value = (int)(this.getEnchantmentValue(stack, this.getSpeedConfig()) * 100.0);
        tooltip.add((Component)Component.m_237110_((String)"item.usefulhats.mining_hat.desc.mining_speed", (Object[])new Object[]{value}).m_130940_(ChatFormatting.BLUE));
        if (((Boolean)ServerConfig.MINING_HAT_NIGHT_VISION_ENABLED.get()).booleanValue()) {
            if (LucentMod.isLoaded()) {
                tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.mining_hat.desc.lucent").m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.mining_hat.desc.night_vision").m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            if (!UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            if (!((Boolean)ServerConfig.MINING_HAT_NIGHT_VISION_ENABLED.get()).booleanValue()) {
                return;
            }
            if (LucentMod.isLoaded()) {
                if (MiningHatItem.isLightEnabled(player) && player.f_19797_ % 20 == 0) {
                    this.damageHatItemByOne(stack, player);
                }
                return;
            }
            if (this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19611_, 239, 0)) {
                return;
            }
            if (StreamSupport.stream(player.m_6167_().spliterator(), false).anyMatch(handStack -> handStack.canPerformAction(ToolActions.PICKAXE_DIG)) && player.f_19853_.m_46803_(player.m_20183_()) < 8) {
                if (player.m_21124_(MobEffects.f_19611_) == null || player.f_19797_ % 19 == 0) {
                    this.addEffect((LivingEntity)player, MobEffects.f_19611_, 239, 0);
                }
                if (player.f_19797_ % 20 == 0) {
                    this.damageHatItemByOne(stack, player);
                }
            } else {
                player.m_21195_(MobEffects.f_19611_);
            }
        }
    }

    @Override
    protected boolean isToolEffective(ItemStack tool, BlockState state) {
        return tool.canPerformAction(ToolActions.PICKAXE_DIG) && state.m_204336_(BlockTags.f_144282_);
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        this.removeEffect(entity, MobEffects.f_19611_, 239, 0);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return (Boolean)ServerConfig.MINING_HAT_MAKE_PIGLINS_NEUTRAL_ENABLED.get();
    }
}

