/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IAttackTargetChanger;
import cech12.usefulhats.item.IEquipmentChangeListener;
import cech12.usefulhats.item.IMobEntityChanger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;

public class HaloItem
extends AbstractHatItem
implements IAttackTargetChanger,
IMobEntityChanger,
IEquipmentChangeListener {
    private static final Map<Player, Integer> PREVIOUS_DAMAGE_TICK_OF_PLAYER = new HashMap<Player, Integer>();

    public HaloItem() {
        super(HatArmorMaterial.HALO, HaloItem.rawColorFromRGB(255, 236, 142), ServerConfig.HALO_DAMAGE_ENABLED);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.halo.desc.no_attack").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.halo.desc.beware_of_nether").m_130940_(ChatFormatting.RED));
    }

    private static boolean isEntityInNether(Entity entity) {
        return entity.f_19853_.m_6042_().f_63863_();
    }

    @Override
    public void onEntityJoinWorldEvent(Mob entity, EntityJoinLevelEvent event) {
        if (entity instanceof ZombifiedPiglin) {
            entity.f_21346_.m_25352_(1, (Goal)new NearestHaloTargetGoal(entity, this));
        }
    }

    @Override
    public boolean avoidMobChangingTarget(ItemStack stack, Mob mob, Player targetPlayer) {
        Integer previousDamageTick;
        if (mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || HaloItem.isEntityInNether((Entity)targetPlayer)) {
            return false;
        }
        if (((Boolean)this.enabledDamageConfig.get()).booleanValue() && ((previousDamageTick = PREVIOUS_DAMAGE_TICK_OF_PLAYER.get(targetPlayer)) == null || previousDamageTick + 20 <= targetPlayer.f_19797_)) {
            this.damageHatItemByOne(stack, targetPlayer);
            PREVIOUS_DAMAGE_TICK_OF_PLAYER.put(targetPlayer, targetPlayer.f_19797_);
        }
        return true;
    }

    @Override
    public void onEquippedHatItem(LivingEntity entity, ItemStack newStack) {
        if (HaloItem.isEntityInNether((Entity)entity)) {
            return;
        }
        Vec3 playerPos = entity.m_20182_();
        int range = 32;
        AABB radius = new AABB(playerPos.m_7096_() - (double)range, playerPos.m_7098_() - (double)range, playerPos.m_7094_() - (double)range, playerPos.m_7096_() + (double)range, playerPos.m_7098_() + (double)range, playerPos.m_7094_() + (double)range);
        entity.f_19853_.m_6443_(Mob.class, radius, mob -> mob.m_5448_() == entity && !mob.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)).forEach(mob -> mob.m_6710_(null));
    }

    private static class NearestHaloTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        NearestHaloTargetGoal(Mob mobEntity, IMobEntityChanger hatItem) {
            super(mobEntity, Player.class, 0, true, false, entity -> {
                if (entity instanceof Player && HaloItem.isEntityInNether((Entity)entity)) {
                    for (ItemStack headSlotItemStack : UsefulHatsUtils.getEquippedHatItemStacks(entity)) {
                        if (headSlotItemStack.m_41720_() != hatItem) continue;
                        return true;
                    }
                }
                return false;
            });
        }
    }
}

