/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IEquipmentChangeListener;
import cech12.usefulhats.item.IItemUseListener;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;

public class BunnyEarsItem
extends AbstractHatItem
implements IEquipmentChangeListener,
IItemUseListener,
IUsefulHatModelOwner {
    private static final int JUMP_BOOST_DURATION = 219;

    public BunnyEarsItem() {
        super(HatArmorMaterial.BUNNY, BunnyEarsItem.rawColorFromRGB(142, 120, 94), ServerConfig.BUNNY_EARS_DAMAGE_ENABLED);
        this.addAllowedEnchantment(Enchantments.f_44984_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int enchantmentLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44984_, (ItemStack)stack) + 1;
        tooltip.add((Component)Component.m_237110_((String)"item.usefulhats.bunny_ears.desc.jump_boost", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(enchantmentLevel, false)}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"item.usefulhats.bunny_ears.desc.eating", (Object[])new Object[]{enchantmentLevel + 1}).m_130940_(ChatFormatting.BLUE));
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            if (!UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            int amplifier = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44984_, (ItemStack)stack);
            if (!this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19603_, 219, amplifier)) {
                if (player.m_21124_(MobEffects.f_19603_) == null || player.f_19797_ % 19 == 0) {
                    this.addEffect((LivingEntity)player, MobEffects.f_19603_, 219, amplifier);
                }
                if (level.f_46441_.m_188503_(20) == 0) {
                    this.damageHatItemByOne(stack, player);
                }
            }
        }
    }

    @Override
    public void onItemUseEvent(LivingEntityUseItemEvent event, Player player, ItemStack headSlotItemStack) {
        ItemStack usedStack;
        if (event instanceof LivingEntityUseItemEvent.Start && (usedStack = event.getItem()).m_41720_().m_41472_()) {
            int amplifier = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44984_, (ItemStack)headSlotItemStack) + 2;
            event.setDuration(event.getDuration() / amplifier);
            this.damageHatItemByOne(headSlotItemStack, player);
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        int amplifier = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44984_, (ItemStack)oldStack);
        this.removeEffect(entity, MobEffects.f_19603_, 219, amplifier);
    }
}

