/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IBreakSpeedChanger;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;

public abstract class AbstractMiningHatItem
extends AbstractHatItem
implements IBreakSpeedChanger {
    AbstractMiningHatItem(HatArmorMaterial material, int initColor, ForgeConfigSpec.BooleanValue enabledDamageConfig) {
        super(material, initColor, enabledDamageConfig);
        this.addAllowedEnchantment(Enchantments.f_44984_);
    }

    protected double getEnchantmentValue(ItemStack stack, double[] speedConfig) {
        if (speedConfig == null || speedConfig.length == 0) {
            return 0.0;
        }
        int enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)stack);
        if (enchantmentLevel >= speedConfig.length) {
            return speedConfig[speedConfig.length - 1];
        }
        if (enchantmentLevel < 0) {
            return speedConfig[0];
        }
        return speedConfig[enchantmentLevel];
    }

    protected abstract double[] getSpeedConfig();

    protected abstract boolean isToolEffective(ItemStack var1, BlockState var2);

    @Override
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed event, ItemStack headSlotItemStack) {
        if (!event.isCanceled() && this.isToolEffective(event.getEntity().m_21205_(), event.getState())) {
            event.setNewSpeed((1.0f + (float)this.getEnchantmentValue(headSlotItemStack, this.getSpeedConfig())) * event.getNewSpeed());
        }
    }

    @Override
    public void onBreakEvent(BlockEvent.BreakEvent event, ItemStack headSlotItemStack) {
        if (!event.isCanceled() && this.isToolEffective(event.getPlayer().m_21205_(), event.getState())) {
            this.damageHatItemByOne(headSlotItemStack, event.getPlayer());
        }
    }
}

