/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.client;

import cech12.usefulhats.client.UsefulHatLayers;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CurioRenderer
implements ICurioRenderer {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private static CurioRenderer instance;
    private HumanoidModel<LivingEntity> model;

    private CurioRenderer() {
    }

    public static CurioRenderer getInstance() {
        if (instance == null) {
            instance = new CurioRenderer();
        }
        return instance;
    }

    @OnlyIn(value=Dist.CLIENT)
    private HumanoidModel<LivingEntity> getModel(ItemStack stack) {
        if (stack.m_41720_() instanceof IUsefulHatModelOwner) {
            return UsefulHatLayers.usefulHatModel;
        }
        if (this.model == null) {
            this.model = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_));
        }
        return this.model;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation getTexture(ItemStack stack, String type) {
        String locationString;
        ArmorItem item = (ArmorItem)stack.m_41720_();
        if (item instanceof IUsefulHatModelOwner) {
            locationString = item.getArmorTexture(stack, stack.m_41609_(), stack.getEquipmentSlot(), type);
        } else {
            String texture = item.m_40401_().m_6082_();
            String domain = "minecraft";
            int idx = texture.indexOf(58);
            if (idx != -1) {
                domain = texture.substring(0, idx);
                texture = texture.substring(idx + 1);
            }
            locationString = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        }
        ResourceLocation location = ARMOR_TEXTURE_RES_MAP.get(locationString);
        if (location == null && locationString != null) {
            location = new ResourceLocation(locationString);
            ARMOR_TEXTURE_RES_MAP.put(locationString, location);
        }
        return location;
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item = stack.m_41720_();
        HumanoidModel<LivingEntity> model = this.getModel(stack);
        model.m_6973_(slotContext.entity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.m_6839_(slotContext.entity(), limbSwing, limbSwingAmount, partialTicks);
        ICurioRenderer.followBodyRotations((LivingEntity)slotContext.entity(), (HumanoidModel[])new HumanoidModel[]{model});
        model.m_102872_(model);
        boolean flag1 = stack.m_41790_();
        int i = ((DyeableLeatherItem)item).m_41121_(stack);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        this.renderLayer(matrixStack, renderTypeBuffer, light, flag1, model, f, f1, f2, this.getTexture(stack, null));
        this.renderLayer(matrixStack, renderTypeBuffer, light, flag1, model, 1.0f, 1.0f, 1.0f, this.getTexture(stack, "overlay"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderLayer(PoseStack p_241738_1_, MultiBufferSource p_241738_2_, int p_241738_3_, boolean p_241738_5_, HumanoidModel<LivingEntity> p_241738_6_, float p_241738_8_, float p_241738_9_, float p_241738_10_, ResourceLocation armorResource) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)p_241738_2_, (RenderType)p_241738_6_.m_103119_(armorResource), (boolean)false, (boolean)p_241738_5_);
        p_241738_6_.m_7695_(p_241738_1_, ivertexbuilder, p_241738_3_, OverlayTexture.f_118083_, p_241738_8_, p_241738_9_, p_241738_10_, 1.0f);
    }
}

