/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.handlers.PlayerFallDistanceUpdateHandler;
import com.rolfmao.upgradednetherite.init.UpgradedNetheriteEffects;
import com.rolfmao.upgradednetherite.utils.DurabilityUtil;
import com.rolfmao.upgradednetherite.utils.EntityDataUtil;
import com.rolfmao.upgradednetherite.utils.check.CorruptUtil;
import com.rolfmao.upgradednetherite.utils.check.EchoUtil;
import com.rolfmao.upgradednetherite.utils.check.EnderUtil;
import com.rolfmao.upgradednetherite.utils.check.FeatherUtil;
import com.rolfmao.upgradednetherite.utils.check.FireUtil;
import com.rolfmao.upgradednetherite.utils.check.GoldUtil;
import com.rolfmao.upgradednetherite.utils.check.PhantomUtil;
import com.rolfmao.upgradednetherite.utils.check.PoisonUtil;
import com.rolfmao.upgradednetherite.utils.check.WaterUtil;
import com.rolfmao.upgradednetherite.utils.check.WitherUtil;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorEventHandler {
    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (WitherUtil.isWearingWitherArmor(player) && UpgradedNetheriteConfig.EnableWitherImmune && player.m_21023_(MobEffects.f_19615_)) {
                player.m_21195_(MobEffects.f_19615_);
                DurabilityUtil.WitherDurabilityLoss(player);
            }
            if (PoisonUtil.isWearingPoisonArmor(player) && UpgradedNetheriteConfig.EnablePoisonImmune && player.m_21023_(MobEffects.f_19614_)) {
                player.m_21195_(MobEffects.f_19614_);
                DurabilityUtil.PoisonDurabilityLoss(player);
            }
            if (FeatherUtil.isWearingFeatherArmor(player) && UpgradedNetheriteConfig.EnableLevitationImmune && player.m_21023_(MobEffects.f_19620_)) {
                player.m_21195_(MobEffects.f_19620_);
                DurabilityUtil.FeatherDurabilityLoss(player);
            }
            if (UpgradedNetheriteConfig.EnableHealthMalus) {
                if (CorruptUtil.intWearingCorrupt(player, false) > 0 && EntityDataUtil.getCorrupterite((Entity)player) < CorruptUtil.intWearingCorrupt(player, false)) {
                    EntityDataUtil.setCorrupterite((Entity)player, CorruptUtil.intWearingCorrupt(player, false));
                }
                if (CorruptUtil.intWearingCorrupt(player, false) >= 0 && EntityDataUtil.getCorrupterite((Entity)player) > CorruptUtil.intWearingCorrupt(player, false) + EntityDataUtil.getMalusCorruption((Entity)player)) {
                    EntityDataUtil.setMalusCorruption((Entity)player, EntityDataUtil.getCorrupterite((Entity)player) - CorruptUtil.intWearingCorrupt(player, false));
                    player.m_7292_(new MobEffectInstance((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get(), 12000, EntityDataUtil.getMalusCorruption((Entity)player) - 1, false, true, true));
                } else if (CorruptUtil.intWearingCorrupt(player, false) + EntityDataUtil.getMalusCorruption((Entity)player) > EntityDataUtil.getCorrupterite((Entity)player) && player.m_21023_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                    Integer time = 0;
                    time = player.m_21124_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get()).m_19557_();
                    player.m_21195_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get());
                    EntityDataUtil.setMalusCorruption((Entity)player, EntityDataUtil.getCorrupterite((Entity)player) - CorruptUtil.intWearingCorrupt(player, false));
                    if (CorruptUtil.intWearingCorrupt(player, false) != 4) {
                        player.m_7292_(new MobEffectInstance((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get(), time.intValue(), EntityDataUtil.getMalusCorruption((Entity)player) - 1, false, true, true));
                    }
                }
            } else {
                EntityDataUtil.setCorrupterite((Entity)player, 0);
                EntityDataUtil.setMalusCorruption((Entity)player, 0);
                if (player.m_21023_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                    player.m_21195_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get());
                }
            }
        }
    }

    public static boolean enderSaveVoid(Player player) {
        Level level = player.f_19853_;
        if (!EntityDataUtil.hasEnderTeleportCooldown(player)) {
            if (EntityDataUtil.getAbilityEnderPos((Entity)player) != null) {
                BlockPos blockpos = EntityDataUtil.getAbilityEnderPos((Entity)player);
                ArrayList<BlockPos> validTpList = new ArrayList<BlockPos>();
                if (level.m_8055_(blockpos.m_7495_()).m_60767_().m_76334_() && (player.f_19853_.m_6425_(blockpos).m_76178_() || player.f_19853_.m_8055_(blockpos).m_60713_(Blocks.f_50628_)) && player.f_19853_.m_8055_(blockpos).m_60647_((BlockGetter)player.f_19853_, blockpos, PathComputationType.LAND) && (player.f_19853_.m_6425_(blockpos.m_7494_()).m_76178_() || player.f_19853_.m_8055_(blockpos.m_7494_()).m_60713_(Blocks.f_50628_)) && player.f_19853_.m_8055_(blockpos.m_7494_()).m_60647_((BlockGetter)player.f_19853_, blockpos.m_7494_(), PathComputationType.LAND)) {
                    validTpList.add(blockpos.m_7949_());
                }
                if (validTpList.size() <= 0) {
                    for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)blockpos.m_7918_(-5, -5, -5), (BlockPos)blockpos.m_7918_(5, 5, 5))) {
                        if (!level.m_8055_(blockpos1.m_7495_()).m_60767_().m_76334_() || !player.f_19853_.m_6425_(blockpos1).m_76178_() && !player.f_19853_.m_8055_(blockpos1).m_60713_(Blocks.f_50628_) || !player.f_19853_.m_8055_(blockpos1).m_60647_((BlockGetter)player.f_19853_, blockpos1, PathComputationType.LAND) || !player.f_19853_.m_6425_(blockpos1.m_7494_()).m_76178_() && !player.f_19853_.m_8055_(blockpos1.m_7494_()).m_60713_(Blocks.f_50628_) || !player.f_19853_.m_8055_(blockpos1.m_7494_()).m_60647_((BlockGetter)player.f_19853_, blockpos1.m_7494_(), PathComputationType.LAND)) continue;
                        validTpList.add(blockpos1.m_7949_());
                    }
                }
                if (validTpList.size() > 0) {
                    player.m_8127_();
                    player.f_19789_ = 0.0f;
                    Integer IRNG = player.m_217043_().m_188503_(validTpList.size());
                    player.m_6021_((double)((BlockPos)validTpList.get(IRNG)).m_123341_() + 0.5, (double)((BlockPos)validTpList.get(IRNG)).m_123342_(), (double)((BlockPos)validTpList.get(IRNG)).m_123343_() + 0.5);
                    player.getPersistentData().m_128405_("upgraded_netherite_ender_teleport_cd", 20);
                    SoundEvent soundevent = SoundEvents.f_11852_;
                    player.f_19853_.m_6263_(null, (double)((BlockPos)validTpList.get(IRNG)).m_123341_() + 0.5, (double)((BlockPos)validTpList.get(IRNG)).m_123342_(), (double)((BlockPos)validTpList.get(IRNG)).m_123343_() + 0.5, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_5496_(soundevent, 1.0f, 1.0f);
                    for (int i = 0; i < 32; ++i) {
                        player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)((BlockPos)validTpList.get(IRNG)).m_123341_() + 0.5, (double)((BlockPos)validTpList.get(IRNG)).m_123342_() + player.m_217043_().m_188500_() * 2.0, (double)((BlockPos)validTpList.get(IRNG)).m_123343_() + 0.5, player.m_217043_().m_188583_(), 0.0, player.m_217043_().m_188583_());
                    }
                    return true;
                }
            } else {
                if (!level.m_8055_(new BlockPos(100, 48, 0)).m_60767_().m_76334_()) {
                    level.m_46597_(new BlockPos(100, 48, 0), Blocks.f_50080_.m_49966_());
                }
                if (level.m_8055_(new BlockPos(100, 49, 0)) != Blocks.f_50016_.m_49966_()) {
                    level.m_46597_(new BlockPos(100, 49, 0), Blocks.f_50016_.m_49966_());
                }
                if (level.m_8055_(new BlockPos(100, 50, 0)) != Blocks.f_50016_.m_49966_()) {
                    level.m_46597_(new BlockPos(100, 50, 0), Blocks.f_50016_.m_49966_());
                }
                player.m_8127_();
                player.f_19789_ = 0.0f;
                player.m_6021_(100.5, 49.0, 0.5);
                player.getPersistentData().m_128405_("upgraded_netherite_ender_teleport_cd", 20);
                SoundEvent soundevent = SoundEvents.f_11852_;
                player.f_19853_.m_6263_(null, 100.5, 49.0, 0.5, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_5496_(soundevent, 1.0f, 1.0f);
                for (int i = 0; i < 32; ++i) {
                    player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, 100.5, 49.0 + player.m_217043_().m_188500_() * 2.0, 0.5, player.m_217043_().m_188583_(), 0.0, player.m_217043_().m_188583_());
                }
                return true;
            }
        }
        return false;
    }

    public static void enderBreakArmor(Player player) {
        Iterable armorList = player.m_6168_();
        if (UpgradedNetheriteConfig.EnableBreakEnderArmor) {
            for (ItemStack stack : armorList) {
                if (stack.m_41619_() || !EnderUtil.isEnderArmor(stack)) continue;
                stack.m_41622_(stack.m_41776_() - stack.m_41773_(), (LivingEntity)player, e -> e.m_21166_(((ArmorItem)stack.m_41720_()).m_40402_()));
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onDamageEntity(LivingHurtEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Player && "sonic_boom".equals(event.getSource().f_19326_) && EchoUtil.isWearingEchoArmor((Player)event.getEntity()) && UpgradedNetheriteConfig.EnableReduceDamageEchoArmor) {
            float reduceDamage = UpgradedNetheriteConfig.ReduceDamageEchoArmor;
            event.setAmount(event.getAmount() - event.getAmount() * Math.min(1.0f, reduceDamage / 100.0f));
        }
    }

    private Multimap<Attribute, AttributeModifier> SwimAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(UUID.fromString("fbfd69fe-3369-11eb-adc1-0242ac120002"), "upgradednetherite:swim_bonus", 1.1, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> HealthAttributeMap(Integer mult) {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("7d87fb9e-d0ca-4bdd-8d00-384044b3417b"), "upgradednetherite:health_malus", (double)UpgradedNetheriteConfig.HealthMalus * -0.01 * (double)mult.intValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributesDefault;
    }

    private Multimap<Attribute, AttributeModifier> LuckAttributeMap() {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.fromString("33ca3756-9ea8-41d0-898c-d93352065fbb"), "upgradednetherite:luck_bonus", (double)UpgradedNetheriteConfig.LuckBonus, AttributeModifier.Operation.ADDITION));
        return attributesDefault;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            BlockPos blockpos = player.m_20183_().m_7495_();
            BlockState blockstate = player.f_19853_.m_8055_(blockpos);
            if (blockstate.m_60767_().m_76334_()) {
                EntityDataUtil.setAbilityEnderPos((Entity)player, true);
            }
            if (GoldUtil.isWearingGoldArmor(player) && UpgradedNetheriteConfig.EnableLuckBonus) {
                player.m_21204_().m_22178_(this.LuckAttributeMap());
            } else if (!GoldUtil.isWearingGoldArmor(player)) {
                player.m_21204_().m_22161_(this.LuckAttributeMap());
            }
            if (FeatherUtil.isWearingFeatherArmor(player) && (player.f_19853_.m_6425_(player.m_20183_()).m_205070_(FluidTags.f_13132_) || player.f_19853_.m_6425_(player.m_20183_()).m_205070_(FluidTags.f_13131_)) && !player.m_6047_() && !player.m_6069_() && !player.m_21255_() && UpgradedNetheriteConfig.EnableWaterLavaWalking && !player.m_150110_().f_35935_) {
                if (player.m_20069_() || player.m_20077_()) {
                    if (!WaterUtil.isWearingWaterArmor(player) && player.m_20184_().f_82480_ < 0.226 && player.m_20184_().f_82480_ > 0.11 && (player.m_204029_(FluidTags.f_13132_) || player.m_204029_(FluidTags.f_13131_)) && player.f_19853_.f_46443_ && player instanceof LocalPlayer && ((LocalPlayer)player).f_108618_.f_108572_) {
                        player.m_20256_(player.m_20184_().m_82520_(0.0, (player.m_20184_().f_82480_ + 1.0) * 0.015, 0.0));
                    } else if (player.m_20184_().f_82480_ < 0.15 && !player.m_204029_(FluidTags.f_13132_) && !player.m_204029_(FluidTags.f_13131_)) {
                        player.m_20256_(player.m_20184_().m_82520_(0.0, 0.15 - player.m_20184_().f_82480_, 0.0));
                    }
                } else {
                    player.f_19789_ = 0.0f;
                    player.m_6853_(true);
                    player.m_20256_(player.m_20184_().m_82520_(0.0, -player.m_20184_().m_7098_(), 0.0));
                    if (player.f_19853_.m_6425_(player.m_20183_()).m_205070_(FluidTags.f_13132_) && UpgradedNetheriteConfig.EnableLavaDamageDurabilityFeatherArmor) {
                        DurabilityUtil.FeatherDurabilityLoss(player);
                    }
                    if (player.f_19853_.m_6425_(player.m_20183_()).m_205070_(FluidTags.f_13131_) && UpgradedNetheriteConfig.EnableWaterDamageDurabilityFeatherArmor) {
                        DurabilityUtil.FeatherDurabilityLoss(player);
                    }
                }
            }
            if (player.f_19853_.f_46443_ && FeatherUtil.isWearingFeatherArmor(player) && (player.m_20096_() || EntityDataUtil.getAbilityClimbwall((Entity)player)) && !EntityDataUtil.getAbilityMultiJump((Entity)player) && UpgradedNetheriteConfig.EnableMultiJump) {
                EntityDataUtil.setAbilityMultiJump((Entity)player, true);
            } else if (player.f_19853_.f_46443_ && player instanceof LocalPlayer && ((LocalPlayer)player).f_108618_.f_108572_ && FeatherUtil.isWearingFeatherArmor(player) && !player.m_150110_().f_35936_ && !player.m_20069_() && !player.m_20077_() && !player.m_6147_() && player.m_20184_().f_82480_ < 0.0 && EntityDataUtil.getAbilityMultiJump((Entity)player) && UpgradedNetheriteConfig.EnableMultiJump) {
                player.f_19789_ = 0.0f;
                PlayerFallDistanceUpdateHandler.PlayerFallDistanceUpdate(player.m_20148_(), Float.valueOf(player.f_19789_));
                player.m_6135_();
                EntityDataUtil.decreaseAbilityMultiJump((Entity)player);
            } else if (!(FeatherUtil.isWearingFeatherArmor(player) && UpgradedNetheriteConfig.EnableMultiJump || !EntityDataUtil.getAbilityMultiJump((Entity)player))) {
                EntityDataUtil.setAbilityMultiJump((Entity)player, false);
            }
            if (CorruptUtil.intWearingCorrupt(player, true) < 1 && !player.m_21023_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get()) || !UpgradedNetheriteConfig.EnableHealthMalus) {
                player.m_21204_().m_22161_(this.HealthAttributeMap(0));
            } else if (CorruptUtil.intWearingCorrupt(player, true) >= 1 || player.m_21023_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                if (player.m_21023_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                    player.m_21204_().m_22178_(this.HealthAttributeMap(CorruptUtil.intWearingCorrupt(player, true) + (player.m_21124_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get()).m_19564_() + 1)));
                    if (player.m_21223_() > player.m_21233_()) {
                        player.m_21153_(player.m_21233_());
                    }
                } else {
                    player.m_21204_().m_22178_(this.HealthAttributeMap(CorruptUtil.intWearingCorrupt(player, true)));
                    if (player.m_21223_() > player.m_21233_()) {
                        player.m_21153_(player.m_21233_());
                    }
                }
            }
            if (EntityDataUtil.getMalusCorruption((Entity)player) > 0 && !player.m_21023_((MobEffect)UpgradedNetheriteEffects.NETHERITE_CORRUPTION.get())) {
                EntityDataUtil.setMalusCorruption((Entity)player, 0);
                EntityDataUtil.setCorrupterite((Entity)player, CorruptUtil.intWearingCorrupt(player, false));
            }
            if (WaterUtil.isWearingWaterArmor(player) && UpgradedNetheriteConfig.EnableWaterBreath && player.m_20146_() < player.m_6062_()) {
                player.m_20301_(player.m_20146_() + 4);
                DurabilityUtil.WaterDurabilityLoss(player);
            }
            if (PhantomUtil.isWearingPhantomArmor(player) && UpgradedNetheriteConfig.EnableStepHeight) {
                if (player.f_19793_ < 1.0f) {
                    EntityDataUtil.setAbilityStepHeight((Entity)player, true);
                    player.f_19793_ = 1.0f;
                }
            } else if (EntityDataUtil.getAbilityStepHeight((Entity)player) && player.f_19793_ > 0.6f) {
                player.f_19793_ = 0.6f;
                EntityDataUtil.setAbilityStepHeight((Entity)player, false);
            }
            if (CorruptUtil.intWearingCorrupt(player, false) > 0) {
                DurabilityUtil.CorruptDurabilityGain(player);
            }
            if (FireUtil.isWearingFireArmor(player) && UpgradedNetheriteConfig.EnableLavaSpeed && player.m_20077_() && !player.m_150110_().f_35935_) {
                player.m_20256_(player.m_20184_().m_82542_((double)1.66f, 1.0, (double)1.66f));
            }
            if (FireUtil.isWearingFireArmor(player) && player.f_146808_) {
                for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)player.m_20183_().m_7918_(0, 0, 0), (BlockPos)player.m_20183_().m_7918_(0, 1, 0))) {
                    if (player.m_9236_().m_8055_(blockpos1).m_60734_() != Blocks.f_152499_) continue;
                    player.m_9236_().m_46597_(blockpos1, Blocks.f_50016_.m_49966_());
                }
            }
            if (WaterUtil.isWearingWaterArmor(player) && UpgradedNetheriteConfig.EnableWaterSpeed) {
                player.m_21204_().m_22178_(this.SwimAttributeMap());
            } else if (!WaterUtil.isWearingWaterArmor(player)) {
                player.m_21204_().m_22161_(this.SwimAttributeMap());
            }
            if (UpgradedNetheriteConfig.EnableClimbWall && PoisonUtil.isWearingPoisonArmor(player)) {
                if (!player.m_6047_() && EntityDataUtil.getAbilityClimbwall((Entity)player)) {
                    if (player.m_20184_().m_7098_() < 0.0) {
                        player.m_6853_(true);
                        player.m_20256_(player.m_20184_().m_82520_(-player.m_20184_().m_7096_() / 5.0, -player.m_20184_().m_7098_(), -player.m_20184_().m_7094_() / 5.0));
                        player.f_19789_ = 0.0f;
                    }
                    if (player.m_20184_().m_7096_() != 0.0 && player.m_20184_().m_7094_() != 0.0) {
                        EntityDataUtil.setAbilityClimbwall((Entity)player, false);
                    }
                }
                if ((player.m_6047_() || player.m_6147_()) && EntityDataUtil.getAbilityClimbwall((Entity)player)) {
                    EntityDataUtil.setAbilityClimbwall((Entity)player, false);
                }
                if (!(player.m_6047_() || !player.f_19862_ || player.m_20077_() || player.m_20069_() || player.m_150110_().f_35935_ || player.m_6147_() || !(player.m_20184_().m_7098_() < 0.1))) {
                    Double LookAt = player.m_20154_().f_82480_;
                    if (LookAt > 0.1) {
                        LookAt = 0.1;
                    }
                    if (LookAt < -0.1) {
                        LookAt = -0.1;
                    }
                    if (player.f_19853_.f_46443_ && player instanceof LocalPlayer && ((LocalPlayer)player).f_108618_.f_108567_ < 0.0f) {
                        LookAt = LookAt * -1.0;
                    }
                    player.m_20256_(player.m_20184_().m_82520_(-player.m_20184_().m_7096_() / 5.0, LookAt - player.m_20184_().f_82480_, -player.m_20184_().m_7094_() / 5.0));
                    EntityDataUtil.setAbilityClimbwall((Entity)player, true);
                    player.f_19789_ = 0.0f;
                    if (player.f_19853_.f_46443_) {
                        PlayerFallDistanceUpdateHandler.PlayerFallDistanceUpdate(player.m_20148_(), Float.valueOf(player.f_19789_));
                    }
                }
            } else if (!PoisonUtil.isWearingPoisonArmor(player) && EntityDataUtil.getAbilityClimbwall((Entity)player)) {
                EntityDataUtil.setAbilityClimbwall((Entity)player, false);
            }
            if (EchoUtil.isWearingEchoArmor(player) && !EntityDataUtil.hasEchoHealCooldown(player) && player.f_19853_.m_204166_(player.m_20183_()).m_203565_(Biomes.f_220594_) && UpgradedNetheriteConfig.EnableHealEchoArmor && player.m_21223_() < player.m_21233_()) {
                player.getPersistentData().m_128405_("upgraded_netherite_echo_heal_cd", UpgradedNetheriteConfig.HealEchoArmorDelay * 20);
                player.m_5634_(1.0f);
            }
            EntityDataUtil.tickCooldown(player);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (event.getSource().m_19384_() && FireUtil.isWearingFireArmor(player)) {
                if (UpgradedNetheriteConfig.EnableFireImmune) {
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                    player.m_20095_();
                    DurabilityUtil.FireDurabilityLoss(player);
                }
            } else if (event.getSource() == DamageSource.f_19317_ && !player.f_19853_.m_5776_() && EnderUtil.isWearingEnderArmor(player) && EnderUtil.isVoidYLevel(player) && !player.m_21023_((MobEffect)UpgradedNetheriteEffects.ENDER_ANCHOR.get()) && UpgradedNetheriteConfig.EnableVoidSave && ArmorEventHandler.enderSaveVoid(player)) {
                ArmorEventHandler.enderBreakArmor(player);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onEntityFall(LivingFallEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (PhantomUtil.isWearingPhantomArmor(player) && UpgradedNetheriteConfig.EnableFallImmune) {
                event.setResult(Event.Result.DENY);
                if (UpgradedNetheriteConfig.EnableDamageDurabilityPhantomArmor) {
                    Iterable armorList = player.m_6168_();
                    for (ItemStack stack : armorList) {
                        if (stack.m_41619_() || !PhantomUtil.isPhantomArmor(stack) || !((double)player.f_19789_ >= 3.5)) continue;
                        stack.m_41622_(UpgradedNetheriteConfig.MultiplierDamageDurabilityPhantomArmor * (Math.round(player.f_19789_) - 3), (LivingEntity)player, livingEntity -> livingEntity.m_21166_(((ArmorItem)stack.m_41720_()).m_40402_()));
                    }
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
            if (FeatherUtil.isWearingFeatherArmor(player) && UpgradedNetheriteConfig.EnableReduceFallDamage) {
                event.setDamageMultiplier(0.5f);
                if (UpgradedNetheriteConfig.EnableFallDamageDurabilityFeatherArmor && (double)event.getDistance() > 3.0) {
                    DurabilityUtil.FeatherDurabilityLoss(player);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onApplyEffect(MobEffectEvent.Added event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (event.getEffectInstance().m_19544_() == MobEffects.f_19615_ && WitherUtil.isWearingWitherArmor((Player)player) && UpgradedNetheriteConfig.EnableWitherImmune) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                DurabilityUtil.WitherDurabilityLoss((Player)player);
            } else if (event.getEffectInstance().m_19544_() == MobEffects.f_19614_ && PoisonUtil.isWearingPoisonArmor((Player)player) && UpgradedNetheriteConfig.EnablePoisonImmune) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                DurabilityUtil.PoisonDurabilityLoss((Player)player);
            } else if (event.getEffectInstance().m_19544_() == MobEffects.f_19620_ && FeatherUtil.isWearingFeatherArmor((Player)player) && UpgradedNetheriteConfig.EnableLevitationImmune) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                DurabilityUtil.FeatherDurabilityLoss((Player)player);
            }
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            EntityDataUtil.setAbilityClimbwall((Entity)player, false);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    @OnlyIn(value=Dist.CLIENT)
    public void onOverlayRender(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type() && WaterUtil.isWearingWaterArmor((Player)mc.f_91074_) && UpgradedNetheriteConfig.EnableWaterBreath && (double)mc.f_91074_.m_20146_() >= (double)mc.f_91074_.m_6062_() * 0.966) {
            event.setCanceled(true);
        }
    }
}

