/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.monster;

import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.TimedEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherFindDetectionPointGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherFireSonarGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherGrabGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherRandomSwimGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher.ThrasherThrashGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.GreatThrasher;
import com.teamabnormals.upgrade_aquatic.core.other.UADataSerializers;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UABiomeTags;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UAEntityTypeTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UAPlayableEndimations;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Thrasher
extends Monster
implements Endimatable {
    public static final Predicate<Entity> ENEMY_MATCHER = entity -> {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player && !((Player)entity).m_7500_() && !entity.m_5833_()) {
            return entity.m_20069_();
        }
        return entity.m_6095_().m_204039_(UAEntityTypeTags.THRASHER_SONAR_TARGETS) && entity.m_20069_();
    };
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_ID = UUID.fromString("3158fbca-89d7-4c15-b1ee-448cefd023b7");
    private static final AttributeModifier KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_ID, "Knockback Resistance", 4.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WATER_TIME = SynchedEntityData.m_135353_(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STUN_TIME = SynchedEntityData.m_135353_(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HITS_TILL_STUN = SynchedEntityData.m_135353_(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> POSSIBLE_DETECTION_POINT = SynchedEntityData.m_135353_(Thrasher.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<EntityDimensions> CAUGHT_SIZE = SynchedEntityData.m_135353_(Thrasher.class, UADataSerializers.ENTITY_SIZE);
    private static final EntityDimensions DEFAULT_SIZE = EntityDimensions.m_20398_((float)1.6f, (float)0.9f);
    public final TimedEndimation stunAnimation = new TimedEndimation(10, 10);
    protected int ticksSinceLastSonarFire;
    protected float prevTailAnimation;
    protected float tailAnimation;
    protected float tailSpeed;
    protected float prevFinAnimation;
    protected float finAnimation;
    protected float finSpeed;

    public Thrasher(EntityType<? extends Thrasher> type, Level world) {
        super(type, world);
        this.f_21364_ = 30;
        this.f_21342_ = new ThrasherMoveController(this);
        this.f_21365_ = new ThrasherLookController(this);
        this.prevTailAnimation = this.tailAnimation = this.f_19796_.m_188501_();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.55).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 1.25).m_22268_(Attributes.f_22284_, 8.0);
    }

    public static boolean thrasherCondition(EntityType<? extends PathfinderMob> entityType, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (((Level)world).m_46472_() != Level.f_46428_) {
            return false;
        }
        return pos.m_123342_() <= 30 && (((Level)world).m_46462_() || random.m_188501_() < 0.75f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ThrasherThrashGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ThrasherFireSonarGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ThrasherFindDetectionPointGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ThrasherGrabGoal(this, 2.5, true));
        this.f_21345_.m_25352_(5, (Goal)new ThrasherRandomSwimGoal(this, 1.1, 15));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(WATER_TIME, (Object)2500);
        this.f_19804_.m_135372_(STUN_TIME, (Object)0);
        this.f_19804_.m_135372_(HITS_TILL_STUN, (Object)0);
        this.f_19804_.m_135372_(POSSIBLE_DETECTION_POINT, Optional.empty());
        this.f_19804_.m_135372_(CAUGHT_SIZE, (Object)this.getDefaultSize());
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        GreatThrasher greatThrasher;
        Random rand;
        this.m_20301_(this.m_6062_());
        if (reason == MobSpawnType.NATURAL && worldIn.m_204166_(this.m_20183_()).m_203656_(UABiomeTags.HAS_GREAT_THRASHER) && (rand = new Random()).nextFloat() < 0.25f && (greatThrasher = (GreatThrasher)((EntityType)UAEntityTypes.GREAT_THRASHER.get()).m_20615_(this.f_19853_)) != null) {
            greatThrasher.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            this.f_19853_.m_7967_((Entity)greatThrasher);
            this.m_146870_();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (HITS_TILL_STUN.equals(key) && this.f_19797_ > 10) {
            if (this.getHitsLeftTillStun() == 0) {
                this.setStunned((this.m_217043_().m_188503_(2) + 2) * 20 + this.m_217043_().m_188503_(10));
            }
        } else if (CAUGHT_SIZE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void m_7332_(Entity passenger) {
        if (passenger instanceof LivingEntity) {
            float distance = this.getMountDistance();
            double dx = Math.cos((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dy = -Math.sin((double)this.m_146909_() * (Math.PI / 180));
            double dz = Math.sin((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            Vec3 riderPos = new Vec3(this.m_20185_() + dx, this.m_20186_(), this.m_20189_() + dz);
            double offset = passenger instanceof Player ? this.m_6048_() - 0.2 : this.m_6048_() - 0.5;
            passenger.m_6034_(riderPos.f_82479_, this.m_20186_() + dy + offset, riderPos.f_82481_);
        } else {
            super.m_7332_(passenger);
        }
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (!this.f_19853_.f_46443_ && passenger instanceof LivingEntity && passenger.m_20202_() == this && this.m_20197_().indexOf(passenger) == 0) {
            EntityDimensions defaultSize = this.getDefaultSize();
            this.setCaughtSize(EntityDimensions.m_20398_((float)(defaultSize.f_20377_ + passenger.m_6972_((Pose)passenger.m_20089_()).f_20377_), (float)defaultSize.f_20378_));
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.f_19853_.f_46443_) {
            if (!this.m_20197_().isEmpty()) {
                Entity indexZeroPassenger = (Entity)this.m_20197_().get(0);
                EntityDimensions defaultSize = this.getDefaultSize();
                if (indexZeroPassenger instanceof LivingEntity && passenger.m_20202_() == this) {
                    this.setCaughtSize(EntityDimensions.m_20398_((float)(defaultSize.f_20377_ + passenger.m_6972_((Pose)passenger.m_20089_()).f_20377_), (float)defaultSize.f_20378_));
                } else {
                    this.setCaughtSize(defaultSize);
                }
            } else {
                this.setCaughtSize(this.getDefaultSize());
            }
        }
    }

    public float getMountDistance() {
        return 1.2f;
    }

    public double m_6048_() {
        return 0.5;
    }

    public boolean shouldRiderFaceForward(Player player) {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (!this.m_20197_().isEmpty()) {
            return this.getCaughtSize();
        }
        return super.m_6972_(pose);
    }

    public boolean m_6914_(LevelReader worldIn) {
        return worldIn.m_45784_((Entity)this);
    }

    public void onEndimationStart(PlayableEndimation endimation, PlayableEndimation oldEndimation) {
        AttributeInstance knockbackResistance;
        if (endimation == UAPlayableEndimations.THRASHER_THRASH && !(knockbackResistance = this.m_21051_(Attributes.f_22278_)).m_22109_(KNOCKBACK_RESISTANCE_MODIFIER)) {
            knockbackResistance.m_22118_(KNOCKBACK_RESISTANCE_MODIFIER);
        }
    }

    public void onEndimationEnd(PlayableEndimation endimation, PlayableEndimation newEndimation) {
        AttributeInstance knockbackResistance;
        if (endimation == UAPlayableEndimations.THRASHER_THRASH && (knockbackResistance = this.m_21051_(Attributes.f_22278_)).m_22109_(KNOCKBACK_RESISTANCE_MODIFIER)) {
            knockbackResistance.m_22130_(KNOCKBACK_RESISTANCE_MODIFIER);
        }
    }

    public void m_20321_(boolean downwards) {
    }

    public void m_6845_(boolean downwards) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entitySource = source.m_7639_();
        if (entitySource instanceof LivingEntity) {
            Vec3 difference = new Vec3(entitySource.m_20185_() - this.m_20185_(), entitySource.m_20186_() - this.m_20186_(), entitySource.m_20189_() - this.m_20189_());
            if (difference.m_82553_() <= 8.0) {
                if (entitySource.m_20069_()) {
                    if (entitySource instanceof Player && !((Player)entitySource).m_7500_() && !entitySource.m_5833_()) {
                        this.m_6710_((LivingEntity)entitySource);
                    } else if (!(entitySource instanceof Player)) {
                        this.m_6710_((LivingEntity)entitySource);
                    }
                }
                if (this.getHitsLeftTillStun() > 0) {
                    int chance;
                    int difficultyDividend = switch (this.f_19853_.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.EASY, Difficulty.PEACEFUL -> 10;
                        case Difficulty.NORMAL -> 12;
                        case Difficulty.HARD -> 16;
                    };
                    int n = chance = (double)amount >= this.getStunDamageThreshold() ? 1 : difficultyDividend / (int)Math.max(1.0f, amount);
                    if (this.m_217043_().m_188503_(chance) == 0) {
                        this.setHitsTillStun(this.getHitsLeftTillStun() - 1);
                    }
                }
            } else if (entitySource instanceof Player && !((Player)entitySource).m_7500_() && !entitySource.m_5833_()) {
                this.setPossibleDetectionPoint(entitySource.m_20183_().m_7918_(this.m_217043_().m_188503_(2), this.m_217043_().m_188503_(2), this.m_217043_().m_188503_(2)));
            } else if (!(entitySource instanceof Player)) {
                this.setPossibleDetectionPoint(entitySource.m_20183_().m_7918_(this.m_217043_().m_188503_(2), this.m_217043_().m_188503_(2), this.m_217043_().m_188503_(2)));
            }
        }
        if (!this.f_19853_.m_5776_() && this.isNoEndimationPlaying()) {
            NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)UAPlayableEndimations.THRASHER_HURT);
        }
        return super.m_6469_(source, amount);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public int m_6062_() {
        return 4950;
    }

    protected int m_7305_(int currentAir) {
        return this.m_6062_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.65f;
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    public boolean m_6146_() {
        return true;
    }

    public boolean m_6040_() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailAnimation(float ptc) {
        return Mth.m_14179_((float)ptc, (float)this.prevTailAnimation, (float)this.tailAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFinAnimation(float ptc) {
        return Mth.m_14179_((float)ptc, (float)this.prevFinAnimation, (float)this.finAnimation);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.isMoving() && this.m_5448_() == null) {
                double ySpeed = !((ThrasherLookController)this.m_21563_()).isTurningForSonar() ? -0.005 : -0.0025;
                this.m_20256_(this.m_20184_().m_82520_(0.0, ySpeed, 0.0));
            }
        } else {
            super.m_7023_(vec3);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_5448_() != null && !this.m_5448_().m_6084_() && this.ticksSinceLastSonarFire >= 55 && this.m_217043_().m_188501_() < 0.05f) {
            this.m_6710_(null);
        }
        if (!this.m_21525_()) {
            this.ticksSinceLastSonarFire = this.isEndimationPlaying(UAPlayableEndimations.THRASHER_SONAR_FIRE) ? 0 : ++this.ticksSinceLastSonarFire;
            if (this.m_20071_()) {
                this.setWaterTime(2400);
            } else {
                this.setWaterTime(this.getWaterTime() - 1);
                if (this.getWaterTime() <= 0) {
                    this.m_6469_(DamageSource.f_19324_, 1.0f);
                }
                if (!this.m_20069_() && !this.isStunned() && this.f_19861_) {
                    this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
                    this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
                    this.m_146926_(this.f_19796_.m_188501_() * -50.0f);
                    this.f_19861_ = false;
                    this.f_19812_ = true;
                    this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
                }
            }
            if (this.f_19853_.m_5776_() && !this.m_20197_().isEmpty() && this.isEndimationPlaying(UAPlayableEndimations.THRASHER_THRASH) && this.getAnimationTick() % 2 == 0 && this.getAnimationTick() > 5) {
                Entity passenger = (Entity)this.m_20197_().get(0);
                for (int i = 0; i < 3; ++i) {
                    if (!passenger.m_204029_(FluidTags.f_13131_)) continue;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, passenger.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)passenger.m_20205_(), passenger.m_20186_(), passenger.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)passenger.m_20205_(), (this.m_217043_().m_188500_() - 0.5) * 2.0, -this.m_217043_().m_188500_(), (this.m_217043_().m_188500_() - 0.5) * 2.0);
                }
            }
            if (!this.f_19853_.f_46443_ && this.isStunned()) {
                if (!this.m_20197_().isEmpty()) {
                    this.m_20153_();
                }
                this.setStunned(this.getStunTime() - 1);
            }
        }
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            if (this.f_19853_.f_46443_) {
                this.prevTailAnimation = this.tailAnimation;
                this.prevFinAnimation = this.finAnimation;
                if (!this.m_20069_() || this.isEndimationPlaying(UAPlayableEndimations.THRASHER_THRASH) || this.isEndimationPlaying(UAPlayableEndimations.THRASHER_SONAR_FIRE)) {
                    this.tailSpeed = 1.1f;
                    this.finSpeed = 0.875f;
                } else if (this.isMoving()) {
                    this.tailSpeed = this.tailSpeed < 0.5f ? 2.2f : (this.tailSpeed += (0.25f - this.tailSpeed) * 0.1f);
                    this.finSpeed = this.finSpeed < 0.5f ? 0.875f : (this.finSpeed += (0.045f - this.tailSpeed) * 0.05f);
                } else {
                    this.tailSpeed += (0.125f - this.tailSpeed) * 0.1f;
                    this.finSpeed += (0.01125f - this.finSpeed) * 0.05f;
                }
                TimedEndimation stunAnimation = this.stunAnimation;
                if (this.isStunned()) {
                    if (stunAnimation.getTick() >= 10) {
                        stunAnimation.setDecrementing(true);
                    } else if (stunAnimation.isDecrementing() && stunAnimation.getTick() <= 0) {
                        stunAnimation.setDecrementing(false);
                    }
                } else {
                    stunAnimation.setDecrementing(false);
                }
                stunAnimation.tick();
                this.tailAnimation += this.tailSpeed;
                this.finAnimation += this.finSpeed;
            }
            if (!this.isStunned()) {
                List nearbyEntities = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(0.5), ENEMY_MATCHER);
                for (LivingEntity entities : nearbyEntities) {
                    if (this.m_5448_() != null) continue;
                    this.m_6710_(entities);
                }
            }
            if (this.isMoving() && this.m_20069_()) {
                Vec3 vec3d1 = this.m_20252_(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() - vec3d1.f_82479_ * 1.5, this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_() - vec3d1.f_82480_ * 1.5, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() - vec3d1.f_82481_ * 1.5, 0.0, 0.0, 0.0);
                }
            }
        }
        super.m_8107_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.THRASHER_SPAWN_EGG.get());
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return this.m_20069_() ? (SoundEvent)UASoundEvents.ENTITY_THRASHER_HURT.get() : (SoundEvent)UASoundEvents.ENTITY_THRASHER_HURT_LAND.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_20069_() ? (SoundEvent)UASoundEvents.ENTITY_THRASHER_DEATH.get() : (SoundEvent)UASoundEvents.ENTITY_THRASHER_DEATH_LAND.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.isEndimationPlaying(UAPlayableEndimations.THRASHER_THRASH)) {
            return null;
        }
        return this.m_20069_() ? (SoundEvent)UASoundEvents.ENTITY_THRASHER_AMBIENT.get() : (SoundEvent)UASoundEvents.ENTITY_THRASHER_AMBIENT_LAND.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)UASoundEvents.ENTITY_THRASHER_FLOP.get();
    }

    public SoundEvent getSonarFireSound() {
        return (SoundEvent)UASoundEvents.ENTITY_THRASHER_SONAR_FIRE.get();
    }

    public SoundEvent getThrashingSound() {
        return (SoundEvent)UASoundEvents.ENTITY_THRASHER_THRASH.get();
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11808_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    public int m_8100_() {
        return 100;
    }

    protected double getStunDamageThreshold() {
        return 6.0;
    }

    public int m_5792_() {
        return 1;
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    private void setMoving(boolean moving) {
        this.f_19804_.m_135381_(MOVING, (Object)moving);
    }

    public int getWaterTime() {
        return (Integer)this.f_19804_.m_135370_(WATER_TIME);
    }

    public void setWaterTime(int ticks) {
        this.f_19804_.m_135381_(WATER_TIME, (Object)ticks);
    }

    public int getStunTime() {
        return (Integer)this.f_19804_.m_135370_(STUN_TIME);
    }

    public int getHitsLeftTillStun() {
        return (Integer)this.f_19804_.m_135370_(HITS_TILL_STUN);
    }

    public void setHitsTillStun(int hits) {
        this.f_19804_.m_135381_(HITS_TILL_STUN, (Object)hits);
    }

    @Nullable
    public BlockPos getPossibleDetectionPoint() {
        return ((Optional)this.m_20088_().m_135370_(POSSIBLE_DETECTION_POINT)).orElse(null);
    }

    public void setPossibleDetectionPoint(@Nullable BlockPos detectionPoint) {
        this.m_20088_().m_135381_(POSSIBLE_DETECTION_POINT, Optional.ofNullable(detectionPoint));
    }

    public EntityDimensions getCaughtSize() {
        return (EntityDimensions)this.f_19804_.m_135370_(CAUGHT_SIZE);
    }

    public void setCaughtSize(EntityDimensions caughtSize) {
        this.f_19804_.m_135381_(CAUGHT_SIZE, (Object)caughtSize);
    }

    public int getTicksSinceLastSonarFire() {
        return this.ticksSinceLastSonarFire;
    }

    public boolean isStunned() {
        return this.getStunTime() > 0;
    }

    private void setStunned(int ticks) {
        this.f_19804_.m_135381_(STUN_TIME, (Object)ticks);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsMoving", this.isMoving());
        compound.m_128405_("WaterTicks", this.getWaterTime());
        compound.m_128405_("StunnedTicks", this.getStunTime());
        compound.m_128405_("TicksSinceLastSonarFire", this.getTicksSinceLastSonarFire());
        if (this.getPossibleDetectionPoint() != null) {
            compound.m_128365_("DetectionPoint", (Tag)NbtUtils.m_129224_((BlockPos)this.getPossibleDetectionPoint()));
        }
    }

    protected EntityDimensions getDefaultSize() {
        return DEFAULT_SIZE;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMoving(compound.m_128471_("IsMoving"));
        this.setWaterTime(compound.m_128451_("WaterTicks"));
        this.setStunned(compound.m_128451_("StunnedTicks"));
        this.ticksSinceLastSonarFire = compound.m_128451_("TicksSinceLastSonarFire");
        if (this.getPossibleDetectionPoint() != null) {
            this.setPossibleDetectionPoint(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("DetectionPoint")));
        }
    }

    static class ThrasherMoveController
    extends MoveControl {
        private final Thrasher thrasher;

        public ThrasherMoveController(Thrasher thrasher) {
            super((Mob)thrasher);
            this.thrasher = thrasher;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.thrasher.m_21573_().m_26571_() && this.thrasher.getStunTime() <= 0) {
                Vec3 vec3d = new Vec3(this.f_24975_ - this.thrasher.m_20185_(), this.f_24976_ - this.thrasher.m_20186_(), this.f_24977_ - this.thrasher.m_20189_());
                double d0 = vec3d.m_82553_();
                double d1 = vec3d.f_82480_ / d0;
                float f = (float)(Mth.m_14136_((double)vec3d.f_82481_, (double)vec3d.f_82479_) * 57.2957763671875) - 90.0f;
                this.thrasher.m_146922_(this.m_24991_(this.thrasher.m_146908_(), f, 10.0f));
                this.thrasher.f_20883_ = this.thrasher.m_146908_();
                this.thrasher.f_20885_ = this.thrasher.m_146908_();
                float f1 = (float)(this.f_24978_ * this.thrasher.m_21051_(Attributes.f_22279_).m_22135_());
                float f2 = Mth.m_14179_((float)0.125f, (float)this.thrasher.m_6113_(), (float)f1);
                this.thrasher.m_7910_(f2);
                double d2 = Math.sin((double)(this.thrasher.f_19797_ + this.thrasher.m_19879_()) * 0.5) * 0.05;
                double d3 = Math.cos(this.thrasher.m_146908_() * ((float)Math.PI / 180));
                double d4 = Math.sin(this.thrasher.m_146908_() * ((float)Math.PI / 180));
                double d5 = Math.sin((double)(this.thrasher.f_19797_ + this.thrasher.m_19879_()) * 0.75) * 0.05;
                if (this.thrasher.m_20069_()) {
                    float f3 = -((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)Mth.m_14116_((float)((float)(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82481_ * vec3d.f_82481_)))) * 57.2957763671875));
                    f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)-85.0f, (float)85.0f);
                    this.thrasher.m_146926_(this.m_24991_(this.thrasher.m_146909_(), f3, 5.0f));
                }
                this.thrasher.m_20256_(this.thrasher.m_20184_().m_82520_(d2 * d3, d5 * (d4 + d3) * 0.25 + (double)f2 * d1 * 0.1, d2 * d4));
                this.thrasher.setMoving(true);
            } else {
                this.thrasher.m_7910_(0.0f);
                this.thrasher.setMoving(false);
            }
        }
    }

    public static class ThrasherLookController
    extends LookControl {
        private boolean isTurningForSonar;

        public ThrasherLookController(Thrasher thrasher) {
            super((Mob)thrasher);
        }

        public void m_8128_() {
            float angleLimit;
            if (this.f_186068_ > 0) {
                --this.f_186068_;
                if (this.isTurningForSonar) {
                    this.m_180896_().ifPresent(yRot -> this.f_24937_.m_146922_(this.m_24956_(this.f_24937_.m_146908_(), yRot.floatValue(), this.f_24938_)));
                } else {
                    this.m_180896_().ifPresent(yRot -> {
                        this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, yRot.floatValue(), this.f_24938_);
                    });
                }
                this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), ((Float)this.m_180897_().get()).floatValue(), this.f_24939_));
            } else {
                if (this.f_24937_.m_21573_().m_26571_()) {
                    this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), 0.0f, 5.0f));
                }
                if (this.isTurningForSonar) {
                    this.f_24937_.m_146922_(this.m_24956_(this.f_24937_.m_146908_(), this.f_24937_.f_20883_, this.f_24938_));
                } else {
                    this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, this.f_24937_.f_20883_, this.f_24938_);
                }
            }
            float wrappedDegrees = Mth.m_14177_((float)(this.f_24937_.f_20885_ - this.f_24937_.f_20883_));
            float f = angleLimit = this.f_24937_.m_20197_().isEmpty() ? 10.0f : 5.0f;
            if (wrappedDegrees < -angleLimit) {
                this.f_24937_.f_20883_ -= 4.0f;
            } else if (wrappedDegrees > angleLimit) {
                this.f_24937_.f_20883_ += 4.0f;
            }
        }

        public boolean isTurningForSonar() {
            return this.isTurningForSonar;
        }

        public void setTurningForSonar(boolean isTurning) {
            this.isTurningForSonar = isTurning;
        }
    }
}

