/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.BasicInventoryHopperBlock;
import com.tom.storagemod.block.InventoryCableConnectorBlock;
import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.tile.AbstractInventoryHopperBlockEntity;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class BasicInventoryHopperBlockEntity
extends AbstractInventoryHopperBlockEntity {
    private ItemStack filter = ItemStack.f_41583_;
    private ItemPredicate filterPred;
    private int cooldown;
    private int lastItemSlot = -1;

    public BasicInventoryHopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.invHopperBasicTile.get(), pos, state);
    }

    @Override
    protected void update() {
        ItemStack is;
        ItemStack extractItem;
        boolean hasFilter;
        if (!this.filter.m_41619_() && this.filterPred == null) {
            this.setFilter(this.filter);
        }
        boolean bl = hasFilter = this.filterPred != null;
        if (this.topNet && !hasFilter) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (!((Boolean)this.m_58900_().m_61143_((Property)BasicInventoryHopperBlock.ENABLED)).booleanValue()) {
            return;
        }
        IItemHandler top = (IItemHandler)this.top.orElse((Object)EmptyHandler.INSTANCE);
        IItemHandler bot = (IItemHandler)this.bottom.orElse((Object)EmptyHandler.INSTANCE);
        if (this.lastItemSlot != -1 && this.lastItemSlot < top.getSlots()) {
            if (hasFilter) {
                inSlot = top.getStackInSlot(this.lastItemSlot);
                if (!this.filterPred.test(inSlot)) {
                    this.lastItemSlot = -1;
                }
            } else {
                inSlot = top.getStackInSlot(this.lastItemSlot);
                if (inSlot.m_41619_()) {
                    this.lastItemSlot = -1;
                }
            }
        }
        if (this.lastItemSlot == -1) {
            for (int i = 0; i < top.getSlots(); ++i) {
                ItemStack extractItem2;
                ItemStack inSlot;
                if (hasFilter && !this.filterPred.test(inSlot = top.getStackInSlot(i)) || (extractItem2 = top.extractItem(i, 1, true)).m_41619_()) continue;
                this.lastItemSlot = i;
                break;
            }
            this.cooldown = 10;
        }
        if (this.lastItemSlot != -1 && !(extractItem = top.extractItem(this.lastItemSlot, 1, true)).m_41619_() && (is = ItemHandlerHelper.insertItemStacked((IItemHandler)bot, (ItemStack)extractItem, (boolean)true)).m_41619_()) {
            is = ItemHandlerHelper.insertItemStacked((IItemHandler)bot, (ItemStack)top.extractItem(this.lastItemSlot, 1, false), (boolean)false);
            this.cooldown = 10;
            if (!is.m_41619_()) {
                // empty if block
            }
            return;
        }
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("Filter", (Tag)this.getFilter().m_41739_(new CompoundTag()));
    }

    public void m_142466_(CompoundTag nbtIn) {
        super.m_142466_(nbtIn);
        this.filter = ItemStack.m_41712_((CompoundTag)nbtIn.m_128469_("Filter"));
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
        if (this.filter.m_41619_()) {
            this.filterPred = null;
        } else {
            Item item = this.filter.m_41720_();
            if (item instanceof IItemFilter) {
                IItemFilter i = (IItemFilter)item;
                this.filterPred = i.createFilter(BlockFace.touching(this.f_58857_, this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)InventoryCableConnectorBlock.FACING)), filter);
            } else {
                this.filterPred = s -> ItemStack.m_41746_((ItemStack)s, (ItemStack)filter) && ItemStack.m_41658_((ItemStack)s, (ItemStack)filter);
            }
        }
        this.m_6596_();
    }

    public ItemStack getFilter() {
        return this.filter;
    }
}

