/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.perk.PerkRegistry;

public final class NBTStackHelper {
    public static ItemStack setString(ItemStack stack, String keyName, String keyValue) {
        stack.m_41784_().m_128359_(keyName, keyValue);
        return stack;
    }

    public static String getString(ItemStack stack, String keyName) {
        return NBTStackHelper.getString(stack.m_41783_(), keyName);
    }

    public static String getString(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.m_128425_(keyName, 8)).map(t -> t.m_128461_(keyName)).orElse("");
    }

    public static ItemStack setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        stack.m_41784_().m_128379_(keyName, keyValue);
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        return NBTStackHelper.getBoolean(stack.m_41783_(), keyName);
    }

    public static boolean getBoolean(@Nullable CompoundTag tag, String keyName) {
        return Optional.ofNullable(tag).filter(t -> t.m_128425_(keyName, 1)).map(t -> t.m_128471_(keyName)).orElse(false);
    }

    public static ItemStack setShort(ItemStack stack, String keyName, short keyValue) {
        stack.m_41784_().m_128376_(keyName, keyValue);
        return stack;
    }

    public static short getShort(ItemStack stack, String keyName) {
        return NBTStackHelper.getShort(stack, keyName, (short)Short.MIN_VALUE);
    }

    public static short getShort(ItemStack stack, String keyName, short fallback) {
        return Optional.ofNullable(stack.m_41783_()).filter(tag -> tag.m_128425_(keyName, 2)).map(tag -> tag.m_128448_(keyName)).orElse(fallback);
    }

    public static ItemStack setInteger(ItemStack stack, String keyName, int keyValue) {
        stack.m_41784_().m_128405_(keyName, keyValue);
        return stack;
    }

    public static int getInteger(ItemStack stack, String keyName) {
        return NBTStackHelper.getInteger(stack, keyName, Integer.MIN_VALUE);
    }

    public static int getInteger(ItemStack stack, String keyName, int fallback) {
        return Optional.ofNullable(stack.m_41783_()).filter(tag -> tag.m_128425_(keyName, 3)).map(tag -> tag.m_128451_(keyName)).orElse(fallback);
    }

    public static ItemStack setLong(ItemStack stack, String keyName, long keyValue) {
        stack.m_41784_().m_128356_(keyName, keyValue);
        return stack;
    }

    @Deprecated
    public static long getLong(ItemStack stack, String keyName) {
        return NBTStackHelper.getLong(stack, keyName, Long.MIN_VALUE);
    }

    public static long getLong(ItemStack stack, String keyName, long fallback) {
        return Optional.ofNullable(stack.m_41783_()).filter(tag -> tag.m_128425_(keyName, 4)).map(tag -> tag.m_128454_(keyName)).orElse(fallback);
    }

    public static void setUUID(CompoundTag tag, String keyName, @Nullable UUID uuid) {
        if (uuid != null) {
            tag.m_128362_(keyName, uuid);
        }
    }

    public static Optional<UUID> getUUID(ItemStack stack, String keyName) {
        return Optional.ofNullable(stack.m_41783_()).flatMap(t -> NBTStackHelper.getUUID(t, keyName));
    }

    public static Optional<UUID> getUUID(CompoundTag tag, String keyName) {
        return Optional.of(tag).filter(t -> t.m_128403_(keyName)).map(t -> t.m_128342_(keyName));
    }

    public static void setBlockPos(CompoundTag tag, String keyName, BlockPos keyValue) {
        tag.m_128405_(keyName + "_x", keyValue.m_123341_());
        tag.m_128405_(keyName + "_y", keyValue.m_123342_());
        tag.m_128405_(keyName + "_z", keyValue.m_123343_());
    }

    public static Optional<BlockPos> getBlockPos(@Nullable CompoundTag tag, String keyName) {
        if (tag == null) {
            return Optional.empty();
        }
        if (tag.m_128425_(keyName + "_pos", 4)) {
            BlockPos pos = BlockPos.m_122022_((long)tag.m_128454_(keyName));
            tag.m_128473_(keyName + "_pos");
            NBTStackHelper.setBlockPos(tag, keyName, pos);
            return Optional.of(pos);
        }
        if (tag.m_128425_(keyName + "_x", 3) && tag.m_128425_(keyName + "_y", 3) && tag.m_128425_(keyName + "_z", 3)) {
            return Optional.of(new BlockPos(tag.m_128451_(keyName + "_x"), tag.m_128451_(keyName + "_y"), tag.m_128451_(keyName + "_z")));
        }
        return Optional.empty();
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, Location location) {
        NBTStackHelper.setLocation(stack.m_41784_(), keyName, location);
        return stack;
    }

    public static CompoundTag setLocation(CompoundTag tag, String keyName, Location location) {
        NBTStackHelper.setBlockPos(tag, keyName, location.getPos());
        NBTStackHelper.setWorldKey(tag, keyName + "_dim", location.dim);
        return tag;
    }

    public static Location getLocation(ItemStack stack, String keyName) {
        return NBTStackHelper.getLocation(stack.m_41783_(), keyName);
    }

    public static Location getLocation(@Nullable CompoundTag tag, String keyName) {
        ResourceKey<Level> worldKey;
        BlockPos pos;
        if (tag != null && (pos = (BlockPos)NBTStackHelper.getBlockPos(tag, keyName).orElse(null)) != null && (worldKey = NBTStackHelper.getWorldKey(tag, keyName + "_dim")) != null) {
            return new Location(pos, worldKey);
        }
        return Location.ORIGIN;
    }

    public static CompoundTag setGlobalPos(CompoundTag tag, String keyName, GlobalPos globalPos) {
        GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)globalPos).result().ifPresent(pos -> tag.m_128365_(keyName, pos));
        return tag;
    }

    @Nullable
    public static GlobalPos getGlobalPos(@Nullable CompoundTag tag, String keyName) {
        if (tag != null && tag.m_128441_(keyName)) {
            return GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(keyName)).result().orElse(null);
        }
        return null;
    }

    public static CompoundTag setWorldKey(CompoundTag tag, String keyName, ResourceKey<Level> worldKey) {
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, worldKey).result().ifPresent(rl -> tag.m_128365_(keyName, rl));
        return tag;
    }

    @Nullable
    public static ResourceKey<Level> getWorldKey(@Nullable CompoundTag tag, String keyName) {
        if (tag != null && tag.m_128441_(keyName)) {
            return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(keyName)).result().orElse(null);
        }
        return null;
    }

    public static int getTimer(long actualTime, ItemStack stack, String keyName, int limit) {
        long endTime = NBTStackHelper.getLong(stack, keyName, 0L);
        if (endTime > 0L) {
            long leftTime = endTime - actualTime;
            if (leftTime > 0L) {
                if (leftTime > (long)limit) {
                    NBTStackHelper.setLong(stack, keyName, actualTime + (long)limit);
                    leftTime = limit;
                }
                return (int)leftTime;
            }
            NBTStackHelper.removeKeyName(stack, keyName);
        }
        return 0;
    }

    public static boolean hasTimer(long actualTime, ItemStack stack, String keyName, int limit) {
        return NBTStackHelper.getTimer(actualTime, stack, keyName, limit) > 0;
    }

    public static boolean removeLocation(ItemStack stack, String keyName) {
        return Stream.of("_pos", "_dim").filter(k -> NBTStackHelper.removeKeyName(stack, keyName + k)).count() == 2L;
    }

    public static boolean removeKeyName(ItemStack stack, String ... keyNames) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        boolean allRemoved = true;
        for (String keyName : keyNames) {
            if (tag.m_128441_(keyName)) {
                tag.m_128473_(keyName);
                continue;
            }
            allRemoved = false;
        }
        if (tag.m_128456_()) {
            stack.m_41751_(null);
        }
        return allRemoved;
    }

    public static List<MobEffectInstance> getEffectList(CompoundTag tag, String keyName, Predicate<MobEffect> predic) {
        return NBTStackHelper.getListOrEmpty(tag, keyName).map(effectList -> IntStream.range(0, effectList.size()).mapToObj(arg_0 -> ((ListTag)effectList).m_128728_(arg_0)).map(nbt -> NBTStackHelper.getEffect(nbt, predic)).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static void setEffectlist(CompoundTag tag, String keyName, Stream<MobEffectInstance> effectInstances) {
        ListTag effectList = new ListTag();
        effectInstances.forEach(effectInstance -> effectList.add((Object)NBTStackHelper.setEffect(new CompoundTag(), effectInstance)));
        tag.m_128365_(keyName, (Tag)effectList);
    }

    private static CompoundTag setEffect(CompoundTag tag, MobEffectInstance effectInstance) {
        effectInstance.m_19555_(tag);
        return tag;
    }

    @Nullable
    private static MobEffectInstance getEffect(CompoundTag tag, Predicate<MobEffect> predic) {
        return Optional.ofNullable(MobEffectInstance.m_19560_((CompoundTag)tag)).filter(e -> predic.test(e.m_19544_())).orElse(null);
    }

    public static ListTag getListOrCreate(CompoundTag tag, String keyName) {
        if (tag.m_128425_(keyName, 9)) {
            return tag.m_128437_(keyName, 10);
        }
        ListTag list = new ListTag();
        tag.m_128365_(keyName, (Tag)list);
        return list;
    }

    public static Optional<ListTag> getListOrEmpty(ItemStack stack, String keyName) {
        return Optional.ofNullable(stack.m_41783_()).flatMap(tag -> NBTStackHelper.getListOrEmpty(tag, keyName));
    }

    public static Optional<ListTag> getListOrEmpty(CompoundTag tag, String keyName) {
        return Optional.of(tag).filter(t -> t.m_128425_(keyName, 9)).map(t -> t.m_128437_(keyName, 10));
    }

    public static void readPerks(Map<Perk, Integer> perks, CompoundTag tag) {
        NBTStackHelper.getListOrEmpty(tag, "perks").ifPresent(tagPerks -> {
            for (int i = 0; i < tagPerks.size(); ++i) {
                Perk perk;
                CompoundTag tagPerk = tagPerks.m_128728_(i);
                if (!tagPerk.m_128425_("id", 2) || !tagPerk.m_128425_("level", 1) || (perk = (Perk)PerkRegistry.get().getValue((int)tagPerk.m_128448_("id"))) == null || perk.isDisabled(null)) continue;
                perks.put(perk, Math.min(perk.getLevelMax(), tagPerk.m_128445_("level") & 0xFF));
            }
        });
    }

    public static void writePerks(Map<Perk, Integer> perks, CompoundTag tag) {
        ListTag tagPerks = NBTStackHelper.getListOrCreate(tag, "perks");
        perks.forEach((perk, value) -> {
            if (perk != null && !perk.isDisabled(null)) {
                CompoundTag tagPerk = new CompoundTag();
                tagPerk.m_128376_("id", (short)PerkRegistry.get().getID(perk));
                tagPerk.m_128344_("level", (byte)Math.min(perk.getLevelMax(), value));
                tagPerks.add((Object)tagPerk);
            }
        });
    }
}

