/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public final class EnchantmentSpectralBite
extends ArmorEnchantment {
    private static final String SPECTRAL_BITE_LAST_PROC_NBT_LONG = "spectral_bite_last_proc";

    public EnchantmentSpectralBite() {
        super("spectral_bite", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_FEET, EquipmentSlot.FEET);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentSpectralBite.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.spectralBiteEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int amplifier) {
        amplifier = EntityHelper.getSpectralBiteLevel(wearer);
        if (amplifier > 0) {
            boolean valid;
            double scale = (double)amplifier / (double)this.m_6586_();
            int delay = TimeHelper.tickFromSecond(30 - (int)(scale * 27.0));
            CompoundTag persistantData = wearer.getPersistentData();
            boolean bl = valid = !persistantData.m_128425_(SPECTRAL_BITE_LAST_PROC_NBT_LONG, 4);
            if (!valid) {
                long timeLeft = persistantData.m_128454_(SPECTRAL_BITE_LAST_PROC_NBT_LONG) - (long)wearer.f_19797_;
                if (timeLeft <= 0L) {
                    persistantData.m_128473_(SPECTRAL_BITE_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.m_128356_(SPECTRAL_BITE_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
                }
            }
            if (valid && wearer.m_217043_().m_188503_(Math.max(10, this.m_6586_())) < amplifier) {
                Helper.castEvokerFangs(wearer, attacker, true);
                persistantData.m_128356_(SPECTRAL_BITE_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
            }
        }
    }

    @Override
    public boolean isInBeta() {
        return true;
    }
}

