/*
 * Decompiled with CFR 0.152.
 */
package smartin.tetraticcombat.ItemResolver;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.Map;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.WeaponAttributesHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.properties.AttributeHelper;
import smartin.tetraticcombat.ForgeConfigHolder;
import smartin.tetraticcombat.ItemResolver.Condition;
import smartin.tetraticcombat.ItemResolver.ExpandedContainer;
import smartin.tetraticcombat.ItemResolver.JSONFormat;
import smartin.tetraticcombat.TetraticCombat;

public class Resolver {
    private static final Logger LOGGER = LogManager.getLogger();
    public static JSONFormat weaponConfig;

    public static void reload(JSONFormat config) {
        weaponConfig = config;
    }

    public static void readConfig(String config) {
        LOGGER.info(config);
        weaponConfig = (JSONFormat)new Gson().fromJson(config, JSONFormat.class);
    }

    public static ExpandedContainer findWeaponByNBT(ItemStack stack) {
        if (weaponConfig == null) {
            return null;
        }
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            for (String key : tag.m_128431_()) {
                Map<String, Condition> map1;
                if (!Resolver.weaponConfig.attributemap.containsKey(key) || !(map1 = Resolver.weaponConfig.attributemap.get(key)).containsKey(tag.m_128461_(key))) continue;
                return map1.get(tag.m_128461_(key)).resolve(stack);
            }
        }
        return null;
    }

    public static ItemStack generateBetterCombatNBT(ItemStack itemStack) {
        return Resolver.generateBetterCombatNBT(itemStack, false);
    }

    public static void resetBetterCombatNBT(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("weapon_attributes")) {
            itemStack.m_41749_("weapon_attributes");
        }
    }

    public static ItemStack generateBetterCombatNBT(ItemStack itemStack, boolean force) {
        ExpandedContainer container = Resolver.findWeaponByNBT(itemStack);
        if (container != null) {
            if (force && itemStack.m_41782_() && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("weapon_attributes")) {
                itemStack.m_41749_("weapon_attributes");
            }
            try {
                double range = Resolver.getAttackRange(itemStack);
                WeaponAttributes attributes = WeaponRegistry.resolveAttributes((ResourceLocation)new ResourceLocation("tetratic:generated"), (AttributesContainer)container.attributes);
                if (((Boolean)ForgeConfigHolder.COMMON.enableTetraRange.get()).booleanValue()) {
                    attributes = new WeaponAttributes(range, attributes.pose(), attributes.offHandPose(), Boolean.valueOf(attributes.isTwoHanded()), attributes.category(), attributes.attacks());
                }
                Resolver.rescaleUpswing(attributes, Resolver.getQuickStat(itemStack));
                WeaponAttributesHelper.validate((WeaponAttributes)attributes);
                AttributesContainer attributesContainer = new AttributesContainer(container.attributes.parent(), attributes);
                WeaponAttributesHelper.writeToNBT((ItemStack)itemStack, (AttributesContainer)attributesContainer);
                Resolver.applyScale(itemStack, container.scaleX, container.scaleY, container.scaleZ);
                Resolver.applyTranslation(itemStack, container.translationX, container.translationY, container.translationZ);
                return itemStack;
            }
            catch (Exception e) {
                TetraticCombat.LOGGER.warn(e.getMessage());
                e.printStackTrace();
            }
        }
        return itemStack;
    }

    private static void applyScale(ItemStack stack, float x, float y, float z) {
        CompoundTag nbt = stack.m_41783_();
        if (x != 1.0f) {
            nbt.m_128350_("tetraticScaleX", x);
        } else if (nbt.m_128441_("tetraticScaleX")) {
            nbt.m_128473_("tetraticScaleX");
        }
        if (y != 1.0f) {
            nbt.m_128350_("tetraticScaleY", y);
        } else if (nbt.m_128441_("tetraticScaleY")) {
            nbt.m_128473_("tetraticScaleY");
        }
        if (z != 1.0f) {
            nbt.m_128350_("tetraticScaleZ", z);
        } else if (nbt.m_128441_("tetraticScaleZ")) {
            nbt.m_128473_("tetraticScaleZ");
        }
        stack.m_41751_(nbt);
    }

    private static void applyTranslation(ItemStack stack, double x, double y, double z) {
        CompoundTag nbt = stack.m_41783_();
        assert (nbt != null);
        if (x != 0.0) {
            nbt.m_128347_("tetraticTranslateX", x);
        } else if (nbt.m_128441_("tetraticTranslateX")) {
            nbt.m_128473_("tetraticTranslateX");
        }
        if (y != 0.0) {
            nbt.m_128347_("tetraticTranslateY", y);
        } else if (nbt.m_128441_("tetraticTranslateY")) {
            nbt.m_128473_("tetraticTranslateY");
        }
        if (z != 0.0) {
            nbt.m_128347_("tetraticTranslateZ", z);
        } else if (nbt.m_128441_("tetraticTranslateZ")) {
            nbt.m_128473_("tetraticTranslateZ");
        }
        stack.m_41751_(nbt);
    }

    private static double getQuickStat(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            Map map = item2.getEffectData((ItemStack)stack).levelMap;
            if (map.containsKey(ItemEffect.quickStrike)) {
                float level = ((Float)map.get(ItemEffect.quickStrike)).floatValue();
                return (double)level * 0.05 + 0.2;
            }
        }
        return 0.0;
    }

    private static void rescaleUpswing(WeaponAttributes weaponAttributes, double scale) {
        if (!((Boolean)ForgeConfigHolder.COMMON.quickReducesUpswing.get()).booleanValue()) {
            return;
        }
        WeaponAttributes.Attack[] attacks = weaponAttributes.attacks();
        for (int i = 0; i < attacks.length; ++i) {
            double newUpswing = Math.max(0.0, attacks[i].upswing() - attacks[i].upswing() * scale);
            attacks[i] = new WeaponAttributes.Attack(attacks[i].conditions(), attacks[i].hitbox(), attacks[i].damageMultiplier(), attacks[i].angle(), newUpswing, attacks[i].animation(), attacks[i].swingSound(), attacks[i].impactSound());
        }
    }

    private static double getAttackRange(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            if (item2.getAttributeValue(itemStack, (Attribute)ForgeMod.ATTACK_RANGE.get()) != 0.0) {
                return 3.0 + item2.getAttributeValue(itemStack, (Attribute)ForgeMod.ATTACK_RANGE.get());
            }
            if (((Boolean)ForgeConfigHolder.COMMON.reachFallBack.get()).booleanValue()) {
                return 3.0 + item2.getAttributeValue(itemStack, (Attribute)ForgeMod.REACH_DISTANCE.get());
            }
            return 3.0;
        }
        try {
            Multimap attributeMap = itemStack.m_41638_(itemStack.getEquipmentSlot());
            return AttributeHelper.getMergedAmount((Collection)attributeMap.get((Object)((Attribute)ForgeMod.ATTACK_RANGE.get())), (double)3.0);
        }
        catch (Exception e) {
            return 3.0;
        }
    }
}

