/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.tetra.blocks.holo.HolosphereBlock;
import se.mickelus.tetra.blocks.holo.HolosphereBlockEntity;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerOverlayGui;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.properties.TetraAttributes;

@ParametersAreNonnullByDefault
public class ModularHolosphereItem
extends ModularItem {
    public static final String coreKey = "holo/core";
    public static final String frameKey = "holo/frame";
    public static final String scannerKey = "holo/scanner";
    public static final String repositoryKey = "holo/repo";
    public static final String identifier = "holo";
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-14, 0, -14, 18, 4, 0, 4, 18);
    @ObjectHolder(registryName="item", value="tetra:holo")
    public static ModularHolosphereItem instance;

    public ModularHolosphereItem() {
        super(new Item.Properties().m_41487_(1).m_41491_((CreativeModeTab)TetraItemGroup.instance).m_41486_());
        this.canHone = false;
        this.majorModuleKeys = new String[]{coreKey, frameKey, scannerKey, repositoryKey};
        this.minorModuleKeys = new String[0];
        this.requiredModules = new String[]{coreKey, frameKey, scannerKey, repositoryKey};
        RemoveSchematic.registerRemoveSchematics(this, identifier);
    }

    public static ItemStack findHolosphere(Player player, Level level, BlockPos pos) {
        ItemStack itemStack = ModularHolosphereItem.findHolosphere(player);
        return itemStack.m_41619_() ? ModularHolosphereItem.findHolosphere(level, pos) : itemStack;
    }

    public static ItemStack findHolosphere(Level level, BlockPos pos) {
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-2, 0, -2), (BlockPos)pos.m_7918_(2, 4, 2)).map(offsetPos -> new Pair(offsetPos, (Object)level.m_8055_(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).m_60734_() instanceof HolosphereBlock).findFirst().flatMap(pair -> level.m_141902_((BlockPos)pair.getFirst(), (BlockEntityType)HolosphereBlockEntity.type.get())).map(HolosphereBlockEntity::getItemStack).orElse(ItemStack.f_41583_);
    }

    public static ItemStack findHolosphere(Player player) {
        return Stream.of(player.m_150109_().f_35976_.stream(), player.m_150109_().f_35974_.stream(), ToolbeltHelper.getToolbeltItems(player).stream()).flatMap(Function.identity()).filter(stack -> stack.m_41720_() instanceof ModularHolosphereItem).findFirst().orElse(ItemStack.f_41583_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showGui() {
        HoloGui gui = HoloGui.getInstance();
        Minecraft.m_91087_().m_91152_((Screen)gui);
        gui.onShow();
    }

    @Override
    public void commonInit(PacketHandler packetHandler) {
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("holo/");
        });
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            IModularItem.putModuleInSlot(itemStack, coreKey, coreKey, "frame/dim");
            IModularItem.putModuleInSlot(itemStack, frameKey, frameKey, "core/ancient");
            IModularItem.putModuleInSlot(itemStack, scannerKey, scannerKey, "scanner/default");
            IModularItem.putModuleInSlot(itemStack, repositoryKey, repositoryKey, "repo/default");
            items.add((Object)itemStack);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.tetra.holo.tooltip1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)" "));
        if (ScannerOverlayGui.instance != null && ScannerOverlayGui.instance.isAvailable()) {
            tooltip.add((Component)Component.m_237110_((String)"tetra.holo.scan.status", (Object[])new Object[]{ScannerOverlayGui.instance.getStatus()}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237115_((String)"tetra.holo.place"));
        }
        tooltip.add((Component)Component.m_237115_((String)"item.tetra.holo.tooltip2"));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            ModularHolosphereItem.showGui();
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6047_()) {
            return HolosphereBlock.place(new BlockPlaceContext(context));
        }
        return super.m_6225_(context);
    }

    @Override
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    public double getCooldownBase(ItemStack itemStack) {
        return Math.max(0.0, this.getAttributeValue(itemStack, (Attribute)TetraAttributes.abilityCooldown.get()));
    }
}

